/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.tools;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.BasicPixelGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoCodingFactory;
import org.esa.snap.core.datamodel.PixelGeoCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.util.ArrayUtils;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.tools.Bundle;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.product.ProductExpressionPane;
import org.openide.awt.UndoRedo;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class AttachPixelGeoCodingAction
extends AbstractAction
implements ContextAwareAction,
LookupListener {
    private static final String HELP_ID = "pixelGeoCodingSetup";
    private final Lookup lkp;

    public AttachPixelGeoCodingAction() {
        this(Utilities.actionsGlobalContext());
    }

    public AttachPixelGeoCodingAction(Lookup lkp) {
        super(Bundle.CTL_AttachPixelGeoCodingActionText());
        this.lkp = lkp;
        Lookup.Result lkpContext = lkp.lookupResult(ProductNode.class);
        lkpContext.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, (Object)lkpContext));
        this.putValue("ShortDescription", Bundle.CTL_AttachPixelGeoCodingDialogDescription());
        this.setEnableState();
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new AttachPixelGeoCodingAction(actionContext);
    }

    public void resultChanged(LookupEvent ev) {
        this.setEnableState();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Band band;
        Product selectedProduct = ((ProductNode)this.lkp.lookup(ProductNode.class)).getProduct();
        Band[] bands = selectedProduct.getBands();
        int validBandsCount = 0;
        Band[] bandArray = bands;
        int n = bandArray.length;
        for (int i = 0; !(i >= n || (band = bandArray[i]).getRasterSize().equals(selectedProduct.getSceneRasterSize()) && ++validBandsCount == 2); ++i) {
        }
        if (validBandsCount < 2) {
            Dialogs.showError("Pixel Geo-Coding cannot be attached: Too few bands of product scene size");
            return;
        }
        AttachPixelGeoCodingAction.attachPixelGeoCoding(selectedProduct);
    }

    private void setEnableState() {
        Product product;
        ProductNode productNode = (ProductNode)this.lkp.lookup(ProductNode.class);
        boolean state = false;
        if (productNode != null && (product = productNode.getProduct()) != null) {
            boolean hasPixelGeoCoding = product.getSceneGeoCoding() instanceof BasicPixelGeoCoding;
            boolean hasSomeBands = product.getNumBands() >= 2;
            state = !hasPixelGeoCoding && hasSomeBands;
        }
        this.setEnabled(state);
    }

    private static void attachPixelGeoCoding(final Product product) {
        String message;
        Dialogs.Answer answer;
        String dialogTitle;
        SnapApp snapApp = SnapApp.getDefault();
        final Frame mainFrame = snapApp.getMainFrame();
        PixelGeoCodingSetupDialog setupDialog = new PixelGeoCodingSetupDialog(mainFrame, dialogTitle = Bundle.CTL_AttachPixelGeoCodingDialogTitle(), HELP_ID, product);
        if (setupDialog.show() != 1) {
            return;
        }
        final Band lonBand = setupDialog.getSelectedLonBand();
        final Band latBand = setupDialog.getSelectedLatBand();
        final int searchRadius = setupDialog.getSearchRadius();
        final String validMask = setupDialog.getValidMask();
        String msgPattern = "New Pixel Geo-Coding: lon = ''{0}'' ; lat = ''{1}'' ; radius=''{2}'' ; mask=''{3}''";
        snapApp.getLogger().log(Level.INFO, MessageFormat.format("New Pixel Geo-Coding: lon = ''{0}'' ; lat = ''{1}'' ; radius=''{2}'' ; mask=''{3}''", lonBand.getName(), latBand.getName(), searchRadius, validMask));
        long requiredBytes = PixelGeoCoding.getRequiredMemory((Product)product, (validMask != null ? 1 : 0) != 0);
        long requiredMegas = requiredBytes / 0x100000L;
        long freeMegas = Runtime.getRuntime().freeMemory() / 0x100000L;
        if (freeMegas < requiredMegas && (answer = Dialogs.requestDecision(dialogTitle, message = MessageFormat.format("This operation requires to load at least {0} M\nof additional data into memory.\n\nDo you really want to continue?", requiredMegas), false, "load_latlon_band_data")) != Dialogs.Answer.YES) {
            return;
        }
        UIUtils.setRootFrameWaitCursor((Component)mainFrame);
        ProgressMonitorSwingWorker<Void, Void> swingWorker = new ProgressMonitorSwingWorker<Void, Void>((Component)mainFrame, dialogTitle){

            protected Void doInBackground(ProgressMonitor pm) throws Exception {
                BasicPixelGeoCoding pixelGeoCoding = GeoCodingFactory.createPixelGeoCoding((Band)latBand, (Band)lonBand, (String)validMask, (int)searchRadius, (ProgressMonitor)pm);
                product.setSceneGeoCoding((GeoCoding)pixelGeoCoding);
                UndoRedo.Manager undoManager = SnapApp.getDefault().getUndoManager(product);
                if (undoManager != null) {
                    undoManager.addEdit(new UndoableAttachGeoCoding<BasicPixelGeoCoding>(product, pixelGeoCoding));
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done() {
                try {
                    this.get();
                    Dialogs.showInformation(dialogTitle, "Pixel geo-coding has been attached.", null);
                }
                catch (Exception e) {
                    Throwable cause = e;
                    if (e instanceof ExecutionException) {
                        cause = e.getCause();
                    }
                    String msg = "An internal error occurred:\n" + e.getMessage();
                    if (cause instanceof IOException) {
                        msg = "An I/O error occurred:\n" + e.getMessage();
                    }
                    Dialogs.showError(dialogTitle, msg);
                }
                finally {
                    UIUtils.setRootFrameDefaultCursor((Component)mainFrame);
                }
            }
        };
        swingWorker.executeWithBlocking();
    }

    private static class UndoableAttachGeoCoding<T extends BasicPixelGeoCoding>
    extends AbstractUndoableEdit {
        private Product product;
        private T pixelGeoCoding;

        public UndoableAttachGeoCoding(Product product, T pixelGeoCoding) {
            Assert.notNull((Object)product, (String)"product");
            Assert.notNull(pixelGeoCoding, (String)"pixelGeoCoding");
            this.product = product;
            this.pixelGeoCoding = pixelGeoCoding;
        }

        @Override
        public String getPresentationName() {
            return Bundle.CTL_AttachPixelGeoCodingDialogTitle();
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            if (this.product.getSceneGeoCoding() == this.pixelGeoCoding) {
                this.product.setSceneGeoCoding(this.pixelGeoCoding.getPixelPosEstimator());
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.product.setSceneGeoCoding(this.pixelGeoCoding);
        }

        @Override
        public void die() {
            this.pixelGeoCoding = null;
            this.product = null;
        }
    }

    private static class PixelGeoCodingSetupDialog
    extends ModalDialog {
        private Product product;
        private String selectedLonBand;
        private String selectedLatBand;
        private String[] bandNames;
        private JComboBox<String> lonBox;
        private JComboBox<String> latBox;
        private JTextField validMaskField;
        private JSpinner radiusSpinner;
        private final int defaultRadius = 6;
        private final int minRadius = 0;
        private final int maxRadius = 99;
        private final int bigRadiusStep = 0;
        private final int smallRadiusStep = 1;

        public PixelGeoCodingSetupDialog(Window parent, String title, String helpID, Product product) {
            super(parent, title, 161, helpID);
            this.product = product;
            Band[] bands = product.getBands();
            if (product.isMultiSize()) {
                ArrayList<String> bandNameList = new ArrayList<String>();
                for (Band band : bands) {
                    if (!band.getRasterSize().equals(product.getSceneRasterSize())) continue;
                    bandNameList.add(band.getName());
                }
                this.bandNames = bandNameList.toArray(new String[bandNameList.size()]);
            } else {
                this.bandNames = (String[])Arrays.stream(bands).map(ProductNode::getName).toArray(String[]::new);
            }
        }

        public int show() {
            this.createUI();
            return super.show();
        }

        public Band getSelectedLonBand() {
            return this.product.getBand(this.selectedLonBand);
        }

        public Band getSelectedLatBand() {
            return this.product.getBand(this.selectedLatBand);
        }

        public int getSearchRadius() {
            return ((Number)this.radiusSpinner.getValue()).intValue();
        }

        public String getValidMask() {
            return this.validMaskField.getText();
        }

        protected void onOK() {
            String lonValue = (String)this.lonBox.getSelectedItem();
            this.selectedLonBand = this.findBandName(lonValue);
            String latValue = (String)this.latBox.getSelectedItem();
            this.selectedLatBand = this.findBandName(latValue);
            if (this.selectedLatBand == null || this.selectedLonBand == null || Objects.equals(this.selectedLatBand, this.selectedLonBand)) {
                Dialogs.showWarning(Bundle.CTL_AttachPixelGeoCodingDialogTitle(), "You have to select two different bands for the pixel geo-coding.", null);
            } else {
                super.onOK();
            }
        }

        protected void onCancel() {
            this.selectedLatBand = null;
            this.selectedLonBand = null;
            super.onCancel();
        }

        private void createUI() {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = GridBagUtils.createDefaultConstraints();
            JLabel lonLabel = new JLabel("Longitude band:");
            JLabel latLabel = new JLabel("Latitude band:");
            JLabel radiusLabel = new JLabel("Search radius:");
            JLabel maskLabel = new JLabel("Valid mask:");
            this.lonBox = new JComboBox<String>(this.bandNames);
            this.latBox = new JComboBox<String>(this.bandNames);
            this.doPreSelection(this.lonBox, "lon");
            this.doPreSelection(this.latBox, "lat");
            this.radiusSpinner = UIUtils.createSpinner((Number)6, (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(99), (Number)1, (Number)0, (String)"#0");
            this.validMaskField = new JTextField(PixelGeoCodingSetupDialog.createDefaultValidMask(this.product));
            this.validMaskField.setCaretPosition(0);
            JButton exprDialogButton = new JButton("...");
            exprDialogButton.addActionListener(e -> this.invokeExpressionEditor());
            int preferredSize = this.validMaskField.getPreferredSize().height;
            exprDialogButton.setPreferredSize(new Dimension(preferredSize, preferredSize));
            this.radiusSpinner.setPreferredSize(new Dimension(60, preferredSize));
            gbc.insets = new Insets(3, 2, 3, 2);
            gbc.anchor = 17;
            gbc.fill = 2;
            gbc.weightx = 0.0;
            gbc.gridx = 0;
            gbc.gridy = 0;
            panel.add((Component)lonLabel, gbc);
            gbc.weightx = 1.0;
            ++gbc.gridx;
            gbc.gridwidth = 1;
            panel.add(this.lonBox, gbc);
            gbc.weightx = 0.0;
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.gridwidth = 1;
            panel.add((Component)latLabel, gbc);
            gbc.weightx = 1.0;
            ++gbc.gridx;
            gbc.gridwidth = 1;
            panel.add(this.latBox, gbc);
            gbc.weightx = 0.0;
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.gridwidth = 1;
            panel.add((Component)maskLabel, gbc);
            gbc.weightx = 1.0;
            ++gbc.gridx;
            panel.add((Component)this.validMaskField, gbc);
            gbc.weightx = 0.0;
            ++gbc.gridx;
            panel.add((Component)exprDialogButton, gbc);
            gbc.weightx = 0.0;
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.gridwidth = 1;
            panel.add((Component)radiusLabel, gbc);
            gbc.weightx = 1.0;
            ++gbc.gridx;
            gbc.gridwidth = 1;
            gbc.fill = 0;
            gbc.anchor = 13;
            panel.add((Component)this.radiusSpinner, gbc);
            gbc.weightx = 0.0;
            ++gbc.gridx;
            panel.add((Component)new JLabel("pixels"), gbc);
            this.setContent(panel);
        }

        private void invokeExpressionEditor() {
            SnapApp snapApp = SnapApp.getDefault();
            Window window = SwingUtilities.getWindowAncestor(snapApp.getMainFrame());
            ProductExpressionPane pane = ProductExpressionPane.createBooleanExpressionPane((Product[])new Product[]{this.product}, (Product)this.product, (PropertyMap)snapApp.getPreferencesPropertyMap());
            pane.setCode(this.validMaskField.getText());
            int status = pane.showModalDialog(window, "Edit Valid Mask Expression");
            if (status == 1) {
                this.validMaskField.setText(pane.getCode());
                this.validMaskField.setCaretPosition(0);
            }
        }

        private void doPreSelection(JComboBox comboBox, String toFind) {
            String bandToSelect = this.getBandNameContaining(toFind);
            if (StringUtils.isNotNullAndNotEmpty((String)bandToSelect)) {
                comboBox.setSelectedItem(bandToSelect);
            }
        }

        private String getBandNameContaining(String toFind) {
            return Arrays.stream(this.bandNames).filter(s -> s.contains(toFind)).findFirst().orElseGet(() -> null);
        }

        private String findBandName(String bandName) {
            return Arrays.stream(this.bandNames).filter(s -> s.equals(bandName)).findFirst().orElseGet(() -> null);
        }

        private static String createDefaultValidMask(Product product) {
            String validMask = null;
            Object[] flagNames = product.getAllFlagNames();
            String invalidFlagName = "l1_flags.INVALID";
            if (ArrayUtils.isMemberOf((Object)"l1_flags.INVALID", (Object[])flagNames)) {
                validMask = "NOT l1_flags.INVALID";
            }
            return validMask;
        }
    }
}

