/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.help;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.esa.snap.rcp.util.Dialogs;

class DesktopHelper {
    DesktopHelper() {
    }

    public static void browse(String uriString) {
        URI uri;
        Desktop desktop = Desktop.getDesktop();
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            Dialogs.showError(String.format("Internal error: Invalid URI:\n%s", uriString));
            return;
        }
        try {
            desktop.browse(uri);
        }
        catch (IOException e) {
            Dialogs.showError(String.format("<html>Failed to open URL in browser:<br><a href=\"%s\">%s</a>", uriString, uriString));
        }
        catch (UnsupportedOperationException e) {
            Dialogs.showError("Sorry, it seems that there is no browser available.");
        }
    }
}

