/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai.opimage;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;

public final class PaintOpImage
extends PointOpImage {
    private static final boolean DEBUG = false;
    private Color paintColor;
    private boolean alphaIsFirst;
    private final int[] srcBands;
    private int[] paintPixel;

    public PaintOpImage(RenderedImage source0, RenderedImage source1, Map config, ImageLayout layout, Color paintColor, boolean alphaIsFirst) {
        super(source0, source1, layout, config, true);
        if (source0.getSampleModel().getDataType() != 0) {
            throw new IllegalArgumentException("source0 must be of type BYTE");
        }
        if (source1.getSampleModel().getNumBands() > 4) {
            throw new IllegalArgumentException("source0 must have no more than 4 bands");
        }
        if (source1.getSampleModel().getDataType() != 0) {
            throw new IllegalArgumentException("source1 must be of type BYTE");
        }
        if (source1.getSampleModel().getNumBands() != 1) {
            throw new IllegalArgumentException("source1 must only have one band");
        }
        SampleModel sm = source0.getSampleModel();
        int numDestBands = Math.max(sm.getNumBands(), paintColor.getAlpha() == 255 ? 3 : 4);
        if (this.sampleModel.getNumBands() != numDestBands) {
            this.sampleModel = RasterFactory.createComponentSampleModel((SampleModel)this.sampleModel, (int)sm.getDataType(), (int)this.tileWidth, (int)this.tileHeight, (int)numDestBands);
            if (this.colorModel != null && !this.colorModel.isCompatibleSampleModel(this.sampleModel)) {
                this.colorModel = PaintOpImage.createColorModel((SampleModel)this.sampleModel);
            }
        }
        this.paintColor = paintColor;
        this.alphaIsFirst = alphaIsFirst;
        int numSourceBands = source0.getSampleModel().getNumBands();
        this.srcBands = new int[numDestBands];
        int iOffset = numDestBands > numSourceBands && alphaIsFirst ? numDestBands - numSourceBands : 0;
        Arrays.fill(this.srcBands, -1);
        for (int i = 0; i < numSourceBands; ++i) {
            this.srcBands[i + iOffset] = i;
        }
        this.paintPixel = numDestBands == 3 ? new int[]{paintColor.getRed(), paintColor.getGreen(), paintColor.getBlue()} : (alphaIsFirst ? new int[]{paintColor.getAlpha(), paintColor.getRed(), paintColor.getGreen(), paintColor.getBlue()} : new int[]{paintColor.getRed(), paintColor.getGreen(), paintColor.getBlue(), paintColor.getAlpha()});
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source0 = sources[0];
        Raster source1 = sources[1];
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        RasterAccessor src0Accessor = new RasterAccessor(source0, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor src1Accessor = new RasterAccessor(source1, srcRect, formatTags[1], this.getSourceImage(1).getColorModel());
        RasterAccessor dstAccessor = new RasterAccessor((Raster)dest, destRect, formatTags[2], this.getColorModel());
        this.byteLoop(src0Accessor, src1Accessor, dstAccessor);
        if (dstAccessor.isDataCopy()) {
            dstAccessor.clampDataArrays();
            dstAccessor.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor src0, RasterAccessor src1, RasterAccessor dst) {
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int dnumBands = dst.getNumBands();
        int snumBands = src0.getNumBands();
        int paintAlpha = this.paintColor.getAlpha();
        byte[][] dstDataArrays = dst.getByteDataArrays();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        byte[][] src0DataArrays = src0.getByteDataArrays();
        int[] src0BandOffsets = src0.getBandOffsets();
        int src0PixelStride = src0.getPixelStride();
        int src0ScanlineStride = src0.getScanlineStride();
        byte[][] src1DataArrays = src1.getByteDataArrays();
        int[] src1BandOffsets = src1.getBandOffsets();
        int src1PixelStride = src1.getPixelStride();
        int src1ScanlineStride = src1.getScanlineStride();
        for (int dstBand = 0; dstBand < dnumBands; ++dstBand) {
            int srcBand = this.srcBands[dstBand];
            byte[] src0Data = srcBand >= 0 ? src0DataArrays[srcBand] : null;
            byte[] src1Data = src1DataArrays[0];
            byte[] dstData = dstDataArrays[dstBand];
            int src0ScanlineOffset = dstBand < snumBands ? src0BandOffsets[dstBand] : 0;
            int src1ScanlineOffset = src1BandOffsets[0];
            int dstScanlineOffset = dstBandOffsets[dstBand];
            for (int y = 0; y < dheight; ++y) {
                if (src0Data != null) {
                    int src0PixelOffset = src0ScanlineOffset;
                    int src1PixelOffset = src1ScanlineOffset;
                    int dstPixelOffset = dstScanlineOffset;
                    for (int x = 0; x < dwidth; ++x) {
                        int src0Val = src0Data[src0PixelOffset] & 0xFF;
                        int src1Val = src1Data[src1PixelOffset] & 0xFF;
                        int dstVal = (src1Val * src0Val + (255 - src1Val) * this.paintPixel[dstBand]) / 255;
                        dstData[dstPixelOffset] = (byte)dstVal;
                        src0PixelOffset += src0PixelStride;
                        src1PixelOffset += src1PixelStride;
                        dstPixelOffset += dstPixelStride;
                    }
                    src0ScanlineOffset += src0ScanlineStride;
                    src1ScanlineOffset += src1ScanlineStride;
                    dstScanlineOffset += dstScanlineStride;
                    continue;
                }
                int src1PixelOffset = src1ScanlineOffset;
                int dstPixelOffset = dstScanlineOffset;
                for (int i = 0; i < dwidth; ++i) {
                    int src0Val = 255;
                    int src1Val = src1Data[src1PixelOffset] & 0xFF;
                    int dstVal = (src1Val * src0Val + (255 - src1Val) * this.paintPixel[dstBand]) / 255;
                    dstData[dstPixelOffset] = (byte)dstVal;
                    src1PixelOffset += src1PixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                src1ScanlineOffset += src1ScanlineStride;
                dstScanlineOffset += dstScanlineStride;
            }
        }
    }
}

