/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.update;

import com.bc.ceres.core.Assert;
import com.bc.ceres.swing.update.ModuleItem;
import com.bc.ceres.swing.update.ModuleTableColumnDef;
import com.bc.ceres.swing.update.ModuleTextFactory;
import com.bc.ceres.swing.update.ModuleValueAccessor;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

class ModuleTableModel
extends AbstractTableModel {
    static Map<String, ModuleTableColumnDef> availableColumnDefs = new HashMap<String, ModuleTableColumnDef>(32);
    private ModuleTableColumnDef[] moduleTableColumns;
    private ModuleItem[] moduleItems;

    public ModuleTableModel(ModuleItem[] moduleItems, String[] columnNames) {
        Assert.notNull((Object)moduleItems);
        Assert.notNull((Object)columnNames);
        this.moduleItems = moduleItems;
        this.moduleTableColumns = new ModuleTableColumnDef[columnNames.length];
        for (int i = 0; i < this.moduleTableColumns.length; ++i) {
            ModuleTableColumnDef moduleTableColumn = availableColumnDefs.get(columnNames[i]);
            Assert.notNull((Object)moduleTableColumn);
            this.moduleTableColumns[i] = moduleTableColumn;
        }
    }

    @Override
    public int getRowCount() {
        return this.moduleItems.length;
    }

    @Override
    public int getColumnCount() {
        return this.moduleTableColumns.length;
    }

    public ModuleItem[] getModuleItems() {
        return this.moduleItems;
    }

    public void setModuleItems(ModuleItem[] moduleItems) {
        this.moduleItems = moduleItems;
        this.fireTableDataChanged();
    }

    public ModuleItem getModuleItem(int rowIndex) {
        return this.moduleItems[rowIndex];
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.getColumn(columnIndex).getName();
    }

    private ModuleTableColumnDef getColumn(int columnIndex) {
        return this.moduleTableColumns[columnIndex];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ModuleItem moduleItem = this.moduleItems[rowIndex];
        ModuleTableColumnDef column = this.getColumn(columnIndex);
        return column.getValue(moduleItem);
    }

    private static void defineColumn(String name, Class<?> type, ModuleValueAccessor accessor) {
        ModuleTableColumnDef value = new ModuleTableColumnDef(name, type, accessor);
        availableColumnDefs.put(name, value);
    }

    static {
        ModuleTableModel.defineColumn("Name", String.class, new ModuleValueAccessor(){

            @Override
            public Object getValue(ModuleItem moduleItem) {
                return ModuleTextFactory.getNameText(moduleItem);
            }
        });
        ModuleTableModel.defineColumn("Funding", String.class, new ModuleValueAccessor(){

            @Override
            public Object getValue(ModuleItem moduleItem) {
                return ModuleTextFactory.getFundingText(moduleItem);
            }
        });
        ModuleTableModel.defineColumn("Version", String.class, new ModuleValueAccessor(){

            @Override
            public Object getValue(ModuleItem moduleItem) {
                return ModuleTextFactory.getVersionText(moduleItem);
            }
        });
        ModuleTableModel.defineColumn("New Version", String.class, new ModuleValueAccessor(){

            @Override
            public Object getValue(ModuleItem moduleItem) {
                return ModuleTextFactory.getUpdateVersionText(moduleItem);
            }
        });
        ModuleTableModel.defineColumn("Date", String.class, new ModuleValueAccessor(){

            @Override
            public Object getValue(ModuleItem moduleItem) {
                return ModuleTextFactory.getDateText(moduleItem);
            }
        });
        ModuleTableModel.defineColumn("Size", String.class, new ModuleValueAccessor(){

            @Override
            public Object getValue(ModuleItem moduleItem) {
                return ModuleTextFactory.getSizeText(moduleItem);
            }
        });
        ModuleTableModel.defineColumn("State", String.class, new ModuleValueAccessor(){

            @Override
            public Object getValue(ModuleItem moduleItem) {
                return ModuleTextFactory.getStateText(moduleItem);
            }
        });
        ModuleTableModel.defineColumn("Action", String.class, new ModuleValueAccessor(){

            @Override
            public Object getValue(ModuleItem moduleItem) {
                return ModuleTextFactory.getActionText(moduleItem);
            }
        });
    }
}

