/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.update;

import com.bc.ceres.core.runtime.ProxyConfig;
import com.bc.ceres.swing.SwingHelper;
import com.bc.ceres.swing.update.ConnectionConfigData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ConnectionConfigPane
extends JPanel {
    private ConnectionConfigData connectionConfigData;
    private JTextField repositoryUrl;
    private JCheckBox proxyUsed;
    private JTextField proxyPort;
    private JTextField proxyHost;
    private JCheckBox proxyAuthUsed;
    private JTextField username;
    private JPasswordField password;
    private boolean confirmed;
    private ValidtationHandler validationHandler;

    public ConnectionConfigPane(ConnectionConfigData connectionConfigData) {
        this.initUI();
        this.setConfigData(connectionConfigData);
    }

    public ValidtationHandler getValidationHandler() {
        return this.validationHandler;
    }

    public void setValidationHandler(ValidtationHandler validationHandler) {
        this.validationHandler = validationHandler;
    }

    public ConnectionConfigData getConfigData() {
        return this.connectionConfigData;
    }

    public void setConfigData(ConnectionConfigData connectionConfigData) {
        this.connectionConfigData = connectionConfigData;
        this.transferConfigDataToUi();
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public boolean validateUiState() {
        if (this.proxyUsed.isSelected()) {
            String u;
            String ph = this.proxyHost.getText().trim();
            if (ph.length() == 0) {
                this.onValidationError("Invalid proxy host.");
                this.proxyHost.requestFocusInWindow();
                return false;
            }
            String pp = this.proxyPort.getText().trim();
            if (pp.length() == 0) {
                this.onValidationError("Invalid proxy port.");
                this.proxyPort.requestFocusInWindow();
                return false;
            }
            try {
                int port = Integer.parseInt(pp);
                if (port <= 0) {
                    this.onValidationError("Invalid proxy port.");
                    this.proxyPort.requestFocusInWindow();
                    return false;
                }
            }
            catch (NumberFormatException e) {
                this.onValidationError("Invalid proxy port.");
                this.proxyPort.requestFocusInWindow();
                return false;
            }
            if (this.proxyAuthUsed.isSelected() && (u = this.username.getText().trim()).length() == 0) {
                this.onValidationError("Invalid username.");
                this.username.requestFocusInWindow();
                return false;
            }
        }
        return true;
    }

    public void updateUiState() {
        boolean pu = this.proxyUsed.isSelected();
        boolean pau = pu && this.proxyAuthUsed.isSelected();
        this.repositoryUrl.setEnabled(true);
        this.proxyUsed.setEnabled(true);
        this.proxyHost.setEnabled(pu);
        this.proxyPort.setEnabled(pu);
        this.proxyAuthUsed.setEnabled(pu);
        this.username.setEnabled(pau);
        this.password.setEnabled(pau);
    }

    public void transferConfigDataToUi() {
        this.transferConfigDataToUi(this.connectionConfigData);
    }

    public void transferConfigDataToUi(ConnectionConfigData connectionConfigData) {
        ProxyConfig proxyConfig = connectionConfigData.getProxyConfig();
        this.repositoryUrl.setText(connectionConfigData.getRepositoryUrl());
        this.proxyUsed.setSelected(connectionConfigData.isProxyUsed());
        this.proxyPort.setText(String.valueOf(proxyConfig.getPort()));
        this.proxyHost.setText(proxyConfig.getHost());
        this.proxyAuthUsed.setSelected(proxyConfig.isAuthorizationUsed());
        this.username.setText(proxyConfig.getUsername());
        this.password.setText(new String(proxyConfig.getPassword() != null ? proxyConfig.getPassword() : new char[]{}));
        this.updateUiState();
    }

    public void transferUiToConfigData() {
        this.transferUiToConfigData(this.connectionConfigData);
    }

    public void transferUiToConfigData(ConnectionConfigData connectionConfigData) {
        ProxyConfig proxyConfig = connectionConfigData.getProxyConfig();
        connectionConfigData.setProxyUsed(this.proxyUsed.isSelected());
        proxyConfig.setHost(this.proxyHost.getText());
        proxyConfig.setPort(Integer.parseInt(this.proxyPort.getText()));
        proxyConfig.setAuthorizationUsed(this.proxyAuthUsed.isSelected());
        proxyConfig.setUsername(this.username.getText());
        proxyConfig.setPassword(this.password.getPassword());
    }

    public boolean showDialog(Window parent, String title, ActionListener helpHandler) {
        JDialog dialog = this.createDialog(parent, title, helpHandler);
        dialog.pack();
        SwingHelper.centerComponent(dialog, parent);
        dialog.setVisible(true);
        dialog.dispose();
        return this.confirmed;
    }

    public JDialog createDialog(Window parent, String title, ActionListener helpHandler) {
        final JDialog dialog = new JDialog(parent, title, Dialog.ModalityType.APPLICATION_MODAL);
        JPanel buttonPane = new JPanel(new FlowLayout(2));
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConnectionConfigPane.this.validateUiState()) {
                    ConnectionConfigPane.this.transferUiToConfigData();
                    dialog.setVisible(false);
                    ConnectionConfigPane.this.setConfirmed(true);
                }
            }
        });
        buttonPane.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        });
        buttonPane.add(cancelButton);
        if (helpHandler != null) {
            JButton helpButton = new JButton("Help");
            helpButton.addActionListener(helpHandler);
            buttonPane.add(helpButton);
        }
        JPanel contentPane = new JPanel(new BorderLayout(4, 4));
        contentPane.add((Component)this, "Center");
        contentPane.add((Component)buttonPane, "South");
        contentPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        okButton.setDefaultCapable(true);
        dialog.getRootPane().setDefaultButton(okButton);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                dialog.setVisible(false);
            }
        });
        dialog.setContentPane(contentPane);
        this.setConfirmed(false);
        return dialog;
    }

    private void initUI() {
        ChangeListener updateStateChangeHandler = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ConnectionConfigPane.this.updateUiState();
            }
        };
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.insets.right = 2;
        c.insets.top = 0;
        c.insets.bottom = 2;
        c.gridy = 0;
        c.gridx = 0;
        c.gridwidth = 2;
        panel.add((Component)new JLabel("Module repository URL:"), c);
        c.gridy = 1;
        c.gridx = 0;
        c.gridwidth = 2;
        this.repositoryUrl = new JTextField(50);
        this.repositoryUrl.setEditable(false);
        panel.add((Component)this.repositoryUrl, c);
        c.insets.top = 10;
        c.gridy = 2;
        c.gridx = 0;
        c.gridwidth = 2;
        this.proxyUsed = new JCheckBox("Use HTTP proxy");
        this.proxyUsed.setAlignmentX(0.0f);
        this.proxyUsed.addChangeListener(updateStateChangeHandler);
        panel.add((Component)this.proxyUsed, c);
        c.insets.top = 0;
        c.insets.bottom = 2;
        c.gridy = 3;
        c.gridx = 0;
        c.gridwidth = 1;
        c.insets.left = 12;
        panel.add((Component)new JLabel("Proxy host:"), c);
        c.gridx = 1;
        c.gridwidth = 1;
        c.insets.left = 0;
        this.proxyHost = new JTextField(50);
        panel.add((Component)this.proxyHost, c);
        c.gridy = 4;
        c.gridx = 0;
        c.gridwidth = 1;
        c.insets.left = 12;
        panel.add((Component)new JLabel("Proxy port:"), c);
        c.gridx = 1;
        c.gridwidth = 1;
        c.insets.left = 0;
        this.proxyPort = new JTextField(6);
        panel.add((Component)this.proxyPort, c);
        c.gridy = 5;
        c.gridx = 0;
        c.gridwidth = 2;
        c.insets.left = 12;
        this.proxyAuthUsed = new JCheckBox("Use HTTP proxy authentication");
        this.proxyAuthUsed.addChangeListener(updateStateChangeHandler);
        panel.add((Component)this.proxyAuthUsed, c);
        c.gridy = 6;
        c.gridx = 0;
        c.gridwidth = 1;
        c.insets.left = 24;
        panel.add((Component)new JLabel("User name:"), c);
        c.gridx = 1;
        c.gridwidth = 1;
        c.insets.left = 0;
        this.username = new JTextField(12);
        panel.add((Component)this.username, c);
        c.gridy = 7;
        c.gridx = 0;
        c.gridwidth = 1;
        c.insets.left = 24;
        panel.add((Component)new JLabel("Password:"), c);
        c.gridx = 1;
        c.gridwidth = 1;
        c.insets.left = 0;
        this.password = new JPasswordField(12);
        panel.add((Component)this.password, c);
        this.setLayout(new BorderLayout(2, 2));
        this.add((Component)panel, "Center");
    }

    private void onValidationError(String message) {
        if (this.validationHandler != null) {
            this.validationHandler.onError(message);
        } else {
            JOptionPane.showMessageDialog(this, message, "Update Configuration", 0);
        }
    }

    public static interface ValidtationHandler {
        public void onError(String var1);
    }
}

