/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.progress;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.ProgressDialog;
import java.awt.Component;
import java.awt.Dialog;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class DialogProgressMonitor
implements ProgressMonitor {
    private ProgressDialog progressDialog;
    private JLabel messageLabel;
    private double currentWork;
    private double totalWork;
    private int totalWorkUI;
    private int currentWorkUI;
    private int lastWorkUI;

    public DialogProgressMonitor(Component parentComponent, String title, Dialog.ModalityType modalityType) {
        this.messageLabel = new JLabel();
        this.progressDialog = new ProgressDialog(parentComponent);
        this.progressDialog.setTitle(title);
        this.progressDialog.setMinimum(0);
        this.progressDialog.setMaximum(250);
        this.progressDialog.setModalityType(modalityType);
        this.progressDialog.setMessageComponent(this.messageLabel);
    }

    public DialogProgressMonitor(ProgressDialog progressDialog) {
        this.progressDialog = progressDialog;
        JComponent messageComponent = progressDialog.getMessageComponent();
        if (messageComponent instanceof JLabel) {
            this.messageLabel = (JLabel)messageComponent;
        }
    }

    public void beginTask(final String name, int totalWork) {
        Assert.notNull((Object)name, (String)"name");
        this.currentWork = 0.0;
        this.totalWork = totalWork;
        this.currentWorkUI = 0;
        this.lastWorkUI = 0;
        this.totalWorkUI = this.progressDialog.getMaximum() - this.progressDialog.getMinimum();
        DialogProgressMonitor.runInUI(new Runnable(){

            @Override
            public void run() {
                if (DialogProgressMonitor.this.progressDialog != null) {
                    if (DialogProgressMonitor.this.currentWorkUI < DialogProgressMonitor.this.totalWorkUI) {
                        if (DialogProgressMonitor.this.messageLabel != null) {
                            DialogProgressMonitor.this.messageLabel.setText(name);
                        }
                        DialogProgressMonitor.this.progressDialog.show();
                    } else {
                        DialogProgressMonitor.this.progressDialog.close();
                        DialogProgressMonitor.this.progressDialog = null;
                    }
                }
            }
        });
    }

    public void done() {
        DialogProgressMonitor.runInUI(new Runnable(){

            @Override
            public void run() {
                if (DialogProgressMonitor.this.progressDialog != null) {
                    DialogProgressMonitor.this.progressDialog.close();
                    DialogProgressMonitor.this.progressDialog = null;
                }
            }
        });
    }

    public void internalWorked(double work) {
        this.currentWork += work;
        this.currentWorkUI = (int)((double)this.totalWorkUI * this.currentWork / (this.totalWork > 0.0 ? this.totalWork : (double)this.totalWorkUI));
        if (this.currentWorkUI > this.lastWorkUI) {
            this.lastWorkUI = this.currentWorkUI;
            DialogProgressMonitor.runInUI(new Runnable(){

                @Override
                public void run() {
                    if (DialogProgressMonitor.this.progressDialog != null) {
                        int progress = DialogProgressMonitor.this.progressDialog.getMinimum() + DialogProgressMonitor.this.currentWorkUI;
                        DialogProgressMonitor.this.progressDialog.setProgress(progress);
                    }
                }
            });
        }
    }

    public boolean isCanceled() {
        return this.progressDialog != null && this.progressDialog.isCanceled();
    }

    public void setCanceled(boolean canceled) {
        if (canceled && this.progressDialog != null) {
            this.progressDialog.cancel();
            if (this.progressDialog.isCanceled()) {
                this.done();
            }
        }
    }

    public void setTaskName(final String name) {
        DialogProgressMonitor.runInUI(new Runnable(){

            @Override
            public void run() {
                if (DialogProgressMonitor.this.messageLabel != null) {
                    DialogProgressMonitor.this.messageLabel.setText(name);
                }
            }
        });
    }

    public void setSubTaskName(final String name) {
        DialogProgressMonitor.runInUI(new Runnable(){

            @Override
            public void run() {
                if (DialogProgressMonitor.this.progressDialog != null) {
                    DialogProgressMonitor.this.progressDialog.setNote(name);
                }
            }
        });
    }

    public void worked(int work) {
        this.internalWorked(work);
    }

    void setModalityType(Dialog.ModalityType modalityType) {
        this.progressDialog.setModalityType(modalityType);
    }

    private static void runInUI(Runnable task) {
        if (SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            SwingUtilities.invokeLater(task);
        }
    }
}

