/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.support;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ExtensibleObject;
import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureChangeEvent;
import com.bc.ceres.swing.figure.FigureChangeListener;
import com.bc.ceres.swing.figure.FigureCollection;
import com.bc.ceres.swing.figure.FigureEditor;
import com.bc.ceres.swing.figure.FigureSelection;
import com.bc.ceres.swing.figure.support.DefaultFigureCollection;
import com.bc.ceres.swing.figure.support.DefaultFigureSelection;
import com.bc.ceres.swing.figure.support.FigureTransferable;
import com.bc.ceres.swing.selection.Selection;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import com.bc.ceres.swing.selection.SelectionContext;
import com.bc.ceres.swing.selection.support.SelectionChangeSupport;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class FigureSelectionContext
extends ExtensibleObject
implements SelectionContext {
    private final FigureEditor figureEditor;
    private final FigureCollection figureCollection;
    private final FigureSelection figureSelection;
    private final SelectionChangeSupport selectionChangeSupport;

    public FigureSelectionContext(FigureEditor figureEditor) {
        this(figureEditor, new DefaultFigureCollection(), new DefaultFigureSelection());
    }

    public FigureSelectionContext(FigureEditor figureEditor, FigureCollection figureCollection, FigureSelection figureSelection) {
        Assert.notNull((Object)figureEditor, (String)"figureEditor");
        Assert.notNull((Object)figureCollection, (String)"figureCollection");
        Assert.notNull((Object)figureSelection, (String)"figureSelection");
        this.figureEditor = figureEditor;
        this.figureCollection = figureCollection;
        this.figureSelection = figureSelection;
        this.figureSelection.addChangeListener(new FigureSelectionMulticaster());
        this.selectionChangeSupport = new SelectionChangeSupport(figureEditor);
    }

    public FigureEditor getFigureEditor() {
        return this.figureEditor;
    }

    public FigureCollection getFigureCollection() {
        return this.figureCollection;
    }

    public FigureSelection getFigureSelection() {
        return this.figureSelection;
    }

    @Override
    public Selection getSelection() {
        return this.figureSelection;
    }

    @Override
    public void setSelection(Selection selection) {
    }

    @Override
    public void addSelectionChangeListener(SelectionChangeListener listener) {
        this.selectionChangeSupport.addSelectionChangeListener(listener);
    }

    @Override
    public void removeSelectionChangeListener(SelectionChangeListener listener) {
        this.selectionChangeSupport.removeSelectionChangeListener(listener);
    }

    @Override
    public SelectionChangeListener[] getSelectionChangeListeners() {
        return this.selectionChangeSupport.getSelectionChangeListeners();
    }

    @Override
    public void insert(Transferable contents) throws IOException, UnsupportedFlavorException {
        Figure[] figures = (Figure[])contents.getTransferData(FigureTransferable.FIGURES_DATA_FLAVOR);
        if (figures != null && figures.length > 0) {
            this.figureEditor.insertFigures(true, figures);
        }
    }

    @Override
    public boolean canDeleteSelection() {
        return !this.getFigureSelection().isEmpty();
    }

    @Override
    public void deleteSelection() {
        Figure[] figures = this.getFigureSelection().getFigures();
        if (figures.length > 0) {
            this.figureEditor.deleteFigures(true, figures);
        }
    }

    @Override
    public boolean canInsert(Transferable contents) {
        return contents.isDataFlavorSupported(FigureTransferable.FIGURES_DATA_FLAVOR);
    }

    @Override
    public void selectAll() {
        this.figureSelection.removeAllFigures();
        this.figureSelection.addFigures(this.getFigureCollection().getFigures());
        this.figureSelection.setSelectionStage(this.figureSelection.getMaxSelectionStage());
    }

    @Override
    public boolean canSelectAll() {
        return this.getFigureCollection().getFigureCount() > 0;
    }

    private class FigureSelectionMulticaster
    implements FigureChangeListener {
        private FigureSelectionMulticaster() {
        }

        @Override
        public void figureChanged(FigureChangeEvent event) {
            if (event.getType() == FigureChangeEvent.FIGURES_ADDED || event.getType() == FigureChangeEvent.FIGURES_REMOVED) {
                FigureSelectionContext.this.selectionChangeSupport.fireSelectionChange(FigureSelectionContext.this, FigureSelectionContext.this.figureSelection);
            }
        }
    }
}

