/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.support;

import com.bc.ceres.swing.figure.AbstractPointFigure;
import com.bc.ceres.swing.figure.FigureStyle;
import com.bc.ceres.swing.figure.support.DefaultFigureStyle;
import java.awt.geom.Point2D;

public class DefaultPointFigure
extends AbstractPointFigure {
    private final Point2D.Double location;
    private final double radius;

    public DefaultPointFigure(Point2D location, double radius) {
        this(location, radius, DefaultFigureStyle.createFromCSS("symbol:star; fill-color:#0000FF; stroke-color:#FFFFFF"));
    }

    public DefaultPointFigure(Point2D location, double radius, FigureStyle style) {
        this(location, radius, style, style);
    }

    public DefaultPointFigure(Point2D location, double radius, FigureStyle normalStyle, FigureStyle selectedStyle) {
        super(normalStyle, selectedStyle);
        this.location = new Point2D.Double(location.getX(), location.getY());
        this.radius = radius;
        this.setSelectable(true);
    }

    @Override
    public double getX() {
        return this.location.x;
    }

    @Override
    public double getY() {
        return this.location.y;
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public void setLocation(double x, double y) {
        this.location.setLocation(x, y);
        this.fireFigureChanged();
    }
}

