/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.support;

import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyAccessor;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.ValueRange;
import com.bc.ceres.binding.accessors.MapEntryAccessor;
import com.bc.ceres.swing.figure.FigureStyle;
import com.bc.ceres.swing.figure.Symbol;
import com.bc.ceres.swing.figure.support.CssColorConverter;
import com.bc.ceres.swing.figure.support.ImageSymbol;
import com.bc.ceres.swing.figure.support.NamedSymbol;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class DefaultFigureStyle
extends PropertyContainer
implements FigureStyle {
    public static final PropertyDescriptor FILL_COLOR = DefaultFigureStyle.createFillColorDescriptor();
    public static final PropertyDescriptor FILL_OPACITY = DefaultFigureStyle.createFillOpacityDescriptor();
    public static final PropertyDescriptor STROKE_COLOR = DefaultFigureStyle.createStrokeColorDescriptor();
    public static final PropertyDescriptor STROKE_OPACITY = DefaultFigureStyle.createStrokeOpacityDescriptor();
    public static final PropertyDescriptor STROKE_WIDTH = DefaultFigureStyle.createStrokeWidthDescriptor();
    public static final PropertyDescriptor SYMBOL_NAME = DefaultFigureStyle.createSymbolNameDescriptor();
    public static final PropertyDescriptor SYMBOL_IMAGE = DefaultFigureStyle.createSymbolImageDescriptor();
    public static final PropertyDescriptor SYMBOL_REF_X = DefaultFigureStyle.createSymbolRefXDescriptor();
    public static final PropertyDescriptor SYMBOL_REF_Y = DefaultFigureStyle.createSymbolRefYDescriptor();
    private static final DefaultFigureStyle PROTOTYPE = new DefaultFigureStyle();
    private FigureStyle parentStyle;
    private String name;
    private Map<String, Object> values;
    private Stroke stroke;
    private Paint strokePaint;
    private Paint fillPaint;
    private Symbol symbol;

    public DefaultFigureStyle() {
        this("");
    }

    public DefaultFigureStyle(String name) {
        this(name, PROTOTYPE);
    }

    public DefaultFigureStyle(FigureStyle parentStyle) {
        this(null, parentStyle);
    }

    public DefaultFigureStyle(String name, FigureStyle parentStyle) {
        this.name = name != null ? name : (parentStyle != null ? parentStyle.getName() : "");
        this.parentStyle = parentStyle != null ? parentStyle : PROTOTYPE;
        this.values = new HashMap<String, Object>();
        this.addPropertyChangeListener(new EffectivePropertyNuller());
    }

    @Deprecated
    public static FigureStyle createFromCSS(String css) {
        return DefaultFigureStyle.createFromCss(css);
    }

    public static FigureStyle createFromCss(String css) {
        DefaultFigureStyle figureStyle = new DefaultFigureStyle();
        figureStyle.fromCssString(css);
        return figureStyle;
    }

    public static FigureStyle createPointStyle(Symbol symbol) {
        return DefaultFigureStyle.createPointStyle(symbol, null, null, null);
    }

    public static FigureStyle createPointStyle(Symbol symbol, Paint strokePaint, Stroke stroke) {
        return DefaultFigureStyle.createPointStyle(symbol, null, strokePaint, stroke);
    }

    public static FigureStyle createPointStyle(Symbol symbol, Paint fillPaint, Paint strokePaint, Stroke stroke) {
        DefaultFigureStyle figureStyle = DefaultFigureStyle.setSymbol(symbol);
        DefaultFigureStyle.setStroke(figureStyle, strokePaint, stroke);
        DefaultFigureStyle.setFill(figureStyle, fillPaint);
        return figureStyle;
    }

    public static FigureStyle createLineStyle(Paint strokePaint) {
        return DefaultFigureStyle.createLineStyle(strokePaint, null);
    }

    public static FigureStyle createLineStyle(Paint strokePaint, Stroke stroke) {
        DefaultFigureStyle figureStyle = new DefaultFigureStyle("line-style");
        DefaultFigureStyle.setStroke(figureStyle, strokePaint, stroke);
        DefaultFigureStyle.setFill(figureStyle, null);
        return figureStyle;
    }

    public static DefaultFigureStyle createPolygonStyle(Paint fillPaint) {
        return DefaultFigureStyle.createPolygonStyle(fillPaint, null);
    }

    public static DefaultFigureStyle createPolygonStyle(Paint fillPaint, Paint strokePaint) {
        return DefaultFigureStyle.createPolygonStyle(fillPaint, strokePaint, null);
    }

    public static DefaultFigureStyle createPolygonStyle(Paint fillPaint, Paint strokePaint, Stroke stroke) {
        DefaultFigureStyle figureStyle = new DefaultFigureStyle("polygon-style");
        DefaultFigureStyle.setFill(figureStyle, fillPaint);
        DefaultFigureStyle.setStroke(figureStyle, strokePaint, stroke);
        return figureStyle;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public <T> T getValue(String name) {
        if (this.isPropertyDefined(name)) {
            return (T)super.getValue(name);
        }
        Property property = this.parentStyle.getProperty(name);
        if (property != null) {
            return (T)property.getValue();
        }
        return null;
    }

    public void setValue(String name, Object value) throws IllegalArgumentException {
        if (this.isPropertyDefined(name)) {
            super.setValue(name, value);
            return;
        }
        Property property = this.parentStyle.getProperty(name);
        if (property != null) {
            this.defineProperty(property.getDescriptor(), value);
        }
    }

    @Override
    public Symbol getSymbol() {
        if (this.symbol == null) {
            this.symbol = this.getEffectiveSymbol(this.getSymbolName(), this.getSymbolImagePath(), this.getSymbolRefX(), this.getSymbolRefY());
        }
        return this.symbol;
    }

    @Override
    public String getSymbolName() {
        return this.getValue(SYMBOL_NAME.getName(), null);
    }

    public void setSymbolName(String symbolName) {
        this.setValue(SYMBOL_NAME.getName(), symbolName);
    }

    @Override
    public String getSymbolImagePath() {
        return this.getValue(SYMBOL_IMAGE.getName(), null);
    }

    public void setSymbolImagePath(String symbolName) {
        this.setValue(SYMBOL_IMAGE.getName(), symbolName);
    }

    @Override
    public double getSymbolRefX() {
        return this.getValue(SYMBOL_REF_X.getName(), 0.0);
    }

    public void setSymbolRefX(double refX) {
        this.setValue(SYMBOL_REF_X.getName(), refX);
    }

    @Override
    public double getSymbolRefY() {
        return this.getValue(SYMBOL_REF_Y.getName(), 0.0);
    }

    public void setSymbolRefY(double refY) {
        this.setValue(SYMBOL_REF_Y.getName(), refY);
    }

    @Override
    public Stroke getStroke() {
        if (this.stroke == null) {
            this.stroke = DefaultFigureStyle.getEffectiveStroke(this.getStrokeWidth());
        }
        return this.stroke;
    }

    @Override
    public Stroke getStroke(double scale) {
        Stroke stroke = this.getStroke();
        if (scale != 1.0 && stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)stroke;
            return new BasicStroke((float)((double)basicStroke.getLineWidth() * scale), basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase());
        }
        return stroke;
    }

    @Override
    public Paint getStrokePaint() {
        Color strokeColor;
        if (this.strokePaint == null && (strokeColor = this.getStrokeColor()) != null) {
            this.strokePaint = DefaultFigureStyle.getEffectivePaint(strokeColor, this.getStrokeOpacity());
        }
        return this.strokePaint;
    }

    @Override
    public Color getStrokeColor() {
        Object value = this.getValue(STROKE_COLOR.getName());
        if (value instanceof Color) {
            return (Color)value;
        }
        return null;
    }

    public void setStrokeColor(Color strokeColor) {
        this.setValue(STROKE_COLOR.getName(), strokeColor);
    }

    @Override
    public double getStrokeOpacity() {
        return this.getValue(STROKE_OPACITY.getName(), 1.0);
    }

    public void setStrokeOpacity(double opacity) {
        this.setValue(STROKE_OPACITY.getName(), opacity);
    }

    @Override
    public double getStrokeWidth() {
        String name1 = STROKE_WIDTH.getName();
        double defaultValue = 0.0;
        return this.getValue(name1, defaultValue);
    }

    public void setStrokeWidth(double width) {
        this.setValue(STROKE_WIDTH.getName(), width);
    }

    @Override
    public Paint getFillPaint() {
        Color fillColor;
        if (this.fillPaint == null && (fillColor = this.getFillColor()) != null) {
            this.fillPaint = DefaultFigureStyle.getEffectivePaint(fillColor, this.getFillOpacity());
        }
        return this.fillPaint;
    }

    @Override
    public Color getFillColor() {
        Object value = this.getValue(FILL_COLOR.getName());
        if (value instanceof Color) {
            return (Color)value;
        }
        return null;
    }

    public void setFillColor(Color fillColor) {
        this.setValue(FILL_COLOR.getName(), fillColor);
    }

    @Override
    public double getFillOpacity() {
        return this.getValue(FILL_OPACITY.getName(), 1.0);
    }

    public void setFillOpacity(double opacity) {
        this.setValue(FILL_OPACITY.getName(), opacity);
    }

    @Override
    public String toCssString() {
        Map<String, Property> all = this.getOrderedPropertyMap();
        Set<Map.Entry<String, Property>> entries = all.entrySet();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Property> entry : entries) {
            Property property = entry.getValue();
            Object value = property.getValue();
            if (value == null) continue;
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(entry.getKey());
            sb.append(":");
            sb.append(property.getValueAsText());
        }
        return sb.toString();
    }

    @Override
    public void fromCssString(String css) {
        this.resetAllEffectiveProperties();
        StringTokenizer st = new StringTokenizer(css, ";", false);
        while (st.hasMoreElements()) {
            String token = st.nextToken();
            int i = token.indexOf(58);
            if (i <= 0) continue;
            String name = token.substring(0, i).trim();
            String textValue = token.substring(i + 1).trim();
            Property property = this.getProperty(name);
            try {
                Converter converter;
                if (property != null) {
                    property.setValueFromText(textValue);
                    continue;
                }
                property = PROTOTYPE.getProperty(name);
                if (property == null || (converter = property.getDescriptor().getConverter()) == null) continue;
                Object value = converter.parse(textValue);
                this.defineProperty(property.getDescriptor(), value);
            }
            catch (Exception exception) {}
        }
    }

    private synchronized Map<String, Property> getOrderedPropertyMap() {
        TreeMap<String, Property> propertyMap = new TreeMap<String, Property>();
        if (this.parentStyle != PROTOTYPE) {
            DefaultFigureStyle.collectProperties(this.parentStyle.getProperties(), propertyMap);
        }
        DefaultFigureStyle.collectProperties(this.getProperties(), propertyMap);
        return propertyMap;
    }

    private static void collectProperties(Property[] properties, Map<String, Property> propertyMap) {
        for (Property property : properties) {
            propertyMap.put(property.getName(), property);
        }
    }

    private static DefaultFigureStyle setSymbol(Symbol symbol) {
        DefaultFigureStyle figureStyle = new DefaultFigureStyle("point-style");
        if (symbol instanceof NamedSymbol) {
            NamedSymbol namedSymbol = (NamedSymbol)symbol;
            figureStyle.setSymbolName(namedSymbol.getName());
        } else if (symbol instanceof ImageSymbol) {
            ImageSymbol imageSymbol = (ImageSymbol)symbol;
            figureStyle.setSymbolImagePath(imageSymbol.getResourcePath());
            figureStyle.setSymbolRefX(imageSymbol.getRefX());
            figureStyle.setSymbolRefY(imageSymbol.getRefY());
        }
        figureStyle.symbol = symbol;
        return figureStyle;
    }

    private static void setFill(DefaultFigureStyle figureStyle, Paint fillPaint) {
        if (fillPaint instanceof Color) {
            Color fillColor = (Color)fillPaint;
            if (fillColor.getAlpha() == 255) {
                figureStyle.setFillColor(fillColor);
            } else {
                figureStyle.setFillColor(new Color(fillColor.getRed(), fillColor.getGreen(), fillColor.getBlue()));
                figureStyle.setFillOpacity(DefaultFigureStyle.getOpacity(fillColor));
            }
        } else if (fillPaint == null) {
            figureStyle.setFillColor(null);
        }
        figureStyle.fillPaint = fillPaint;
    }

    private static void setStroke(DefaultFigureStyle figureStyle, Paint strokePaint, Stroke stroke) {
        if (strokePaint instanceof Color) {
            Color strokeColor = (Color)strokePaint;
            if (strokeColor.getAlpha() == 255) {
                figureStyle.setStrokeColor(strokeColor);
            } else {
                figureStyle.setStrokeColor(new Color(strokeColor.getRed(), strokeColor.getGreen(), strokeColor.getBlue()));
                figureStyle.setStrokeOpacity(DefaultFigureStyle.getOpacity(strokeColor));
            }
        } else if (strokePaint == null) {
            figureStyle.setStrokeColor(null);
        }
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)stroke;
            figureStyle.setStrokeWidth(basicStroke.getLineWidth());
        }
        figureStyle.strokePaint = strokePaint;
        figureStyle.stroke = stroke;
    }

    private static double getOpacity(Color strokeColor) {
        return (double)Math.round(0.39215686274509803 * (double)strokeColor.getAlpha()) / 100.0;
    }

    private void initPrototypeProperties() {
        Field[] declaredFields;
        for (Field declaredField : declaredFields = DefaultFigureStyle.class.getDeclaredFields()) {
            if (declaredField.getType() != PropertyDescriptor.class) continue;
            try {
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)declaredField.get(null);
                propertyDescriptor.setDefaultConverter();
                if (Color.class.isAssignableFrom(propertyDescriptor.getType())) {
                    propertyDescriptor.setConverter((Converter)new CssColorConverter());
                }
                this.defineProperty(propertyDescriptor, propertyDescriptor.getDefaultValue());
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        this.setDefaultValues();
    }

    private void defineProperty(PropertyDescriptor propertyDescriptor, Object value) {
        MapEntryAccessor accessor = new MapEntryAccessor(this.values, propertyDescriptor.getName());
        Property property = new Property(propertyDescriptor, (PropertyAccessor)accessor);
        this.addProperty(property);
        this.setValue(property.getName(), value);
    }

    private Symbol getEffectiveSymbol(String symbolName, String symbolImagePath, double symbolRefX, double symbolRefY) {
        if (symbolName != null) {
            return NamedSymbol.getSymbol(symbolName);
        }
        if (symbolImagePath != null) {
            return ImageSymbol.createIcon(symbolImagePath, symbolRefX, symbolRefY, this.getClass());
        }
        return null;
    }

    private static Paint getEffectivePaint(Color color, double opacity) {
        int alpha = Math.min(Math.max((int)(opacity * 255.0), 0), 255);
        if (color.getAlpha() == alpha) {
            return color;
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    private static Stroke getEffectiveStroke(double width) {
        return new BasicStroke((float)width);
    }

    private void resetAllEffectiveProperties() {
        this.resetEffectiveStrokeProperties();
        this.resetEffectiveFillProperties();
        this.resetEffectiveSymbolProperties();
    }

    private void resetEffectiveSymbolProperties() {
        this.symbol = null;
    }

    private void resetEffectiveStrokeProperties() {
        this.stroke = null;
        this.strokePaint = null;
    }

    private void resetEffectiveFillProperties() {
        this.fillPaint = null;
    }

    private static PropertyDescriptor createFillColorDescriptor() {
        return DefaultFigureStyle.createPropertyDescriptor("fill", Color.class, Color.BLACK, false);
    }

    private static PropertyDescriptor createFillOpacityDescriptor() {
        PropertyDescriptor descriptor = DefaultFigureStyle.createPropertyDescriptor("fill-opacity", Double.class, 1.0, false);
        descriptor.setValueRange(new ValueRange(0.0, 1.0));
        return descriptor;
    }

    private static PropertyDescriptor createStrokeColorDescriptor() {
        return DefaultFigureStyle.createPropertyDescriptor("stroke", Color.class, null, false);
    }

    private static PropertyDescriptor createStrokeOpacityDescriptor() {
        PropertyDescriptor descriptor = DefaultFigureStyle.createPropertyDescriptor("stroke-opacity", Double.class, 1.0, false);
        descriptor.setValueRange(new ValueRange(0.0, 1.0));
        return descriptor;
    }

    private static PropertyDescriptor createStrokeWidthDescriptor() {
        PropertyDescriptor descriptor = DefaultFigureStyle.createPropertyDescriptor("stroke-width", Double.class, 0.0, false);
        descriptor.setValueRange(new ValueRange(0.0, Double.POSITIVE_INFINITY));
        return descriptor;
    }

    private static PropertyDescriptor createSymbolNameDescriptor() {
        return DefaultFigureStyle.createPropertyDescriptor("symbol", String.class, null, false);
    }

    private static PropertyDescriptor createSymbolImageDescriptor() {
        return DefaultFigureStyle.createPropertyDescriptor("symbol-image", String.class, null, false);
    }

    private static PropertyDescriptor createSymbolRefXDescriptor() {
        return DefaultFigureStyle.createPropertyDescriptor("symbol-ref-x", Double.class, 0.0, false);
    }

    private static PropertyDescriptor createSymbolRefYDescriptor() {
        return DefaultFigureStyle.createPropertyDescriptor("symbol-ref-y", Double.class, 0.0, false);
    }

    private static PropertyDescriptor createPropertyDescriptor(String propertyName, Class type, Object defaultValue, boolean notNull) {
        PropertyDescriptor descriptor = new PropertyDescriptor(propertyName, type);
        descriptor.setDefaultValue(defaultValue);
        descriptor.setNotNull(notNull);
        return descriptor;
    }

    private double getValue(String name1, double defaultValue) {
        Object value = this.getValue(name1);
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return defaultValue;
    }

    private String getValue(String name, String defaultValue) {
        Object value = this.getValue(name);
        if (value instanceof String) {
            return (String)value;
        }
        return defaultValue;
    }

    public boolean equals(Object obj) {
        Property[] properties;
        if (!(obj instanceof DefaultFigureStyle)) {
            return false;
        }
        DefaultFigureStyle other = (DefaultFigureStyle)obj;
        for (Property property : properties = this.getProperties()) {
            Property otherProperty = other.getProperty(property.getName());
            if (otherProperty != null && (otherProperty.getValue() == null || property.getValue() != null) && (property.getValue() == null || property.getValue().equals(otherProperty.getValue()))) continue;
            return false;
        }
        return true;
    }

    static {
        PROTOTYPE.initPrototypeProperties();
    }

    private class EffectivePropertyNuller
    implements PropertyChangeListener {
        private EffectivePropertyNuller() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().startsWith("stroke")) {
                DefaultFigureStyle.this.resetEffectiveStrokeProperties();
            } else if (evt.getPropertyName().startsWith("fill")) {
                DefaultFigureStyle.this.resetEffectiveFillProperties();
            } else if (evt.getPropertyName().startsWith("symbol")) {
                DefaultFigureStyle.this.resetEffectiveSymbolProperties();
            }
        }
    }
}

