/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.figure.interactions;

import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureEditor;
import com.bc.ceres.swing.figure.FigureEditorInteractor;
import com.bc.ceres.swing.figure.ShapeFigure;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;

public class InsertLineFigureInteractor
extends FigureEditorInteractor {
    private boolean canceled;
    private Figure figure;
    private boolean started;

    @Override
    public void cancelInteraction(InputEvent event) {
        if (!this.canceled) {
            this.canceled = true;
            this.getFigureEditor(event).getFigureSelection().removeAllFigures();
            this.getFigureEditor(event).getFigureCollection().removeFigure(this.figure);
            super.cancelInteraction(event);
        }
    }

    @Override
    protected void stopInteraction(InputEvent inputEvent) {
        super.stopInteraction(inputEvent);
        this.started = false;
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.canceled = false;
        this.started = this.startInteraction(event);
        if (this.started) {
            FigureEditor figureEditor = this.getFigureEditor(event);
            figureEditor.getFigureSelection().removeAllFigures();
            Point2D referencePoint = this.toModelPoint(event);
            Path2D.Double linePath = new Path2D.Double();
            ((Path2D)linePath).moveTo(referencePoint.getX(), referencePoint.getY());
            ((Path2D)linePath).lineTo(referencePoint.getX(), referencePoint.getY());
            ShapeFigure lineFigure = figureEditor.getFigureFactory().createLineFigure(linePath, figureEditor.getDefaultLineStyle());
            if (lineFigure != null) {
                this.figure = lineFigure;
                figureEditor.getFigureCollection().addFigure(this.figure);
            } else {
                this.started = false;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.started) {
            FigureEditor figureEditor = this.getFigureEditor(event);
            figureEditor.insertFigures(false, this.figure);
            this.stopInteraction(event);
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this.started) {
            double[] segment = this.figure.getSegment(1);
            Point2D referencePoint = this.toModelPoint(event);
            segment[0] = referencePoint.getX();
            segment[1] = referencePoint.getY();
            this.figure.setSegment(1, segment);
        }
    }
}

