/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.binding.internal;

import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.swing.binding.Binding;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.PropertyEditor;
import com.bc.ceres.swing.binding.internal.TextComponentAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FileEditor
extends PropertyEditor {
    @Override
    public boolean isValidFor(PropertyDescriptor propertyDescriptor) {
        return File.class.isAssignableFrom(propertyDescriptor.getType()) && !Boolean.TRUE.equals(propertyDescriptor.getAttribute("directory"));
    }

    @Override
    public JComponent createEditorComponent(PropertyDescriptor propertyDescriptor, BindingContext bindingContext) {
        JTextField textField = new JTextField();
        TextComponentAdapter adapter = new TextComponentAdapter(textField);
        Binding binding = bindingContext.bind(propertyDescriptor.getName(), adapter);
        JPanel editorPanel = new JPanel(new BorderLayout(2, 2));
        editorPanel.add((Component)textField, "Center");
        JButton etcButton = new JButton("...");
        Dimension size = new Dimension(26, 16);
        etcButton.setPreferredSize(size);
        etcButton.setMinimumSize(size);
        etcButton.addActionListener(e -> {
            JFileChooser fileChooser = new JFileChooser();
            File currentFile = (File)binding.getPropertyValue();
            if (currentFile != null) {
                fileChooser.setSelectedFile(currentFile);
            } else {
                File selectedFile = (File)propertyDescriptor.getDefaultValue();
                fileChooser.setSelectedFile(selectedFile);
            }
            int i = fileChooser.showDialog(editorPanel, "Select");
            if (i == 0 && fileChooser.getSelectedFile() != null) {
                binding.setPropertyValue(fileChooser.getSelectedFile());
            }
        });
        editorPanel.add((Component)etcButton, "East");
        return editorPanel;
    }
}

