/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.binding.internal;

import com.bc.ceres.binding.BindingException;
import com.bc.ceres.core.Assert;
import com.bc.ceres.swing.binding.Binding;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.BindingProblem;
import com.bc.ceres.swing.binding.BindingProblemListener;
import com.bc.ceres.swing.binding.ComponentAdapter;
import com.bc.ceres.swing.binding.internal.BindingProblemImpl;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;

public final class BindingImpl
implements Binding,
PropertyChangeListener {
    private final BindingContext context;
    private final String name;
    private final ComponentAdapter componentAdapter;
    private List<JComponent> secondaryComponents;
    private boolean adjustingComponents;
    private BindingProblem problem;

    public BindingImpl(BindingContext context, String name, ComponentAdapter componentAdapter) {
        Assert.notNull((Object)context, (String)"context");
        Assert.notNull((Object)name, (String)"name");
        Assert.notNull((Object)componentAdapter, (String)"componentAdapter");
        this.context = context;
        this.name = name;
        this.componentAdapter = componentAdapter;
    }

    public void bindProperty() {
        this.context.addPropertyChangeListener(this.name, this);
    }

    public void unbindProperty() {
        this.context.removePropertyChangeListener(this.name, this);
    }

    @Override
    public BindingProblem getProblem() {
        return this.problem;
    }

    @Override
    public void clearProblem() {
        BindingProblem oldProblem = this.problem;
        if (oldProblem != null) {
            this.problem = null;
            this.fireProblemCleared(oldProblem);
        }
    }

    @Override
    public BindingProblem reportProblem(BindingException cause) {
        Assert.notNull((Object)((Object)cause), (String)"cause");
        BindingProblemImpl newProblem = new BindingProblemImpl(this, cause);
        BindingProblem oldProblem = this.problem;
        if (oldProblem == null || !((Object)newProblem).equals(oldProblem)) {
            this.problem = newProblem;
            this.fireProblemReported(newProblem, oldProblem);
        }
        return newProblem;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.adjustComponents();
    }

    @Override
    public ComponentAdapter getComponentAdapter() {
        return this.componentAdapter;
    }

    @Override
    public final BindingContext getContext() {
        return this.context;
    }

    @Override
    public final String getPropertyName() {
        return this.name;
    }

    @Override
    public Object getPropertyValue() {
        return this.context.getPropertySet().getValue(this.getPropertyName());
    }

    @Override
    public void setPropertyValue(Object value) {
        block2: {
            try {
                this.context.getPropertySet().setValue(this.getPropertyName(), value);
                this.clearProblem();
            }
            catch (IllegalArgumentException e) {
                if (!(e.getCause() instanceof BindingException)) break block2;
                this.reportProblem((BindingException)e.getCause());
            }
        }
    }

    @Override
    public boolean isAdjustingComponents() {
        return this.adjustingComponents;
    }

    @Override
    public void adjustComponents() {
        if (!this.adjustingComponents && this.componentAdapter.getBinding() != null) {
            try {
                this.adjustingComponents = true;
                this.componentAdapter.adjustComponents();
                this.clearProblem();
            }
            finally {
                this.adjustingComponents = false;
            }
        }
    }

    @Override
    public JComponent[] getComponents() {
        if (this.secondaryComponents == null) {
            return this.componentAdapter.getComponents();
        }
        JComponent[] primaryComponents = this.componentAdapter.getComponents();
        JComponent[] allComponents = new JComponent[primaryComponents.length + this.secondaryComponents.size()];
        System.arraycopy(primaryComponents, 0, allComponents, 0, primaryComponents.length);
        int j = primaryComponents.length;
        Iterator<JComponent> iterator = this.secondaryComponents.iterator();
        while (iterator.hasNext()) {
            JComponent component;
            allComponents[j] = component = iterator.next();
            ++j;
        }
        return allComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addComponent(JComponent component) {
        BindingImpl bindingImpl = this;
        synchronized (bindingImpl) {
            if (this.secondaryComponents == null) {
                this.secondaryComponents = new ArrayList<JComponent>(3);
            }
            if (!this.secondaryComponents.contains(component)) {
                this.secondaryComponents.add(component);
            }
        }
    }

    @Override
    public void removeComponent(JComponent component) {
        if (this.secondaryComponents != null) {
            this.secondaryComponents.remove(component);
        }
    }

    void fireProblemReported(BindingProblem newProblem, BindingProblem oldProblem) {
        for (BindingProblemListener listener : this.context.getProblemListeners()) {
            listener.problemReported(newProblem, oldProblem);
        }
    }

    void fireProblemCleared(BindingProblem oldProblem) {
        for (BindingProblemListener listener : this.context.getProblemListeners()) {
            listener.problemCleared(oldProblem);
        }
    }
}

