/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.swing.binding;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.core.Assert;
import com.bc.ceres.swing.binding.Binding;
import com.bc.ceres.swing.binding.BindingProblem;
import com.bc.ceres.swing.binding.BindingProblemListener;
import com.bc.ceres.swing.binding.ComponentAdapter;
import com.bc.ceres.swing.binding.Enablement;
import com.bc.ceres.swing.binding.internal.AbstractButtonAdapter;
import com.bc.ceres.swing.binding.internal.BindingImpl;
import com.bc.ceres.swing.binding.internal.ButtonGroupAdapter;
import com.bc.ceres.swing.binding.internal.ComboBoxAdapter;
import com.bc.ceres.swing.binding.internal.FormattedTextFieldAdapter;
import com.bc.ceres.swing.binding.internal.ListSelectionAdapter;
import com.bc.ceres.swing.binding.internal.SpinnerAdapter;
import com.bc.ceres.swing.binding.internal.TextComponentAdapter;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class BindingContext {
    private final PropertySet propertySet;
    private Map<String, BindingImpl> bindings;
    private Map<String, EnablementImpl> enablements;
    private ArrayList<BindingProblemListener> bindingProblemListeners;

    public BindingContext() {
        this((PropertySet)new PropertyContainer());
    }

    public BindingContext(PropertySet propertySet) {
        this(propertySet, new VerbousProblemHandler());
    }

    public BindingContext(PropertySet propertySet, BindingProblemListener problemHandler) {
        this.propertySet = propertySet;
        this.bindings = new HashMap<String, BindingImpl>(17);
        this.enablements = new HashMap<String, EnablementImpl>(11);
        if (problemHandler != null) {
            this.addProblemListener(problemHandler);
        }
    }

    public PropertySet getPropertySet() {
        return this.propertySet;
    }

    public boolean hasProblems() {
        for (Map.Entry<String, BindingImpl> entry : this.bindings.entrySet()) {
            if (entry.getValue().getProblem() == null) continue;
            return true;
        }
        return false;
    }

    public BindingProblem[] getProblems() {
        ArrayList<BindingProblem> list = new ArrayList<BindingProblem>();
        for (Map.Entry<String, BindingImpl> entry : this.bindings.entrySet()) {
            BindingProblem problem = entry.getValue().getProblem();
            if (problem == null) continue;
            list.add(problem);
        }
        return list.toArray(new BindingProblem[list.size()]);
    }

    public void addProblemListener(BindingProblemListener listener) {
        Assert.notNull((Object)listener, (String)"listener");
        if (this.bindingProblemListeners == null) {
            this.bindingProblemListeners = new ArrayList();
        }
        this.bindingProblemListeners.add(listener);
    }

    public void removeProblemListener(BindingProblemListener listener) {
        Assert.notNull((Object)listener, (String)"listener");
        if (this.bindingProblemListeners != null) {
            this.bindingProblemListeners.remove(listener);
        }
    }

    public BindingProblemListener[] getProblemListeners() {
        return this.bindingProblemListeners != null ? this.bindingProblemListeners.toArray(new BindingProblemListener[this.bindingProblemListeners.size()]) : new BindingProblemListener[]{};
    }

    public void adjustComponents() {
        for (Map.Entry<String, BindingImpl> entry : this.bindings.entrySet()) {
            entry.getValue().adjustComponents();
        }
    }

    public Binding getBinding(String propertyName) {
        Assert.notNull((Object)propertyName, (String)"propertyName");
        return this.bindings.get(propertyName);
    }

    public Binding bind(String propertyName, ComponentAdapter componentAdapter) {
        Assert.notNull((Object)propertyName, (String)"propertyName");
        Assert.notNull((Object)componentAdapter, (String)"componentAdapter");
        BindingImpl binding = new BindingImpl(this, propertyName, componentAdapter);
        this.addBinding(binding);
        componentAdapter.setBinding(binding);
        componentAdapter.bindComponents();
        binding.bindProperty();
        binding.adjustComponents();
        this.configureComponents(binding);
        return binding;
    }

    public void unbind(Binding binding) {
        Assert.notNull((Object)binding, (String)"binding");
        this.removeBinding(binding.getPropertyName());
        if (binding instanceof BindingImpl) {
            ((BindingImpl)binding).unbindProperty();
        }
        binding.getComponentAdapter().unbindComponents();
        binding.getComponentAdapter().setBinding(null);
    }

    public Binding bind(String propertyName, JTextComponent component) {
        return this.bind(propertyName, new TextComponentAdapter(component));
    }

    public Binding bind(String propertyName, JTextField component) {
        return this.bind(propertyName, new TextComponentAdapter(component));
    }

    public Binding bind(String propertyName, JFormattedTextField component) {
        return this.bind(propertyName, new FormattedTextFieldAdapter(component));
    }

    public Binding bind(String propertyName, JCheckBox component) {
        return this.bind(propertyName, new AbstractButtonAdapter(component));
    }

    public Binding bind(String propertyName, JRadioButton component) {
        return this.bind(propertyName, new AbstractButtonAdapter(component));
    }

    public Binding bind(String propertyName, JList component, boolean selectionIsValue) {
        if (selectionIsValue) {
            return this.bind(propertyName, new ListSelectionAdapter(component));
        }
        throw new RuntimeException("not implemented");
    }

    public Binding bind(String propertyName, JSpinner component) {
        return this.bind(propertyName, new SpinnerAdapter(component));
    }

    public Binding bind(String propertyName, JComboBox component) {
        return this.bind(propertyName, new ComboBoxAdapter(component));
    }

    public Binding bind(String propertyName, ButtonGroup buttonGroup) {
        return this.bind(propertyName, buttonGroup, ButtonGroupAdapter.createButtonToValueMap(buttonGroup, this.getPropertySet(), propertyName));
    }

    public Binding bind(String propertyName, ButtonGroup buttonGroup, Map<AbstractButton, Object> valueSet) {
        ButtonGroupAdapter adapter = new ButtonGroupAdapter(buttonGroup, valueSet);
        return this.bind(propertyName, adapter);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertySet.addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener l) {
        this.propertySet.addPropertyChangeListener(name, l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertySet.removePropertyChangeListener(l);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener l) {
        this.propertySet.removePropertyChangeListener(name, l);
    }

    public void permitPropertyChanges(JComponent component) {
        component.setVerifyInputWhenFocusTarget(true);
    }

    public void preventPropertyChanges(JComponent component) {
        component.setVerifyInputWhenFocusTarget(false);
    }

    private void configureComponents(Binding binding) {
        String propertyName = binding.getPropertyName();
        String toolTipTextStr = this.getToolTipText(propertyName);
        boolean enabled = this.isEnabled(propertyName);
        JComponent[] components = binding.getComponents();
        JComponent primaryComponent = components[0];
        BindingContext.configureComponent(primaryComponent, propertyName, toolTipTextStr, enabled);
        for (int i = 1; i < components.length; ++i) {
            JComponent component = components[i];
            BindingContext.configureComponent(component, propertyName + "." + i, toolTipTextStr, enabled);
        }
    }

    private String getToolTipText(String propertyName) {
        Property property = this.propertySet.getProperty(propertyName);
        StringBuilder toolTipText = new StringBuilder(32);
        PropertyDescriptor propertyDescriptor = property.getDescriptor();
        if (propertyDescriptor.getDescription() != null) {
            toolTipText.append(propertyDescriptor.getDescription());
        }
        if (propertyDescriptor.getUnit() != null && !propertyDescriptor.getUnit().isEmpty()) {
            toolTipText.append(" (");
            toolTipText.append(propertyDescriptor.getUnit());
            toolTipText.append(")");
        }
        return toolTipText.toString();
    }

    private boolean isEnabled(String propertyName) {
        Property property = this.propertySet.getProperty(propertyName);
        PropertyDescriptor propertyDescriptor = property.getDescriptor();
        Object enabled = propertyDescriptor.getAttribute("enabled");
        return enabled == null || !Boolean.FALSE.equals(enabled);
    }

    private static void configureComponent(JComponent component, String name, String toolTipText, boolean enabled) {
        if (component.getName() == null) {
            component.setName(name);
        }
        if (component.getToolTipText() == null && !toolTipText.isEmpty()) {
            component.setToolTipText(toolTipText);
        }
        component.setEnabled(enabled);
    }

    public Enablement bindEnabledState(String targetPropertyName, boolean targetState, String sourcePropertyName, Object sourcePropertyValue) {
        return this.bindEnabledState(targetPropertyName, targetState, new EqualValuesCondition(sourcePropertyName, sourcePropertyValue));
    }

    public Enablement bindEnabledState(String targetPropertyName, boolean targetState, Enablement.Condition condition) {
        EnablementImpl enablement = new EnablementImpl(targetPropertyName, targetState, condition);
        Binding binding = this.getBinding(targetPropertyName);
        if (binding != null) {
            this.activateEnablement(enablement);
        }
        this.enablements.put(targetPropertyName, enablement);
        return enablement;
    }

    public void setComponentsEnabled(String propertyName, boolean enabled) {
        JComponent[] components;
        for (JComponent component : components = this.getBinding(propertyName).getComponents()) {
            component.setEnabled(enabled);
        }
    }

    private void setComponentsEnabled(String targetPropertyName, boolean targetState, Enablement.Condition condition) {
        JComponent[] components;
        boolean conditionIsTrue = condition.evaluate(this);
        for (JComponent component : components = this.getBinding(targetPropertyName).getComponents()) {
            component.setEnabled(conditionIsTrue ? targetState : !targetState);
        }
    }

    private void addBinding(BindingImpl binding) {
        this.bindings.put(binding.getPropertyName(), binding);
        EnablementImpl enablement = this.enablements.get(binding.getPropertyName());
        if (enablement != null && !enablement.isActive()) {
            this.activateEnablement(enablement);
        }
    }

    private void removeBinding(String propertyName) {
        this.bindings.remove(propertyName);
        EnablementImpl enablement = this.enablements.get(propertyName);
        if (enablement != null) {
            this.deactivateEnablement(enablement);
        }
    }

    private void activateEnablement(EnablementImpl enablement) {
        enablement.setActive(true);
        enablement.apply();
        enablement.getCondition().install(this, enablement);
    }

    private void deactivateEnablement(EnablementImpl enablement) {
        enablement.setActive(false);
        enablement.getCondition().uninstall(this, enablement);
    }

    private static class EqualValuesCondition
    extends Enablement.Condition {
        private final String sourcePropertyName;
        private final Object sourcePropertyValue;

        private EqualValuesCondition(String sourcePropertyName, Object sourcePropertyValue) {
            this.sourcePropertyName = sourcePropertyName;
            this.sourcePropertyValue = sourcePropertyValue;
        }

        @Override
        public boolean evaluate(BindingContext bindingContext) {
            Object propertyValue = bindingContext.getPropertySet().getValue(this.sourcePropertyName);
            return propertyValue == this.sourcePropertyValue || propertyValue != null && propertyValue.equals(this.sourcePropertyValue);
        }

        @Override
        public void install(BindingContext bindingContext, Enablement enablement) {
            bindingContext.addPropertyChangeListener(this.sourcePropertyName, enablement);
        }

        @Override
        public void uninstall(BindingContext bindingContext, Enablement enablement) {
            bindingContext.removePropertyChangeListener(this.sourcePropertyName, enablement);
        }
    }

    private class EnablementImpl
    implements Enablement {
        private final String targetPropertyName;
        private final boolean targetState;
        private final Enablement.Condition condition;
        private boolean active;

        private EnablementImpl(String targetPropertyName, boolean targetState, Enablement.Condition condition) {
            this.targetPropertyName = targetPropertyName;
            this.targetState = targetState;
            this.condition = condition;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public Enablement.Condition getCondition() {
            return this.condition;
        }

        @Override
        public final void propertyChange(PropertyChangeEvent evt) {
            this.apply();
        }

        @Override
        public void apply() {
            BindingContext.this.setComponentsEnabled(this.targetPropertyName, this.targetState, this.condition);
        }
    }

    public static class SilentProblemHandler
    implements BindingProblemListener {
        @Override
        public void problemReported(BindingProblem newProblem, BindingProblem oldProblem) {
            newProblem.getBinding().adjustComponents();
        }

        @Override
        public void problemCleared(BindingProblem oldProblem) {
        }
    }

    public static class VerbousProblemHandler
    implements BindingProblemListener {
        @Override
        public void problemReported(BindingProblem newProblem, BindingProblem oldProblem) {
            Binding binding = newProblem.getBinding();
            ComponentAdapter adapter = binding.getComponentAdapter();
            JComponent component = adapter.getComponents()[0];
            Window window = SwingUtilities.windowForComponent(component);
            JOptionPane.showMessageDialog(window, newProblem.getCause().getMessage(), "Invalid Input", 0);
        }

        @Override
        public void problemCleared(BindingProblem oldProblem) {
        }
    }
}

