/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.gpf;

import java.io.File;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.engine_utilities.db.CommonReaders;
import org.esa.snap.engine_utilities.util.ProductFunctions;
import org.esa.snap.engine_utilities.util.TestUtils;

public abstract class RecursiveProcessor {
    public int recurseProcessFolder(File folder, int iterations, int maxIteration, String[] productTypeExemptions, String[] exceptionExemptions) throws Exception {
        File[] fileList = folder.listFiles(new ProductFunctions.ValidProductFileFilter(true));
        if (fileList == null) {
            return iterations;
        }
        for (File file : fileList) {
            if (maxIteration > 0 && iterations >= maxIteration) break;
            if (file.isDirectory()) {
                if (file.getName().contains("skipTest")) continue;
                iterations = this.recurseProcessFolder(file, iterations, maxIteration, productTypeExemptions, exceptionExemptions);
                continue;
            }
            try {
                Product sourceProduct = CommonReaders.readProduct(file);
                if (sourceProduct == null || productTypeExemptions != null && TestUtils.containsProductType(productTypeExemptions, sourceProduct.getProductType())) continue;
                this.process(sourceProduct);
                ++iterations;
            }
            catch (Exception e) {
                boolean ok = false;
                if (exceptionExemptions != null) {
                    for (String exemption : exceptionExemptions) {
                        if (!e.getMessage().contains(exemption)) continue;
                        ok = true;
                        System.out.println("Exemption for " + e.getMessage());
                        break;
                    }
                }
                if (ok) continue;
                System.out.println("Failed to process " + file.toString());
                throw e;
            }
        }
        return iterations;
    }

    protected abstract void process(Product var1);
}

