/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.gpf;

import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.MapGeoCoding;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.Unit;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.StackUtils;

public class InputProductValidator {
    private final Product product;
    private final MetadataElement absRoot;
    private static final String SHOULD_BE_SAR_PRODUCT = "Input should be a SAR product";
    private static final String SHOULD_NOT_BE_LEVEL0 = "Level-0 RAW products are not supported";
    private static final String SHOULD_BE_COREGISTERED = "Input should be a coregistered stack.";
    private static final String SHOULD_BE_SLC = "Input should be a single look complex SLC product.";
    private static final String SHOULD_BE_GRD = "Input should be a detected product.";
    private static final String SHOULD_BE_S1 = "Input should be a Sentinel-1 product.";
    private static final String SHOULD_BE_DEBURST = "Source product should first be deburst.";
    private static final String SHOULD_BE_MULTISWATH_SLC = "Source product should be multi sub-swath SLC burst product.";
    private static final String SHOULD_BE_QUAD_POL = "Input should be a full pol SLC product.";
    private static final String SHOULD_BE_CALIBRATED = "Source product should be calibrated.";
    private static final String SHOULD_NOT_BE_CALIBRATED = "Source product has already been calibrated.";
    private static final String SHOULD_BE_MAP_PROJECTED = "Source product should be map projected.";
    private static final String SHOULD_NOT_BE_MAP_PROJECTED = "Source product should not be map projected.";
    private static final String SHOULD_BE_COMPATIBLE = "Source products do not have compatible dimensions and geocoding.";
    private static final float geographicError = 0.001f;

    public InputProductValidator(Product product) throws OperatorException {
        this.product = product;
        this.absRoot = AbstractMetadata.getAbstractedMetadata(product);
    }

    public boolean isSARProduct() {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata(this.product);
        return absRoot != null && absRoot.getAttributeDouble("radar_frequency", 99999.0) != 99999.0;
    }

    public void checkIfSARProduct() {
        if ("RAW".equals(this.product.getProductType())) {
            throw new OperatorException(SHOULD_NOT_BE_LEVEL0);
        }
        if (!this.isSARProduct()) {
            throw new OperatorException(SHOULD_BE_SAR_PRODUCT);
        }
    }

    public void checkIfCoregisteredStack() throws OperatorException {
        if (!StackUtils.isCoregisteredStack(this.product)) {
            throw new OperatorException(SHOULD_BE_COREGISTERED);
        }
    }

    public boolean isComplex() {
        String sampleType;
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata(this.product);
        return absRoot != null && (sampleType = absRoot.getAttributeString("SAMPLE_TYPE", "-").trim()).equalsIgnoreCase("complex");
    }

    public void checkIfSLC() throws OperatorException {
        if (!this.isComplex()) {
            throw new OperatorException(SHOULD_BE_SLC);
        }
    }

    public void checkIfGRD() throws OperatorException {
        if (this.isComplex()) {
            throw new OperatorException(SHOULD_BE_GRD);
        }
    }

    public boolean isMultiSwath() {
        String[] bandNames = this.product.getBandNames();
        return InputProductValidator.contains(bandNames, "IW1") && InputProductValidator.contains(bandNames, "IW2") || InputProductValidator.contains(bandNames, "EW1") && InputProductValidator.contains(bandNames, "EW2");
    }

    public boolean isSentinel1Product() throws OperatorException {
        String mission = this.absRoot.getAttributeString("MISSION");
        return mission.startsWith("SENTINEL-1");
    }

    public void checkIfSentinel1Product() throws OperatorException {
        if (!this.isSentinel1Product()) {
            throw new OperatorException(SHOULD_BE_S1);
        }
    }

    public void checkMission(String[] validMissions) throws OperatorException {
        String mission = this.absRoot.getAttributeString("MISSION", "");
        for (String validMission : validMissions) {
            if (!mission.equals(validMission)) continue;
            return;
        }
        throw new OperatorException(mission + " is not a valid mission from: " + StringUtils.arrayToString((Object)validMissions, (String)","));
    }

    public void checkProductType(String[] validProductTypes) throws OperatorException {
        String productType = this.absRoot.getAttributeString("PRODUCT_TYPE", "");
        for (String validProductType : validProductTypes) {
            if (!productType.equals(validProductType)) continue;
            return;
        }
        throw new OperatorException(productType + " is not a valid product type from: " + StringUtils.arrayToString((Object)validProductTypes, (String)","));
    }

    public void checkAcquisitionMode(String[] validModes) throws OperatorException {
        String acquisitionMode = this.absRoot.getAttributeString("ACQUISITION_MODE");
        for (String validMode : validModes) {
            if (!acquisitionMode.equals(validMode)) continue;
            return;
        }
        throw new OperatorException(acquisitionMode + " is not a valid acquisition mode from: " + StringUtils.arrayToString((Object)validModes, (String)","));
    }

    public boolean isTOPSARProduct() {
        boolean isS1 = false;
        String mission = this.absRoot.getAttributeString("MISSION", "");
        if (mission.startsWith("SENTINEL-1") || mission.startsWith("RS2")) {
            isS1 = true;
        }
        String[] bandNames = this.product.getBandNames();
        return isS1 && (InputProductValidator.contains(bandNames, "IW1") || InputProductValidator.contains(bandNames, "IW2") || InputProductValidator.contains(bandNames, "IW3") || InputProductValidator.contains(bandNames, "EW1") || InputProductValidator.contains(bandNames, "EW2") || InputProductValidator.contains(bandNames, "EW3") || InputProductValidator.contains(bandNames, "EW4") || InputProductValidator.contains(bandNames, "EW5"));
    }

    public void checkIfTOPSARBurstProduct(boolean shouldbe) throws OperatorException {
        boolean isTOPSARProduct = this.isTOPSARProduct();
        if (shouldbe && !isTOPSARProduct) {
            throw new OperatorException("Source product should be an SLC burst product");
        }
        if (shouldbe && isTOPSARProduct && this.isDebursted()) {
            throw new OperatorException("Source product should NOT be a deburst product");
        }
        if (!shouldbe && isTOPSARProduct && !this.isDebursted()) {
            throw new OperatorException(SHOULD_BE_DEBURST);
        }
    }

    public void checkIfMultiSwathTOPSARProduct() throws OperatorException {
        if (!this.isMultiSwath()) {
            throw new OperatorException(SHOULD_BE_MULTISWATH_SLC);
        }
    }

    public boolean isDebursted() {
        MetadataElement[] elems;
        if (!this.isSentinel1Product()) {
            return true;
        }
        boolean isDebursted = true;
        MetadataElement origProdRoot = AbstractMetadata.getOriginalProductMetadata(this.product);
        MetadataElement annotation = origProdRoot.getElement("annotation");
        if (annotation == null) {
            return true;
        }
        for (MetadataElement elem : elems = annotation.getElements()) {
            MetadataElement product = elem.getElement("product");
            MetadataElement swathTiming = product.getElement("swathTiming");
            MetadataElement burstList = swathTiming.getElement("burstList");
            int count = Integer.parseInt(burstList.getAttributeString("count"));
            if (count == 0) continue;
            isDebursted = false;
            break;
        }
        return isDebursted;
    }

    private static boolean contains(String[] list, String tag) {
        for (String s : list) {
            if (!s.contains(tag)) continue;
            return true;
        }
        return false;
    }

    public boolean isFullPolSLC() {
        int validBandCnt = 0;
        for (Band band : this.product.getBands()) {
            String pol;
            Unit.UnitType bandUnit = Unit.getUnitType(band);
            if (bandUnit != Unit.UnitType.REAL && bandUnit != Unit.UnitType.IMAGINARY || (pol = OperatorUtils.getPolarizationFromBandName(band.getName())) == null || !pol.contains("hh") && !pol.contains("hv") && !pol.contains("vh") && !pol.contains("vv")) continue;
            ++validBandCnt;
        }
        return validBandCnt == 8;
    }

    public void checkIfQuadPolSLC() throws OperatorException {
        if (!this.isFullPolSLC()) {
            throw new OperatorException(SHOULD_BE_QUAD_POL);
        }
    }

    public boolean isMapProjected() {
        if (this.product.getSceneGeoCoding() instanceof MapGeoCoding || this.product.getSceneGeoCoding() instanceof CrsGeoCoding) {
            return true;
        }
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata(this.product);
        return absRoot != null && !AbstractMetadata.isNoData(absRoot, "map_projection");
    }

    public void checkIfMapProjected(boolean shouldBe) throws OperatorException {
        boolean isMapProjected = this.isMapProjected();
        if (!shouldBe && isMapProjected) {
            throw new OperatorException(SHOULD_NOT_BE_MAP_PROJECTED);
        }
        if (shouldBe && !isMapProjected) {
            throw new OperatorException(SHOULD_BE_MAP_PROJECTED);
        }
    }

    public static boolean isCalibrated(Product product) {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata(product);
        return absRoot != null && absRoot.getAttribute("abs_calibration_flag").getData().getElemBoolean();
    }

    public void checkIfCalibrated(boolean shouldBe) throws OperatorException {
        boolean isCalibrated = InputProductValidator.isCalibrated(this.product);
        if (!shouldBe && isCalibrated) {
            throw new OperatorException(SHOULD_NOT_BE_CALIBRATED);
        }
        if (shouldBe && !isCalibrated) {
            throw new OperatorException(SHOULD_BE_CALIBRATED);
        }
    }

    public void checkIfTanDEMXProduct() throws OperatorException {
        String mission = this.absRoot.getAttributeString("MISSION");
        if (!mission.startsWith("TDM")) {
            throw new OperatorException("Input should be a TanDEM-X product.");
        }
    }

    public void checkIfCompatibleProducts(Product[] sourceProducts) {
        for (Product srcProduct : sourceProducts) {
            if (this.product.isCompatibleProduct(srcProduct, 0.001f)) continue;
            throw new OperatorException(SHOULD_BE_COMPATIBLE);
        }
    }
}

