/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.db;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.dataio.ProductIOPlugInManager;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Product;

public class CommonReaders {
    private static final ProductReaderPlugIn dimapReadPlugIn = CommonReaders.getReaderPlugIn("BEAM-DIMAP");
    private static final ProductReaderPlugIn envisatReadPlugIn = CommonReaders.getReaderPlugIn("ENVISAT");
    private static final ProductReaderPlugIn TSXReadPlugIn = CommonReaders.getReaderPlugIn("TerraSarX");
    private static final ProductReaderPlugIn RS2ReadPlugIn = CommonReaders.getReaderPlugIn("RADARSAT-2");
    private static final ProductReaderPlugIn S1ReadPlugIn = CommonReaders.getReaderPlugIn("SENTINEL-1");
    private static final ProductReaderPlugIn GeoTiffReadPlugIn = CommonReaders.getReaderPlugIn("GeoTIFF");
    private static final ProductReaderPlugIn ImageIOReadPlugIn = CommonReaders.getReaderPlugIn("PNG");

    private static ProductReaderPlugIn getReaderPlugIn(String format) {
        ProductIOPlugInManager registry = ProductIOPlugInManager.getInstance();
        Iterator itr = registry.getReaderPlugIns(format);
        return itr != null && itr.hasNext() ? (ProductReaderPlugIn)itr.next() : null;
    }

    public static Product readProduct(File file) throws IOException {
        Product product = CommonReaders.readCommonProductReader(file);
        if (product == null) {
            product = ProductIO.readProduct((File)file);
        }
        return product;
    }

    public static Product readCommonProductReader(File file) throws IOException {
        String filename = file.getName().toLowerCase();
        if (filename.endsWith("dim")) {
            return CommonReaders.read(file, dimapReadPlugIn);
        }
        if (filename.endsWith("n1") || filename.endsWith("e1") || filename.endsWith("e2")) {
            return CommonReaders.read(file, envisatReadPlugIn);
        }
        if ((filename.startsWith("tsx") || filename.startsWith("tdx")) && filename.endsWith("xml")) {
            return CommonReaders.read(file, TSXReadPlugIn);
        }
        if (filename.equals("product.xml")) {
            return CommonReaders.read(file, RS2ReadPlugIn);
        }
        if (filename.endsWith("tif")) {
            return CommonReaders.read(file, GeoTiffReadPlugIn);
        }
        if (filename.endsWith("dbl")) {
            return ProductIO.readProduct((File)file, (String[])new String[]{"SMOS-DBL"});
        }
        if (filename.endsWith("zip")) {
            if (filename.startsWith("asa")) {
                return CommonReaders.read(file, envisatReadPlugIn);
            }
            if (filename.startsWith("s1")) {
                return CommonReaders.read(file, S1ReadPlugIn);
            }
            if (filename.startsWith("rs2")) {
                return CommonReaders.read(file, RS2ReadPlugIn);
            }
        } else if (filename.endsWith("png")) {
            return CommonReaders.read(file, ImageIOReadPlugIn);
        }
        return null;
    }

    private static Product read(File file, ProductReaderPlugIn selectedPlugIn) throws IOException {
        if (selectedPlugIn == null) {
            return null;
        }
        ProductReader productReader = selectedPlugIn.createReaderInstance();
        return productReader == null ? null : productReader.readProductNodes((Object)file, null);
    }

    public static ProductReader findCommonProductReader(File file) {
        String filename = file.getName().toLowerCase();
        if (filename.endsWith("n1") || filename.endsWith("e1") || filename.endsWith("e2")) {
            return ProductIO.getProductReader((String)"ENVISAT");
        }
        if (filename.endsWith("dim")) {
            return ProductIO.getProductReader((String)"BEAM-DIMAP");
        }
        if ((filename.startsWith("tsx") || filename.startsWith("tdx")) && filename.endsWith("xml")) {
            return ProductIO.getProductReader((String)"TerraSarX");
        }
        if (filename.endsWith("tif")) {
            return ProductIO.getProductReader((String)"GeoTIFF");
        }
        if (filename.endsWith("dbl")) {
            return ProductIO.getProductReader((String)"SMOS-DBL");
        }
        if (filename.endsWith("zip")) {
            if (filename.startsWith("asa")) {
                return ProductIO.getProductReader((String)"ENVISAT");
            }
            if (filename.startsWith("s1")) {
                return ProductIO.getProductReader((String)"SENTINEL-1");
            }
            if (filename.startsWith("rs2")) {
                return ProductIO.getProductReader((String)"RADARSAT-2");
            }
        }
        return null;
    }
}

