/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.engine_utilities.datamodel;

import java.io.File;
import java.net.URL;
import org.esa.snap.engine_utilities.datamodel.DownloadableArchiveFile;
import org.esa.snap.engine_utilities.datamodel.DownloadableContentImpl;
import org.esa.snap.engine_utilities.datamodel.DownloadableFile;
import org.esa.snap.engine_utilities.util.ZipUtils;

public class DownloadableArchive
extends DownloadableContentImpl {
    private final File localFile;

    public DownloadableArchive(File localFile, URL remotePath) {
        super(localFile, remotePath, ".zip");
        this.localFile = localFile;
    }

    public void getContentFiles() throws Exception {
        File archiveFile = (File)((Object)this.getContentFile());
        if (archiveFile != null) {
            ZipUtils.unzipToFolder(archiveFile, this.localFile.getParentFile());
            archiveFile.delete();
        }
    }

    @Override
    protected DownloadableFile createContentFile(File dataFile) {
        return new DownloadableArchiveFile(dataFile);
    }
}

