/*
 * Decompiled with CFR 0.152.
 */
package org.jpy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.jpy.PyInputMode;
import org.jpy.PyLib;
import org.jpy.PyProxyHandler;

public class PyObject {
    private final long pointer;

    PyObject(long pointer) {
        if (pointer == 0L) {
            throw new IllegalArgumentException("pointer == 0");
        }
        PyLib.incRef(pointer);
        this.pointer = pointer;
    }

    public static PyObject executeCode(String code, PyInputMode mode) {
        return PyObject.executeCode(code, mode, null, null);
    }

    public static PyObject executeCode(String code, PyInputMode mode, Map<String, Object> globals, Map<String, Object> locals) {
        if (code == null) {
            throw new NullPointerException("code must not be null");
        }
        if (mode == null) {
            throw new NullPointerException("mode must not be null");
        }
        return new PyObject(PyLib.executeCode(code, mode.value(), globals, locals));
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.pointer == 0L) {
            throw new IllegalStateException("pointer == 0");
        }
        PyLib.decRef(this.getPointer());
    }

    public final long getPointer() {
        return this.pointer;
    }

    public int getIntValue() {
        PyLib.assertPythonRuns();
        return PyLib.getIntValue(this.getPointer());
    }

    public double getDoubleValue() {
        PyLib.assertPythonRuns();
        return PyLib.getDoubleValue(this.getPointer());
    }

    public String getStringValue() {
        PyLib.assertPythonRuns();
        return PyLib.getStringValue(this.getPointer());
    }

    public Object getObjectValue() {
        PyLib.assertPythonRuns();
        return PyLib.getObjectValue(this.getPointer());
    }

    public <T> T[] getObjectArrayValue(Class<? extends T> itemType) {
        PyLib.assertPythonRuns();
        return PyLib.getObjectArrayValue(this.getPointer(), itemType);
    }

    public PyObject getAttribute(String name) {
        PyLib.assertPythonRuns();
        long pointer = PyLib.getAttributeObject(this.getPointer(), name);
        return pointer != 0L ? new PyObject(pointer) : null;
    }

    public <T> T getAttribute(String name, Class<? extends T> valueType) {
        PyLib.assertPythonRuns();
        return PyLib.getAttributeValue(this.getPointer(), name, valueType);
    }

    public <T> void setAttribute(String name, T value) {
        PyLib.assertPythonRuns();
        PyLib.setAttributeValue(this.getPointer(), name, value, value != null ? value.getClass() : null);
    }

    public <T> void setAttribute(String name, T value, Class<? extends T> valueType) {
        PyLib.assertPythonRuns();
        PyLib.setAttributeValue(this.getPointer(), name, value, valueType);
    }

    public PyObject callMethod(String name, Object ... args) {
        PyLib.assertPythonRuns();
        long pointer = PyLib.callAndReturnObject(this.getPointer(), true, name, args.length, args, null);
        return pointer != 0L ? new PyObject(pointer) : null;
    }

    public PyObject call(String name, Object ... args) {
        PyLib.assertPythonRuns();
        long pointer = PyLib.callAndReturnObject(this.getPointer(), false, name, args.length, args, null);
        return pointer != 0L ? new PyObject(pointer) : null;
    }

    public <T> T createProxy(Class<T> type) {
        PyLib.assertPythonRuns();
        return (T)this.createProxy(PyLib.CallableKind.METHOD, type);
    }

    public Object createProxy(PyLib.CallableKind callableKind, Class<?> ... types) {
        PyLib.assertPythonRuns();
        ClassLoader classLoader = types[0].getClassLoader();
        PyProxyHandler invocationHandler = new PyProxyHandler(this, callableKind);
        return Proxy.newProxyInstance(classLoader, types, (InvocationHandler)invocationHandler);
    }

    public final String toString() {
        return String.format("%s(pointer=0x%s)", this.getClass().getSimpleName(), Long.toHexString(this.pointer));
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PyObject)) {
            return false;
        }
        PyObject pyObject = (PyObject)o;
        return this.pointer == pyObject.pointer;
    }

    public final int hashCode() {
        return (int)(this.pointer ^ this.pointer >>> 32);
    }
}

