/*
 * Decompiled with CFR 0.152.
 */
package org.jpy;

import org.jpy.PyLib;
import org.jpy.PyObject;

public class PyModule
extends PyObject {
    private final String name;

    PyModule(String name, long pointer) {
        super(pointer);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static PyModule getMain() {
        return PyModule.importModule("__main__");
    }

    public static PyModule getBuiltins() {
        try {
            return PyModule.importModule("builtins");
        }
        catch (Exception e) {
            return PyModule.importModule("__builtin__");
        }
    }

    public static PyModule importModule(String name) {
        PyLib.assertPythonRuns();
        long pointer = PyLib.importModule(name);
        return pointer != 0L ? new PyModule(name, pointer) : null;
    }

    public static PyObject extendSysPath(String modulePath, boolean prepend) {
        PyModule sys = PyModule.importModule("sys");
        PyObject sysPath = sys.getAttribute("path");
        if (prepend) {
            sysPath.call("insert", 0, modulePath);
        } else {
            sysPath.call("append", modulePath);
        }
        return sysPath;
    }

    @Override
    public <T> T createProxy(Class<T> type) {
        PyLib.assertPythonRuns();
        return (T)this.createProxy(PyLib.CallableKind.FUNCTION, type);
    }
}

