/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.DefaultSplitButtonModel;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.SplitButtonModel;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;

public class JideToggleSplitButton
extends JideSplitButton
implements Accessible {
    public JideToggleSplitButton() {
        this(null, null, false);
    }

    public JideToggleSplitButton(Icon icon) {
        this(null, icon, false);
    }

    public JideToggleSplitButton(Icon icon, boolean bl) {
        this(null, icon, bl);
    }

    public JideToggleSplitButton(String string) {
        this(string, null, false);
    }

    public JideToggleSplitButton(String string, boolean bl) {
        this(string, null, bl);
    }

    public JideToggleSplitButton(Action action) {
        this();
        this.setAction(action);
    }

    public JideToggleSplitButton(String string, Icon icon) {
        this(string, icon, false);
    }

    public JideToggleSplitButton(String string, Icon icon, boolean bl) {
        this.setModel(new ToggleSplitButtonModel());
        ((SplitButtonModel)this.model).setButtonSelected(bl);
        this.init(string, icon);
    }

    @Override
    protected void configurePropertiesFromAction(Action action) {
        super.configurePropertiesFromAction(action);
        boolean bl = false;
        if (action != null) {
            bl = Boolean.TRUE.equals(action.getValue("SwingSelectedKey"));
        }
        if (bl != this.isSelected()) {
            ButtonGroup buttonGroup;
            this.setSelected(bl);
            if (!bl && this.isSelected() && this.getModel() instanceof DefaultButtonModel && (buttonGroup = ((DefaultButtonModel)this.getModel()).getGroup()) != null) {
                buttonGroup.clearSelection();
            }
        }
    }

    @Override
    protected void actionPropertyChanged(Action action, String string) {
        super.actionPropertyChanged(action, string);
        if ("SwingSelectedKey".equals(string)) {
            ((ToggleSplitButtonModel)this.getModel()).setButtonSelected((Boolean)action.getValue(string));
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJToggleButton();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJToggleButton
    extends AbstractButton.AccessibleAbstractButton
    implements ItemListener {
        public AccessibleJToggleButton() {
            super(JideToggleSplitButton.this);
            JideToggleSplitButton.this.addItemListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            JideToggleSplitButton jideToggleSplitButton = (JideToggleSplitButton)itemEvent.getSource();
            if (JideToggleSplitButton.this.accessibleContext != null) {
                if (jideToggleSplitButton.isSelected()) {
                    JideToggleSplitButton.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.CHECKED);
                } else {
                    JideToggleSplitButton.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.CHECKED, null);
                }
            }
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TOGGLE_BUTTON;
        }
    }

    public static class ToggleSplitButtonModel
    extends DefaultSplitButtonModel {
        @Override
        public boolean isButtonSelected() {
            return (this.stateMask & 0x40) != 0;
        }

        @Override
        public void setButtonSelected(boolean bl) {
            ButtonGroup buttonGroup = this.getGroup();
            if (buttonGroup != null) {
                buttonGroup.setSelected(this, bl);
                bl = buttonGroup.isSelected(this);
            }
            if (this.isButtonSelected() == bl) {
                return;
            }
            this.stateMask = bl ? (this.stateMask |= 0x40) : (this.stateMask &= 0xFFFFFFBF);
            this.fireStateChanged();
            this.fireItemStateChanged(new ItemEvent(this, 701, this, this.isSelected() ? 1 : 2));
        }

        @Override
        public void setPressed(boolean bl) {
            if (this.isPressed() == bl || !this.isEnabled()) {
                return;
            }
            if (!bl && this.isArmed()) {
                this.setButtonSelected(!this.isButtonSelected());
            }
            this.stateMask = bl ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
            this.fireStateChanged();
            if (!this.isPressed() && this.isArmed()) {
                int n = 0;
                AWTEvent aWTEvent = EventQueue.getCurrentEvent();
                if (aWTEvent instanceof InputEvent) {
                    n = ((InputEvent)aWTEvent).getModifiers();
                } else if (aWTEvent instanceof ActionEvent) {
                    n = ((ActionEvent)aWTEvent).getModifiers();
                }
                this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), n));
            }
        }
    }
}

