/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.dialog.JideOptionPane;
import com.jidesoft.swing.JideSplitPaneDivider;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.AWTError;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JideBoxLayout
implements LayoutManager2,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(JideBoxLayout.class.getName());
    private boolean doReset = true;
    protected int _axis;
    protected Container _target;
    private int _gap = 0;
    protected int[] _componentSizes;
    public static final String FIX = "fix";
    public static final String FLEXIBLE = "flexible";
    public static final String VARY = "vary";
    private final HashMap<Component, Object> _constraintMap = new HashMap();
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int LINE_AXIS = 2;
    public static final int PAGE_AXIS = 3;
    private boolean _resetWhenInvalidate = true;
    private boolean _alwaysLayout = true;
    private static final long serialVersionUID = -183922972679053590L;

    public JideBoxLayout(Container container) {
        this(container, 0);
    }

    public JideBoxLayout(Container container, int n) {
        this(container, n, 0);
    }

    public JideBoxLayout(Container container, int n, int n2) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new AWTError("Invalid axis");
        }
        this._axis = n;
        this._target = container;
        this._gap = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            int n2;
            int n32;
            boolean bl;
            int n4;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(this + " layoutContainer started");
            }
            Dimension dimension = container.getSize();
            if (dimension.height <= 0 || dimension.width <= 0) {
                return;
            }
            Insets insets = this._target.getInsets();
            if (this.doReset) {
                this._componentSizes = new int[this._target.getComponentCount()];
                n4 = this.getAvailableSize(dimension, insets);
                if ((n4 -= this.getGapSize()) <= 0) {
                    return;
                }
                bl = this.calculateComponentSizes(n4, 0, this._target.getComponentCount());
                if (!bl) {
                    if (!this.isAlwaysLayout() && "false".equals(SecurityUtils.getProperty("JideBoxLayout.alwaysLayout", "false"))) {
                        for (int i = 0; i < this._target.getComponentCount(); ++i) {
                            Component component = this._target.getComponent(i);
                            this.setComponentToSize(component, 0, 0, insets, dimension);
                        }
                        this.redoLayout(container);
                    }
                    return;
                }
                this.doReset = false;
                if (this._componentSizes.length == 0) {
                    container.repaint();
                }
            } else {
                n4 = 0;
                for (int n32 : this._componentSizes) {
                    n4 += n32;
                }
                boolean bl2 = bl = n4 + this.getGapSize() != this.getSizeForPrimaryAxis(dimension);
                if (bl) {
                    n2 = this.getAvailableSize(dimension, insets);
                    if ((n2 -= this.getGapSize()) <= 0) {
                        return;
                    }
                    n = this.calculateComponentSizes(n2, 0, this._target.getComponentCount()) ? 1 : 0;
                    if (n == 0) {
                        if (!this.isAlwaysLayout() && "false".equals(SecurityUtils.getProperty("JideBoxLayout.alwaysLayout", "false"))) {
                            for (n32 = 0; n32 < this._target.getComponentCount(); ++n32) {
                                Component component = this._target.getComponent(n32);
                                this.setComponentToSize(component, 0, 0, insets, dimension);
                            }
                            this.redoLayout(container);
                        }
                        return;
                    }
                }
            }
            ComponentOrientation componentOrientation = this._target.getComponentOrientation();
            bl = componentOrientation.isLeftToRight();
            n2 = this.getSizeForPrimaryAxis(insets, true);
            n = 0;
            if (!bl && JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
                n2 = dimension.width - n2;
            }
            for (n32 = 0; n32 < this._target.getComponentCount(); ++n32) {
                int n5;
                Component component = this._target.getComponent(n32);
                int n6 = this.getPreferredSizeOfComponent(component);
                if (!bl && JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
                    this.setComponentToSize(component, this._componentSizes[n32], n2 -= this._componentSizes[n32], insets, dimension);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("layoutContainer index: " + n32 + " size: " + this._componentSizes[n32]);
                    }
                    if (this._componentSizes[n32] != 0) {
                        n2 -= this._gap;
                    }
                } else {
                    this.setComponentToSize(component, this._componentSizes[n32], n2, insets, dimension);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("layoutContainer index: " + n32 + " size: " + this._componentSizes[n32]);
                    }
                    n2 += this._componentSizes[n32];
                    if (this._componentSizes[n32] != 0) {
                        n2 += this._gap;
                    }
                }
                if ((n5 = this.getPreferredSizeOfComponent(component)) == n6) continue;
                n = 1;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("layoutContainer ended");
            }
            if (this._target instanceof JideOptionPane) {
                for (n32 = 0; n32 < container.getComponentCount(); ++n32) {
                    container.getComponent(n32).invalidate();
                }
                if (n != 0) {
                    this.redoLayout(container);
                }
            }
        }
    }

    private void redoLayout(Container container) {
        Container container2;
        for (container2 = container.getParent(); container2 != null && !(container2 instanceof Dialog); container2 = container2.getParent()) {
        }
        if (container2 != null) {
            ((Dialog)container2).pack();
        }
    }

    protected boolean calculateComponentSizes(int n, int n2, int n3) {
        boolean bl;
        int n4;
        int n5;
        int n6 = n;
        int n7 = 0;
        int n8 = 0;
        int n9 = -1;
        int n10 = 0;
        int n11 = 0;
        int n12 = -1;
        int n13 = -1;
        for (n5 = n2; n5 < n3; ++n5) {
            Component component = this._target.getComponent(n5);
            if (!component.isVisible()) continue;
            Object object = this._constraintMap.get(component);
            int n14 = this.getSizeForPrimaryAxis(component.getMinimumSize());
            n4 = this.getSizeForPrimaryAxis(this.getPreferredSizeOf(component, n5));
            if (FIX.equals(object)) {
                n6 -= Math.max(n4, n14);
                continue;
            }
            if (VARY.equals(object)) {
                n9 = n5;
                this.getPreferredSizeOf(component, n5);
                n7 = n14;
                continue;
            }
            if (n4 > n14) {
                n11 += n4 - n14;
            }
            n10 += n4;
            n8 += n14;
            n12 = n5;
            if (n4 == 0) continue;
            n13 = n5;
        }
        if (!this.isAlwaysLayout() && "false".equals(SecurityUtils.getProperty("JideBoxLayout.alwaysLayout", "false")) && n6 - n7 < 0) {
            return false;
        }
        n5 = n9 != -1 ? 1 : 0;
        boolean bl2 = bl = n6 - n7 >= n10;
        if (n5 == 0 || n5 != 0 && !bl) {
            double d = bl ? (n10 == 0 ? 0.0 : (double)(n6 - n7) / (double)n10) : (n11 == 0 ? 0.0 : (double)(n6 - n7 - n8) / (double)n11);
            for (n4 = n2; n4 < n3; ++n4) {
                Component component = this._target.getComponent(n4);
                if (!component.isVisible()) {
                    this.setComponentSize(n4, 0);
                    continue;
                }
                Object object = this._constraintMap.get(component);
                int n15 = this.getSizeForPrimaryAxis(component.getMinimumSize());
                int n16 = this.getSizeForPrimaryAxis(this.getPreferredSizeOf(component, n4));
                if (FIX.equals(object)) {
                    this.setComponentSize(n4, Math.max(n16, n15));
                    continue;
                }
                if (VARY.equals(object)) {
                    this.setComponentSize(n4, n7);
                    continue;
                }
                if (bl) {
                    this.setComponentSize(n4, (int)((double)n16 * d));
                    continue;
                }
                this.setComponentSize(n4, n15 + (int)((double)(n16 - n15) * d));
            }
        } else {
            for (int i = n2; i < n3; ++i) {
                Component component = this._target.getComponent(i);
                if (!component.isVisible()) {
                    this.setComponentSize(i, 0);
                    continue;
                }
                Object object = this._constraintMap.get(component);
                int n17 = this.getSizeForPrimaryAxis(component.getMinimumSize());
                int n18 = this.getSizeForPrimaryAxis(this.getPreferredSizeOf(component, i));
                if (FIX.equals(object)) {
                    this.setComponentSize(i, Math.max(n18, n17));
                    continue;
                }
                if (VARY.equals(object)) {
                    this.setComponentSize(i, n6 - n10);
                    continue;
                }
                this.setComponentSize(i, Math.max(n18, n17));
            }
        }
        int n19 = 0;
        for (int i = n2; i < n3; ++i) {
            n19 += this._componentSizes[i];
        }
        if (n19 != n) {
            if (n9 != -1) {
                this.setComponentSizeByGap(n9, n - n19);
            } else if (n13 != -1) {
                this.setComponentSizeByGap(n13, n - n19);
            } else if (n12 != -1) {
                this.setComponentSizeByGap(n12, n - n19);
            }
        }
        return true;
    }

    private void setComponentSizeByGap(int n, int n2) {
        if (SystemInfo.isJdk15Above() && this._target.getComponent(n).isMinimumSizeSet()) {
            this.setComponentSize(n, Math.max(this._componentSizes[n] + n2, this.getSizeForPrimaryAxis(this._target.getComponent(n).getMinimumSize())));
        } else {
            this.setComponentSize(n, this._componentSizes[n] + n2);
        }
    }

    private void setComponentSize(int n, int n2) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("setComponentSize index: " + n + " size: " + n2);
        }
        this._componentSizes[n] = n2;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.layoutReset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        Insets insets = this._target.getInsets();
        Object object = container.getTreeLock();
        synchronized (object) {
            for (int i = 0; i < this._target.getComponentCount(); ++i) {
                Component component = this._target.getComponent(i);
                if (!component.isVisible()) continue;
                Object object2 = this._constraintMap.get(component);
                Dimension dimension = component.getMinimumSize();
                n = FIX.equals(object2) ? (n += this.getPreferredSizeOfComponent(component)) : (n += this.getSizeForPrimaryAxis(dimension));
                int n3 = this.getSizeForSecondaryAxis(dimension);
                if (n3 <= n2) continue;
                n2 = n3;
            }
            if (insets != null) {
                n += this.getSizeForPrimaryAxis(insets, true) + this.getSizeForPrimaryAxis(insets, false);
                n2 += this.getSizeForSecondaryAxis(insets, true) + this.getSizeForSecondaryAxis(insets, false);
            }
        }
        object = this._target.getComponentOrientation();
        if (JideBoxLayout.resolveAxis(this._axis, (ComponentOrientation)object) == 0) {
            return new Dimension(n + this.getGapSize(), n2);
        }
        return new Dimension(n2, n + this.getGapSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        Insets insets = this._target.getInsets();
        Object object = container.getTreeLock();
        synchronized (object) {
            for (int i = 0; i < this._target.getComponentCount(); ++i) {
                Component component = this._target.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension = this.getPreferredSizeOf(component, i);
                n += this.getSizeForPrimaryAxis(dimension);
                int n3 = this.getSizeForSecondaryAxis(dimension);
                if (n3 <= n2) continue;
                n2 = n3;
            }
            if (insets != null) {
                n += this.getSizeForPrimaryAxis(insets, true) + this.getSizeForPrimaryAxis(insets, false);
                n2 += this.getSizeForSecondaryAxis(insets, true) + this.getSizeForSecondaryAxis(insets, false);
            }
        }
        object = this._target.getComponentOrientation();
        if (JideBoxLayout.resolveAxis(this._axis, (ComponentOrientation)object) == 0) {
            return new Dimension(n + this.getGapSize(), n2);
        }
        return new Dimension(n2, n + this.getGapSize());
    }

    private int getGapSize() {
        if (this._gap == 0) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this._target.getComponentCount(); ++i) {
            if (!this._target.getComponent(i).isVisible()) continue;
            ++n;
        }
        return Math.max(0, n - 1) * this._gap;
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this._constraintMap.remove(component);
        if (component instanceof JideSplitPaneDivider) {
            this.layoutReset();
        }
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (object == null) {
            this._constraintMap.put(component, FLEXIBLE);
        } else {
            this._constraintMap.put(component, object);
        }
        this.layoutReset();
    }

    private void layoutReset() {
        this.doReset = true;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(this + " layoutReset");
        }
    }

    @Override
    public synchronized float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    @Override
    public synchronized float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    @Override
    public synchronized void invalidateLayout(Container container) {
        if (this.isResetWhenInvalidate() || this.componentCountChanged(container)) {
            this.layoutReset();
        }
    }

    protected boolean componentCountChanged(Container container) {
        if (this._componentSizes == null) {
            return true;
        }
        int n = 0;
        int[] nArray = this._componentSizes;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i];
            if (n3 <= 0) continue;
            ++n;
        }
        int n4 = 0;
        for (n2 = 0; n2 < container.getComponentCount(); ++n2) {
            if (!container.getComponent(n2).isVisible()) continue;
            ++n4;
        }
        return n4 != n;
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected int getPreferredSizeOfComponent(Component component) {
        return this.getSizeForPrimaryAxis(component.getPreferredSize());
    }

    int getMinimumSizeOfComponent(Component component) {
        return this.getSizeForPrimaryAxis(component.getMinimumSize());
    }

    protected int getSizeOfComponent(Component component) {
        return this.getSizeForPrimaryAxis(component.getSize());
    }

    protected int getAvailableSize(Dimension dimension, Insets insets) {
        if (insets == null) {
            return this.getSizeForPrimaryAxis(dimension);
        }
        return this.getSizeForPrimaryAxis(dimension) - (this.getSizeForPrimaryAxis(insets, true) + this.getSizeForPrimaryAxis(insets, false));
    }

    protected int getInitialLocation(Insets insets) {
        if (insets != null) {
            return this.getSizeForPrimaryAxis(insets, true);
        }
        return 0;
    }

    protected void setComponentToSize(Component component, int n, int n2, Insets insets, Dimension dimension) {
        if (insets != null) {
            ComponentOrientation componentOrientation = this._target.getComponentOrientation();
            if (JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
                component.setBounds(n2, Math.max(insets.top, 0), Math.max(n, 0), Math.max(dimension.height - (insets.top + insets.bottom), 0));
            } else {
                component.setBounds(Math.max(insets.left, 0), n2, Math.max(dimension.width - (insets.left + insets.right), 0), Math.max(n, 0));
            }
        } else {
            ComponentOrientation componentOrientation = this._target.getComponentOrientation();
            if (JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
                component.setBounds(n2, 0, Math.max(n, 0), Math.max(dimension.height, 0));
            } else {
                component.setBounds(0, n2, Math.max(dimension.width, 0), Math.max(n, 0));
            }
        }
    }

    int getSizeForPrimaryAxis(Dimension dimension) {
        ComponentOrientation componentOrientation = this._target.getComponentOrientation();
        if (JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
            return dimension.width;
        }
        return dimension.height;
    }

    int getSizeForSecondaryAxis(Dimension dimension) {
        ComponentOrientation componentOrientation = this._target.getComponentOrientation();
        if (JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
            return dimension.height;
        }
        return dimension.width;
    }

    int getSizeForPrimaryAxis(Insets insets, boolean bl) {
        ComponentOrientation componentOrientation = this._target.getComponentOrientation();
        if (JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
            if (bl) {
                return insets.left;
            }
            return insets.right;
        }
        if (bl) {
            return insets.top;
        }
        return insets.bottom;
    }

    int getSizeForSecondaryAxis(Insets insets, boolean bl) {
        ComponentOrientation componentOrientation = this._target.getComponentOrientation();
        if (JideBoxLayout.resolveAxis(this._axis, componentOrientation) == 0) {
            if (bl) {
                return insets.top;
            }
            return insets.bottom;
        }
        if (bl) {
            return insets.left;
        }
        return insets.right;
    }

    public Map<Component, Object> getConstraintMap() {
        return this._constraintMap;
    }

    protected static int resolveAxis(int n, ComponentOrientation componentOrientation) {
        int n2 = n == 2 ? (componentOrientation.isHorizontal() ? 0 : 1) : (n == 3 ? (componentOrientation.isHorizontal() ? 1 : 0) : n);
        return n2;
    }

    public int getGap() {
        return this._gap;
    }

    public void setGap(int n) {
        this._gap = n;
    }

    protected Dimension getPreferredSizeOf(Component component, int n) {
        Dimension dimension = component.getPreferredSize();
        Dimension dimension2 = component.getMinimumSize();
        if (dimension.height < dimension2.height) {
            dimension.height = dimension2.height;
        }
        if (dimension.width < dimension2.width) {
            dimension.width = dimension2.width;
        }
        Dimension dimension3 = component.getMaximumSize();
        if (dimension.height > dimension3.height && dimension3.height != Short.MAX_VALUE) {
            dimension.height = dimension3.height;
        }
        if (dimension.width > dimension3.width && dimension3.height != Short.MAX_VALUE) {
            dimension.width = dimension3.width;
        }
        return dimension;
    }

    public boolean isResetWhenInvalidate() {
        return this._resetWhenInvalidate;
    }

    public void setResetWhenInvalidate(boolean bl) {
        this._resetWhenInvalidate = bl;
    }

    public int getAxis() {
        return this._axis;
    }

    public void setAxis(int n) {
        this._axis = n;
    }

    public boolean isAlwaysLayout() {
        return this._alwaysLayout;
    }

    public void setAlwaysLayout(boolean bl) {
        this._alwaysLayout = bl;
    }
}

