/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.pconvert;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Color;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Locale;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.operator.BandSelectDescriptor;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RGBImageProfile;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Stx;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.geotiff.GeoTIFF;
import org.esa.snap.core.util.geotiff.GeoTIFFMetadata;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.jai.JAIUtils;

public class PConvertMain {
    private static final String EXE_NAME = "pconvert";
    private static final String EXE_VERSION = "1.4";
    private static final int[] DEFAULT_RGB_BAND_INDICES = new int[]{8, 5, 2};
    private static final double[] DEFAULT_HISTO_SKIP_PERCENTAGE = new double[]{1.0, 4.0};
    private static final String DEFAULT_FORMAT_EXT = "dim";
    private File[] _inputFiles;
    private File _outputDir;
    private String _formatExt = "dim";
    private String _formatName;
    private boolean _imageFormat;
    private int[] _bandIndices;
    private int[] _maxOutputResolution;
    private double[] _histoSkipRatios;
    private File _rgbProfile = null;
    private File _colorPalette = null;
    private String _histogramMatching = "off";
    private Color _noDataColor = null;
    private Integer _forcedWidth;
    private Integer _forcedHeight;

    private static void printUsage() {
        StringBuffer sb = new StringBuffer(1024);
        sb.append("pconvert version 1.4");
        sb.append("\n");
        sb.append("Usage: pconvert [<options>] <file-1> [<file-2> <file-3> ...]\n");
        sb.append("\n");
        sb.append("  where the <file-i> are the input data products and <options>\n");
        sb.append("  can be a combination of the following options:\n");
        sb.append("\n");
        sb.append("  -f or --format <ext>\n");
        sb.append("     Specifies output format and file extension,\n");
        sb.append("     possible values for <ext> are\n");
        sb.append("       For product conversion:\n");
        sb.append("         dim  - BEAM-DIMAP product format\n");
        sb.append("         h5   - HDF5 product format\n");
        sb.append("         tifp - GeoTIFF product format\n");
        sb.append("       For image conversion:\n");
        sb.append("         png  - Portable Network Graphics image format\n");
        sb.append("         jpg  - JPEG image format\n");
        sb.append("         tif  - GeoTIFF image format\n");
        sb.append("         bmp  - Microsoft Bitmap image format\n");
        sb.append("       Note:\n");
        sb.append("         If image conversion is selected the product must at least\n");
        sb.append("         contain three bands to create an image.\n");
        sb.append("         If this is not the case, you must use one of the options -b or -p\n");
        sb.append("         to define the image content.\n");
        sb.append("     The default value is \"-f dim\"\n");
        sb.append("  -b or --bands <i> or <iR>,<iG>,<iB> or <i1>,<i2>,<i3>,<i4>...\n");
        sb.append("     Don't use this option in combination with option -p.\n");
        sb.append("     Specifies indices of the bands to be exported as a comma separated\n");
        sb.append("     index list, 1 (one) corresponds to the first band.\n");
        sb.append("     For image output, the number of bands should be 1 (greyscale) or\n");
        sb.append("     3 (RGB), the default value is \"-b " + StringUtils.arrayToCsv((Object)DEFAULT_RGB_BAND_INDICES) + "\" (optimized for MERIS).\n");
        sb.append("     For product output, the default value includes all bands.\n");
        sb.append("\n");
        sb.append("  -p or --rgb-profile <file-path>\n");
        sb.append("     Valid for greyscale or RGB image output only.\n");
        sb.append("     Don't use this option in combination with option -b.\n");
        sb.append("     Specifies the file path to a text file containing an mathematic\n");
        sb.append("     band expression for each of the RGB channels.\n");
        sb.append("     The syntax of the file is as follows:\n");
        sb.append("         red = <red-expression>\n");
        sb.append("         green = <green-expression>\n");
        sb.append("         blue = <blue-expression>\n");
        sb.append("     It is also possible to use r, g and b instead of red, green and blue.\n");
        sb.append("     Empty lines and lines beginning with the '#' character are ignored.\n");
        sb.append("\n");
        sb.append("  -s or --histo-skip <lower>,<upper>\n");
        sb.append("     Valid for greyscale or RGB image output only.\n");
        sb.append("     Specifies the amount of pixels in percent to be skipped from the\n");
        sb.append("     lower resp. upper end of each of the histograms of the R,G and B\n");
        sb.append("     channels. For image output, the default value is \"-s " + StringUtils.arrayToCsv((Object)DEFAULT_HISTO_SKIP_PERCENTAGE) + "\"\n");
        sb.append("     For product output, the option is ignored.\n");
        sb.append("\n");
        sb.append("  -m or --histo-match <algorithm>\n");
        sb.append("     Valid for greyscale or RGB image output only.\n");
        sb.append("     Specifies the histogram matching algorithm to be applied.\n");
        sb.append("     Possible values for <algorithm> are:\n");
        sb.append("         off - no histogram matching\n");
        sb.append("         equalize - force an equalized output histogram\n");
        sb.append("         normalize - force a normalized output histogram\n");
        sb.append("     the default value is \"-m off\".\n");
        sb.append("\n");
        sb.append("  -c or --color-palette <file-path>\n");
        sb.append("     Valid only for image output of a single band.\n");
        sb.append("     Specifies the file path to a text file containing a colour\n");
        sb.append("     palette definition.\n");
        sb.append("\n");
        sb.append("  -n or --no-data-color <red>,<green>,<blue>[,<alpha>]\n");
        sb.append("     Valid for greyscale or RGB image output only.\n");
        sb.append("     Specifies the colour that should be used for the no-data layer.\n");
        sb.append("     The alpha value is optional. All component values have to be between\n");
        sb.append("     0 and 255. An alpha value of 255 means fully opaque and 0 means\n");
        sb.append("     fully transparent.\n");
        sb.append("\n");
        sb.append("  -r or --max-res <x-res>,<y-res>\n");
        sb.append("     Specifies the maximum image output size in pixels, for example 512,512.\n");
        sb.append("     By default, the full product scene size is taken.\n");
        sb.append("     This option can't be combined with -H or -W\n");
        sb.append("\n");
        sb.append("  -W or --width  <width>\n");
        sb.append("     Forces the specified image output width in pixels, for example 512.\n");
        sb.append("     The image aspect ratio will be preserved.\n");
        sb.append("     This option can't be combined with -r or -H\n");
        sb.append("\n");
        sb.append("  -H or --height  <height>\n");
        sb.append("     Forces the specified image output height in pixels, for example 512.\n");
        sb.append("     The image aspect ratio will be preserved.\n");
        sb.append("     This option can't be combined with -r or -W\n");
        sb.append("\n");
        sb.append("  -o or --outdir <dir-path>\n");
        sb.append("     Specifies the output directory.\n");
        sb.append("     The default value is the current working directory.\n");
        sb.append("\n");
        sb.append("  -d or --debug\n");
        sb.append("     Turns the debug mode on.\n");
        sb.append("\n");
        sb.append("  -? or -h or --help\n");
        sb.append("     Prints this usage help.\n");
        sb.append("\n");
        PConvertMain.exit(sb.toString(), 0);
    }

    public static void main(String[] args) {
        Locale.setDefault(Locale.ENGLISH);
        SystemUtils.init3rdPartyLibs(PConvertMain.class);
        new PConvertMain(args).run();
    }

    public PConvertMain(String[] args) {
        int i;
        String bandIndicesStr = null;
        String histoSkipPercentStr = null;
        LinkedList<File> fileList = new LinkedList<File>();
        String maxResStr = null;
        String forcedWidthStr = null;
        String forcedHeightStr = null;
        String noDataColorStr = null;
        for (i = 0; i < args.length; ++i) {
            if (PConvertMain.isOption(args, i, 'b', "bands")) {
                bandIndicesStr = PConvertMain.getOptionArg(args, i);
                ++i;
                continue;
            }
            if (PConvertMain.isOption(args, i, 'c', "color-palette")) {
                this._colorPalette = new File(PConvertMain.getOptionArg(args, i));
                ++i;
                continue;
            }
            if (PConvertMain.isOption(args, i, 'd', "debug")) {
                Debug.setEnabled((boolean)true);
                continue;
            }
            if (PConvertMain.isOption(args, i, 'f', "format")) {
                this._formatExt = PConvertMain.getOptionArg(args, i);
                ++i;
                continue;
            }
            if (PConvertMain.isOption(args, i, 'h', "help") || PConvertMain.isOption(args, i, '?', "help")) {
                PConvertMain.printUsage();
                continue;
            }
            if (PConvertMain.isOption(args, i, 'H', "height")) {
                forcedHeightStr = PConvertMain.getOptionArg(args, i);
                ++i;
                continue;
            }
            if (PConvertMain.isOption(args, i, 'm', "histo-match")) {
                this._histogramMatching = PConvertMain.getOptionArg(args, i);
                ++i;
                continue;
            }
            if (PConvertMain.isOption(args, i, 'n', "no-data-color")) {
                noDataColorStr = PConvertMain.getOptionArg(args, i);
                ++i;
                continue;
            }
            if (PConvertMain.isOption(args, i, 'o', "outdir")) {
                this._outputDir = new File(PConvertMain.getOptionArg(args, i));
                ++i;
                continue;
            }
            if (PConvertMain.isOption(args, i, 'p', "rgb-profile")) {
                this._rgbProfile = new File(PConvertMain.getOptionArg(args, i));
                ++i;
                continue;
            }
            if (PConvertMain.isOption(args, i, 'r', "max-res")) {
                maxResStr = PConvertMain.getOptionArg(args, i);
                ++i;
                continue;
            }
            if (PConvertMain.isOption(args, i, 's', "histo-skip")) {
                histoSkipPercentStr = PConvertMain.getOptionArg(args, i);
                ++i;
                continue;
            }
            if (PConvertMain.isOption(args, i, 'W', "width")) {
                forcedWidthStr = PConvertMain.getOptionArg(args, i);
                ++i;
                continue;
            }
            if (PConvertMain.isOption(args, i)) {
                PConvertMain.error("unknown option '" + args[i] + "'");
                continue;
            }
            fileList.add(new File(args[i]));
        }
        this._inputFiles = new File[fileList.size()];
        fileList.toArray(this._inputFiles);
        if (this._inputFiles.length == 0) {
            PConvertMain.printUsage();
        }
        if (this._outputDir != null && !this._outputDir.exists()) {
            PConvertMain.error("output directory not found: " + this._outputDir.getAbsolutePath());
        }
        if (this._rgbProfile != null && !this._rgbProfile.exists()) {
            PConvertMain.error("RGB channels file not found");
        }
        if (this._colorPalette != null && !this._colorPalette.exists()) {
            PConvertMain.error("Color palette definition file not found");
        }
        this._formatName = null;
        this._imageFormat = true;
        if (this._formatExt.equalsIgnoreCase(DEFAULT_FORMAT_EXT)) {
            this._formatName = "BEAM-DIMAP";
            this._imageFormat = false;
        } else if (this._formatExt.equalsIgnoreCase("h5")) {
            this._formatName = "HDF5";
            this._imageFormat = false;
        } else if (this._formatExt.equalsIgnoreCase("tifp")) {
            this._formatExt = "tif";
            this._formatName = "GeoTIFF";
            this._imageFormat = false;
        } else if (this._formatExt.equalsIgnoreCase("bmp")) {
            this._formatName = "BMP";
            this._imageFormat = true;
        } else if (this._formatExt.equalsIgnoreCase("jpg")) {
            this._formatName = "JPEG";
            this._imageFormat = true;
        } else if (this._formatExt.equalsIgnoreCase("png")) {
            this._formatName = "PNG";
            this._imageFormat = true;
        } else if (this._formatExt.equalsIgnoreCase("tif")) {
            this._formatName = "TIFF";
            this._imageFormat = true;
        } else {
            String[] extensions = ProductIO.getProductWriterExtensions((String)this._formatExt);
            if (extensions != null && extensions.length > 0) {
                this._formatName = this._formatExt;
                this._formatExt = extensions[0].substring(1);
                this._imageFormat = false;
            }
        }
        if (this._formatName == null) {
            PConvertMain.error("unknown output format '" + this._formatExt + "'");
        }
        if (bandIndicesStr != null) {
            try {
                this._bandIndices = StringUtils.toIntArray((String)bandIndicesStr, (String)",");
                if (this._imageFormat && this._bandIndices.length != 1 && this._bandIndices.length != 3) {
                    PConvertMain.error("invalid number of image band indices in '" + bandIndicesStr + "'");
                }
            }
            catch (IllegalArgumentException e) {
                PConvertMain.error("invalid band index in '" + bandIndicesStr + "'");
            }
        }
        if (noDataColorStr != null) {
            try {
                this._noDataColor = StringUtils.parseColor(noDataColorStr);
            }
            catch (Exception e) {
                PConvertMain.error("invalid no-data-color in '" + noDataColorStr + "'");
            }
        }
        if (!this._imageFormat && this._rgbProfile != null) {
            PConvertMain.error("RGB profile is only valid for image output");
        }
        if (!this._imageFormat && this._colorPalette != null) {
            PConvertMain.error("Color palette definition is only valid for image output");
        }
        if (this._colorPalette != null && (this._bandIndices.length != 1 || this._rgbProfile != null)) {
            PConvertMain.error("Color palette definition can only be applied on single bands");
        }
        if (this._bandIndices != null && this._rgbProfile != null) {
            PConvertMain.error("Band indices and RGB profile cannot be given at the same time");
        }
        if (this._imageFormat && this._bandIndices == null && this._rgbProfile == null) {
            Object object = this._bandIndices = (Object)(this._imageFormat ? DEFAULT_RGB_BAND_INDICES : null);
        }
        if (this._bandIndices != null) {
            for (i = 0; i < this._bandIndices.length; ++i) {
                int n = i;
                this._bandIndices[n] = this._bandIndices[n] - 1;
                if (this._bandIndices[i] >= 0) continue;
                PConvertMain.error("invalid " + i + ". band index in '" + bandIndicesStr + "'");
            }
        }
        if (!this._imageFormat && this._noDataColor != null) {
            PConvertMain.error("No-Data colour is only valid for image output");
        }
        Object object = this._histoSkipRatios = (Object)(this._imageFormat ? DEFAULT_HISTO_SKIP_PERCENTAGE : null);
        if (histoSkipPercentStr != null) {
            try {
                this._histoSkipRatios = StringUtils.toDoubleArray((String)histoSkipPercentStr, (String)",");
                if (this._histoSkipRatios.length != 2) {
                    PConvertMain.error("invalid contrast stretch range '" + histoSkipPercentStr + "'");
                }
            }
            catch (IllegalArgumentException e) {
                PConvertMain.error("invalid contrast stretch range '" + histoSkipPercentStr + "'");
            }
        }
        if (this._histoSkipRatios != null) {
            for (int i2 = 0; i2 < this._histoSkipRatios.length; ++i2) {
                int n = i2;
                this._histoSkipRatios[n] = this._histoSkipRatios[n] / 100.0;
                if (!(this._histoSkipRatios[i2] < 0.0) && !(this._histoSkipRatios[i2] > 1.0)) continue;
                PConvertMain.error("invalid contrast stretch range '" + histoSkipPercentStr + "'");
            }
            if (this._histoSkipRatios[0] >= 1.0 - this._histoSkipRatios[1]) {
                PConvertMain.error("invalid contrast stretch range '" + histoSkipPercentStr + "'");
            }
            if (this._histoSkipRatios[1] >= 1.0 - this._histoSkipRatios[0]) {
                PConvertMain.error("invalid contrast stretch range '" + histoSkipPercentStr + "'");
            }
        }
        if (!("off".equals(this._histogramMatching) || "equalize".equals(this._histogramMatching) || "normalize".equals(this._histogramMatching))) {
            PConvertMain.error("invalid histogram matching '" + this._histogramMatching + "'");
        }
        this._maxOutputResolution = null;
        if (maxResStr != null) {
            try {
                this._maxOutputResolution = StringUtils.toIntArray((String)maxResStr, (String)",");
                if (this._maxOutputResolution.length != 2) {
                    PConvertMain.error("invalid maximum resolution '" + maxResStr + "'");
                }
            }
            catch (IllegalArgumentException e) {
                PConvertMain.error("invalid maximum resolution '" + maxResStr + "'");
            }
        }
        this._forcedWidth = null;
        if (forcedWidthStr != null) {
            try {
                this._forcedWidth = new Integer(forcedWidthStr);
                if (this._forcedWidth <= 1) {
                    PConvertMain.error("invalid forced image width '" + forcedWidthStr + "'");
                }
            }
            catch (IllegalArgumentException e) {
                PConvertMain.error("invalid forced image width '" + forcedWidthStr + "'");
            }
        }
        this._forcedHeight = null;
        if (forcedHeightStr != null) {
            try {
                this._forcedHeight = new Integer(forcedHeightStr);
                if (this._forcedHeight <= 1) {
                    PConvertMain.error("invalid forced image height '" + forcedHeightStr + "'");
                }
            }
            catch (IllegalArgumentException e) {
                PConvertMain.error("invalid forced image height '" + forcedHeightStr + "'");
            }
        }
        int n = 0;
        n += this._maxOutputResolution != null ? 1 : 0;
        n += this._forcedWidth != null ? 1 : 0;
        if ((n += this._forcedHeight != null ? 1 : 0) > 1) {
            PConvertMain.error("only one of maximum image resolution, forced image width and height can be specified");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        for (File inputFile : this._inputFiles) {
            File outputFile = new File(this._outputDir, inputFile.getName());
            outputFile = FileUtils.exchangeExtension((File)outputFile, (String)("." + this._formatExt));
            Product product = null;
            try {
                PConvertMain.log("reading file " + inputFile.getPath());
                product = ProductIO.readProduct((File)inputFile);
            }
            catch (IOException e) {
                PConvertMain.error("I/O error while reading input product: " + e.getMessage());
                Debug.trace((Throwable)e);
            }
            if (product != null) {
                try {
                    if (this._imageFormat) {
                        this.convertToImage(product, outputFile);
                        continue;
                    }
                    product = this.convertToProduct(product, outputFile);
                    continue;
                }
                catch (IOException e) {
                    PConvertMain.error("I/O error while writing output file: " + e.getMessage());
                    Debug.trace((Throwable)e);
                    continue;
                }
                finally {
                    product.dispose();
                }
            }
            PConvertMain.warn("no appropriate reader found for input file format");
        }
    }

    private void convertToImage(Product product, File outputFile) throws IOException {
        assert (product != null);
        assert (outputFile != null);
        RenderedImage image = null;
        if (this._rgbProfile != null) {
            try {
                PConvertMain.log("loading RGB profile from '" + this._rgbProfile.getAbsolutePath() + "'...");
                RGBImageProfile rgbImageProfile = RGBImageProfile.loadProfile((File)this._rgbProfile);
                this._bandIndices = PConvertMain.createRGBBands(product, rgbImageProfile);
            }
            catch (IOException e) {
                PConvertMain.error("failed to load RGB profile: " + e.getMessage());
            }
        }
        ColorPaletteDef colorPaletteDef = null;
        if (this._colorPalette != null) {
            try {
                PConvertMain.log("loading colour palette from: " + this._colorPalette.getAbsolutePath());
                colorPaletteDef = ColorPaletteDef.loadColorPaletteDef((File)this._colorPalette);
            }
            catch (IOException e) {
                PConvertMain.error("failed to load colour palette: " + e.getMessage());
            }
        }
        product = PConvertMain.createProductSubset(product, this._maxOutputResolution, null, outputFile);
        for (int i = 0; i < this._bandIndices.length; ++i) {
            int index = this._bandIndices[i];
            if (index < 0 || index >= product.getNumBands()) {
                PConvertMain.error("invalid RGB band index: " + (i + 1));
            }
            Band band = product.getBandAt(index);
            PConvertMain.log("creating histogram for band '" + band.getName() + "'...");
            ImageInfo imageInfo = band.createDefaultImageInfo(this._histoSkipRatios, ProgressMonitor.NULL);
            band.setImageInfo(imageInfo);
            if (colorPaletteDef != null) {
                if (band.getIndexCoding() != null) {
                    band.getImageInfo().setColors(colorPaletteDef.getColors());
                } else {
                    Stx stx = band.getStx();
                    band.getImageInfo().setColorPaletteDef(colorPaletteDef, stx.getMinimum(), stx.getMaximum(), false);
                }
            }
            if (this._noDataColor == null) continue;
            band.getImageInfo().setNoDataColor(this._noDataColor);
        }
        try {
            PConvertMain.log("creating RGB image...");
            Band[] bands = new Band[this._bandIndices.length];
            for (int i = 0; i < bands.length; ++i) {
                bands[i] = product.getBandAt(this._bandIndices[i]);
            }
            ImageInfo imageInfo = ProductUtils.createImageInfo((RasterDataNode[])bands, (boolean)true, (ProgressMonitor)ProgressMonitor.NULL);
            if (imageInfo.getNoDataColor().getAlpha() < 255 && "BMP".equalsIgnoreCase(this._formatName)) {
                if (this._noDataColor != null) {
                    imageInfo.setNoDataColor(this._noDataColor);
                } else {
                    imageInfo.setNoDataColor(Color.BLACK);
                }
            }
            imageInfo.setHistogramMatching(ImageInfo.getHistogramMatching((String)this._histogramMatching));
            image = ProductUtils.createRgbImage((RasterDataNode[])bands, (ImageInfo)imageInfo, (ProgressMonitor)ProgressMonitor.NULL);
            if (image.getColorModel().hasAlpha() && "BMP".equalsIgnoreCase(this._formatName)) {
                PConvertMain.error("failed to write image: BMP does not support transparency");
                return;
            }
        }
        catch (Exception e) {
            Debug.trace((Throwable)e);
            PConvertMain.error("failed to create image: " + e.getMessage());
        }
        image = PConvertMain.createScaledImage(image, this._forcedWidth, this._forcedHeight);
        try {
            boolean geoTIFFWritten = false;
            if (this._formatName.equals("TIFF")) {
                geoTIFFWritten = this.writeGeoTIFFImage(product, image, outputFile);
            }
            if (!geoTIFFWritten) {
                if ("JPG".equalsIgnoreCase(this._formatExt)) {
                    image = BandSelectDescriptor.create((RenderedImage)image, (int[])new int[]{0, 1, 2}, null);
                }
                this.writePlainImage(image, outputFile);
            }
        }
        catch (Exception e) {
            Debug.trace((Throwable)e);
            PConvertMain.error("failed to write image: " + e.getMessage());
        }
    }

    private void writePlainImage(RenderedImage image, File outputFile) {
        PConvertMain.log("writing RGB image to '" + outputFile + "'...");
        JAI.create((String)"filestore", (RenderedImage)image, (Object)outputFile.getPath(), (Object)this._formatName, null);
    }

    private boolean writeGeoTIFFImage(Product product, RenderedImage image, File outputFile) throws IOException {
        boolean geoTIFFWritten = false;
        GeoTIFFMetadata metadata = ProductUtils.createGeoTIFFMetadata((Product)product);
        if (metadata != null) {
            PConvertMain.log("writing RGB GeoTIFF image to '" + outputFile + "'...");
            GeoTIFF.writeImage((RenderedImage)image, (File)outputFile, (GeoTIFFMetadata)metadata);
            geoTIFFWritten = true;
        }
        return geoTIFFWritten;
    }

    private static int[] createRGBBands(Product product, RGBImageProfile rgbImageProfile) {
        return new int[]{PConvertMain.getBandIndex(product, rgbImageProfile.getRedExpression(), "virtual_red"), PConvertMain.getBandIndex(product, rgbImageProfile.getGreenExpression(), "virtual_green"), PConvertMain.getBandIndex(product, rgbImageProfile.getBlueExpression(), "virtual_blue")};
    }

    private static int getBandIndex(Product product, String expression, String virtualBandName) {
        int index;
        if (product.getBand(expression) != null) {
            index = product.getBandIndex(expression);
        } else {
            VirtualBand virtualBand = new VirtualBand(virtualBandName, 30, product.getSceneRasterWidth(), product.getSceneRasterHeight(), expression);
            product.addBand((Band)virtualBand);
            index = product.getBandIndex(virtualBand.getName());
        }
        return index;
    }

    public static RenderedImage createScaledImage(RenderedImage sourceImage, Integer forcedWidth, Integer forcedHeight) {
        int iw = sourceImage.getWidth();
        int ih = sourceImage.getHeight();
        double scale = 1.0;
        if (forcedWidth != null && forcedWidth != iw) {
            scale = (double)forcedWidth.intValue() / (double)iw;
        } else if (forcedHeight != null && forcedHeight != ih) {
            scale = (double)forcedHeight.intValue() / (double)ih;
        }
        if (scale != 1.0) {
            return JAIUtils.createScaleOp((RenderedImage)sourceImage, (double)scale, (double)scale, (double)0.0, (double)0.0, (Interpolation)Interpolation.getInstance((int)2));
        }
        return sourceImage;
    }

    private Product convertToProduct(Product product, File outputFile) throws IOException {
        assert (product != null);
        assert (outputFile != null);
        product = PConvertMain.createProductSubset(product, this._maxOutputResolution, this._bandIndices, outputFile);
        try {
            PConvertMain.log("writing a data product of size " + product.getSceneRasterWidth() + " x " + product.getSceneRasterHeight() + " pixels to '" + outputFile.getPath() + "'...");
            ProductIO.writeProduct((Product)product, (File)outputFile, (String)this._formatName, (boolean)false, (ProgressMonitor)ProgressMonitor.NULL);
        }
        catch (IOException e) {
            Debug.trace((Throwable)e);
            PConvertMain.error("failed to write product: " + e.getMessage());
        }
        return product;
    }

    private static Product createProductSubset(Product product, int[] maxOutputResolution, int[] bandIndices, File outputFile) throws IOException {
        if (maxOutputResolution != null || bandIndices != null) {
            ProductSubsetDef productSubsetDef = new ProductSubsetDef();
            if (maxOutputResolution != null) {
                int w = product.getSceneRasterWidth();
                int h = product.getSceneRasterHeight();
                int wMax = Math.min(w, maxOutputResolution[0]);
                int hMax = Math.min(h, maxOutputResolution[1]);
                int xStep = w >= wMax ? w / wMax : 1;
                int yStep = h >= hMax ? h / hMax : 1;
                int step = Math.max(xStep, yStep);
                productSubsetDef.setSubSampling(step, step);
            }
            if (bandIndices != null) {
                for (int i = 0; i < bandIndices.length; ++i) {
                    int index = bandIndices[i];
                    if (index >= 0 && index < product.getNumBands()) {
                        Band band = product.getBandAt(index);
                        productSubsetDef.addNodeName(band.getName());
                        continue;
                    }
                    PConvertMain.warn("ignoring invalid " + i + ". band index for input product '" + outputFile.getPath() + "'");
                }
            }
            if (!productSubsetDef.isEntireProductSelected()) {
                String[] messages;
                product = product.createSubset(productSubsetDef, null, null);
                for (String message : messages = ProductUtils.removeInvalidExpressions((Product)product)) {
                    PConvertMain.warn(message);
                }
            }
        }
        return product;
    }

    private static void log(String message) {
        System.out.println(message);
    }

    private static void warn(String message) {
        System.err.println("warning: " + message);
    }

    private static void error(String message) {
        PConvertMain.exit("error: " + message, 1);
    }

    private static void exit(String message, int exitCode) {
        System.err.println(message);
        System.exit(exitCode);
    }

    private static boolean isOption(String[] args, int i) {
        return args[i].startsWith("-");
    }

    private static boolean isOption(String[] args, int i, char shortID, String longID) {
        return args[i].equals("-" + shortID) || args[i].equals("--" + longID);
    }

    private static String getOptionArg(String[] args, int i) {
        if (i < args.length - 1 && !PConvertMain.isOption(args, i + 1)) {
            return args[i + 1];
        }
        PConvertMain.error("missing argument for option '" + args[i] + "'");
        return null;
    }
}

