/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.ui;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.DefaultPropertySetDescriptor;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptorFactory;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.PropertySetDescriptor;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.dom.DefaultDomConverter;
import com.bc.ceres.binding.dom.DefaultDomElement;
import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.core.Assert;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.annotations.ParameterDescriptorFactory;
import org.esa.snap.core.gpf.descriptor.OperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.PropertySetDescriptorFactory;
import org.esa.snap.core.gpf.ui.ParameterUpdater;

public class OperatorParameterSupport {
    private static final ParameterUpdater DEFAULT = new ParameterUpdater(){

        @Override
        public void handleParameterSaveRequest(Map<String, Object> parameterMap) {
        }

        @Override
        public void handleParameterLoadRequest(Map<String, Object> parameterMap) {
        }
    };
    private ParameterDescriptorFactory descriptorFactory;
    private Map<String, Object> parameterMap;
    private PropertySet propertySet;
    private ParameterUpdater parameterUpdater;
    private PropertySetDescriptor propertySetDescriptor;
    private Class<? extends Operator> operatorType;

    public OperatorParameterSupport(OperatorDescriptor operatorDescriptor) {
        this(operatorDescriptor, null, null, null);
    }

    public OperatorParameterSupport(OperatorDescriptor operatorDescriptor, PropertySet propertySet, Map<String, Object> parameterMap, ParameterUpdater parameterUpdater) {
        Assert.notNull((Object)operatorDescriptor, (String)"operatorDescriptor");
        this.init(null, operatorDescriptor, propertySet, parameterMap, parameterUpdater);
    }

    @Deprecated
    public OperatorParameterSupport(Class<? extends Operator> opType) {
        this(opType, null, null, null);
    }

    @Deprecated
    public OperatorParameterSupport(Class<? extends Operator> opType, PropertySet propertySet, Map<String, Object> parameterMap, ParameterUpdater parameterUpdater) {
        Assert.notNull(opType, (String)"opType");
        this.init(opType, null, propertySet, parameterMap, parameterUpdater);
    }

    private void init(Class<? extends Operator> opType, OperatorDescriptor operatorDescriptor, PropertySet propertySet, Map<String, Object> parameterMap, ParameterUpdater parameterUpdater) {
        Assert.argument((parameterMap != null || propertySet == null ? 1 : 0) != 0, (String)"parameterMap != null || propertySet == null");
        this.descriptorFactory = new ParameterDescriptorFactory();
        if (parameterMap == null) {
            parameterMap = new HashMap<String, Object>();
        }
        this.parameterMap = parameterMap;
        Class clazz = this.operatorType = opType != null ? opType : operatorDescriptor.getOperatorClass();
        if (propertySet == null) {
            if (operatorDescriptor != null) {
                try {
                    this.propertySetDescriptor = PropertySetDescriptorFactory.createForOperator((OperatorDescriptor)operatorDescriptor, (Map)this.descriptorFactory.getSourceProductMap());
                }
                catch (ConversionException e) {
                    throw new IllegalStateException("Not able to init OperatorParameterSupport.", e);
                }
                propertySet = PropertyContainer.createMapBacked(this.parameterMap, (PropertySetDescriptor)this.propertySetDescriptor);
                propertySet.setDefaultValues();
            } else {
                this.propertySetDescriptor = DefaultPropertySetDescriptor.createFromClass(this.operatorType, (PropertyDescriptorFactory)this.descriptorFactory);
                propertySet = PropertyContainer.createMapBacked(this.parameterMap, (PropertySetDescriptor)this.propertySetDescriptor);
                propertySet.setDefaultValues();
            }
        }
        this.propertySet = propertySet;
        if (parameterUpdater == null) {
            parameterUpdater = DEFAULT;
        }
        this.parameterUpdater = parameterUpdater;
    }

    public PropertySet getPropertySet() {
        return this.propertySet;
    }

    @Deprecated
    public PropertySet getPopertySet() {
        return this.propertySet;
    }

    public Map<String, Object> getParameterMap() {
        return this.parameterMap;
    }

    public void fromDomElement(DomElement parametersElement) throws ValidationException, ConversionException {
        this.parameterMap.clear();
        this.propertySet.setDefaultValues();
        DefaultDomConverter domConverter = this.createDomConverter();
        domConverter.convertDomToValue(parametersElement, (Object)this.propertySet);
        this.parameterUpdater.handleParameterLoadRequest(this.parameterMap);
    }

    public DomElement toDomElement() throws ValidationException, ConversionException {
        this.parameterUpdater.handleParameterSaveRequest(this.parameterMap);
        DefaultDomConverter domConverter = this.createDomConverter();
        DefaultDomElement parametersElement = new DefaultDomElement("parameters");
        domConverter.convertValueToDom((Object)this.propertySet, (DomElement)parametersElement);
        return parametersElement;
    }

    private DefaultDomConverter createDomConverter() {
        return new DefaultDomConverter(this.operatorType, (PropertyDescriptorFactory)this.descriptorFactory, this.propertySetDescriptor);
    }
}

