/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding.dom;

import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.core.Assert;
import java.util.ArrayList;
import java.util.HashMap;

public class DefaultDomElement
implements DomElement {
    private DomElement parent;
    private String name;
    private String value;
    private ArrayList<String> attributeList;
    private HashMap<String, String> attributeMap;
    private ArrayList<DomElement> elementList;
    private HashMap<String, DomElement> elementMap;

    public DefaultDomElement(String name) {
        this(name, null);
    }

    public DefaultDomElement(String name, String value) {
        Assert.notNull((Object)name, (String)"name");
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    public DomElement getParent() {
        return this.parent;
    }

    @Override
    public void setParent(DomElement parent) {
        this.parent = parent;
    }

    public String getAttribute(String name) {
        Assert.notNull((Object)name, (String)"name");
        return this.attributeMap != null ? this.attributeMap.get(name) : null;
    }

    @Override
    public void setAttribute(String name, String value) {
        Assert.notNull((Object)name, (String)"name");
        Assert.notNull((Object)value, (String)"value");
        if (this.attributeList == null) {
            this.attributeList = new ArrayList();
            this.attributeMap = new HashMap();
        }
        if (!this.attributeMap.containsKey(name)) {
            this.attributeList.add(name);
        }
        this.attributeMap.put(name, value);
    }

    public String[] getAttributeNames() {
        return this.attributeList != null ? this.attributeList.toArray(new String[this.attributeList.size()]) : new String[]{};
    }

    public DomElement getChild(String elementName) {
        return this.elementMap != null ? this.elementMap.get(elementName) : null;
    }

    public DomElement[] getChildren() {
        return this.elementList != null ? this.elementList.toArray(new DomElement[this.elementList.size()]) : new DomElement[]{};
    }

    public DomElement[] getChildren(String elementName) {
        if (this.elementList == null) {
            return new DomElement[0];
        }
        ArrayList<DomElement> children = new ArrayList<DomElement>(this.elementList.size());
        for (DomElement domElement : this.elementList) {
            if (!elementName.equals(domElement.getName())) continue;
            children.add(domElement);
        }
        return children.toArray(new DomElement[children.size()]);
    }

    @Override
    public DomElement getChild(int index) {
        return this.elementList != null ? this.elementList.get(index) : null;
    }

    @Override
    public int getChildCount() {
        return this.elementList != null ? this.elementList.size() : 0;
    }

    @Override
    public DomElement createChild(String name) {
        DefaultDomElement child = new DefaultDomElement(name);
        this.addChild(child);
        return child;
    }

    @Override
    public void addChild(DomElement child) {
        if (this.elementList == null) {
            this.elementList = new ArrayList();
            this.elementMap = new HashMap();
        }
        this.elementList.add(child);
        this.elementMap.put(child.getName(), child);
        child.setParent(this);
    }

    @Override
    public String toXml() {
        StringBuilder builder = new StringBuilder(256);
        builder.append("<");
        builder.append(this.getName());
        if (this.attributeList != null) {
            for (String name1 : this.attributeList) {
                builder.append(' ');
                builder.append(name1);
                builder.append('=');
                builder.append('\"');
                builder.append(this.attributeMap.get(name1));
                builder.append('\"');
            }
        }
        if (this.elementList != null) {
            builder.append(">");
            builder.append('\n');
            if (this.getValue() != null) {
                builder.append(this.getValue());
                builder.append('\n');
            }
            for (DomElement element : this.elementList) {
                for (String line : element.toXml().split("\\n")) {
                    builder.append("    ");
                    builder.append(line);
                    builder.append("\n");
                }
            }
            builder.append("</");
            builder.append(this.getName());
            builder.append(">");
        } else {
            if (this.getValue() != null) {
                builder.append(">");
                builder.append(this.getValue());
                builder.append("</");
                builder.append(this.getName());
            } else {
                builder.append("/");
            }
            builder.append(">");
        }
        return builder.toString();
    }
}

