/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertyDescriptorFactory;
import com.bc.ceres.binding.PropertySetDescriptor;
import com.bc.ceres.core.Assert;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class DefaultPropertySetDescriptor
implements PropertySetDescriptor {
    private Map<String, PropertyDescriptor> propertyDescriptors;

    public static PropertySetDescriptor createFromClass(Class<?> valueType, PropertyDescriptorFactory propertyDescriptorFactory) {
        Assert.notNull(valueType, (String)"valueType");
        Assert.notNull((Object)propertyDescriptorFactory, (String)"propertyDescriptorFactory");
        DefaultPropertySetDescriptor propertySetDescriptor = new DefaultPropertySetDescriptor();
        Map<String, Field> fields = PropertyContainer.getPropertyFields(valueType);
        for (Field field : fields.values()) {
            PropertyDescriptor descriptor = propertyDescriptorFactory.createValueDescriptor(field);
            if (descriptor == null) continue;
            propertySetDescriptor.addPropertyDescriptor(descriptor);
        }
        return propertySetDescriptor;
    }

    @Override
    public String[] getPropertyNames() {
        if (this.propertyDescriptors != null) {
            Set<String> strings = this.propertyDescriptors.keySet();
            return strings.toArray(new String[strings.size()]);
        }
        return new String[0];
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor(String propertyName) {
        if (this.propertyDescriptors != null) {
            return this.propertyDescriptors.get(propertyName);
        }
        return null;
    }

    public void addPropertyDescriptor(PropertyDescriptor propertyDescriptor) {
        if (this.propertyDescriptors == null) {
            this.propertyDescriptors = new LinkedHashMap<String, PropertyDescriptor>();
        }
        this.propertyDescriptors.put(propertyDescriptor.getName(), propertyDescriptor);
    }
}

