/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding;

import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;

public class ClassScanner {
    public static Map<String, Field> getFields(Class<?> type) {
        return ClassScanner.getFields(type, FieldFilter.ALL);
    }

    public static Map<String, Field> getFields(Class<?> type, FieldFilter fieldFilter) {
        LinkedHashMap<String, Field> fields = new LinkedHashMap<String, Field>();
        ClassScanner.collectFields(type, fieldFilter, fields);
        return fields;
    }

    private static void collectFields(Class<?> type, FieldFilter fieldFilter, Map<String, Field> fields) {
        Class<?> superclass = type.getSuperclass();
        if (superclass == null) {
            return;
        }
        ClassScanner.collectFields(superclass, fieldFilter, fields);
        for (Field field : type.getDeclaredFields()) {
            if (!fieldFilter.accept(field)) continue;
            fields.put(field.getName(), field);
        }
    }

    public static interface FieldFilter {
        public static final FieldFilter ALL = new FieldFilter(){

            @Override
            public boolean accept(Field field) {
                return true;
            }
        };

        public boolean accept(Field var1);
    }
}

