/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.doclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.SourceProducts;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.descriptor.OperatorDescriptor;
import org.esa.snap.core.gpf.doclet.ElementDesc;
import org.esa.snap.core.gpf.doclet.ParameterDesc;
import org.esa.snap.core.gpf.doclet.SourceProductDesc;
import org.esa.snap.core.gpf.doclet.SourceProductsDesc;
import org.esa.snap.core.gpf.doclet.TargetProductDesc;

public class OperatorDesc
implements ElementDesc {
    private final Class<? extends Operator> type;
    private final ClassDoc classDoc;
    private final OperatorDescriptor annotation;
    private final TargetProductDesc targetProduct;
    private final ArrayList<SourceProductDesc> sourceProductList;
    private SourceProductsDesc sourceProducts;
    private final ArrayList<ParameterDesc> parameters;

    OperatorDesc(Class<? extends Operator> type, ClassDoc classDoc, OperatorDescriptor annotation) {
        this.type = type;
        this.classDoc = classDoc;
        this.annotation = annotation;
        Field[] fields = type.getDeclaredFields();
        FieldDoc[] fieldDocs = classDoc.fields();
        HashMap<String, FieldDoc> fieldDocMap = new HashMap<String, FieldDoc>();
        for (FieldDoc fieldDoc : fieldDocs) {
            fieldDocMap.put(fieldDoc.name(), fieldDoc);
        }
        TargetProductDesc targetProductDesc = null;
        this.sourceProductList = new ArrayList();
        this.parameters = new ArrayList();
        for (Field field : fields) {
            Parameter parameter;
            SourceProducts sourceProductsAnnot;
            SourceProduct sourceProduct;
            TargetProduct targetProduct = field.getAnnotation(TargetProduct.class);
            if (targetProduct != null) {
                targetProductDesc = new TargetProductDesc(field, (FieldDoc)fieldDocMap.get(field.getName()), targetProduct);
            }
            if ((sourceProduct = field.getAnnotation(SourceProduct.class)) != null) {
                this.sourceProductList.add(new SourceProductDesc(field, (FieldDoc)fieldDocMap.get(field.getName()), sourceProduct));
            }
            if ((sourceProductsAnnot = field.getAnnotation(SourceProducts.class)) != null && this.sourceProducts == null) {
                this.sourceProducts = new SourceProductsDesc(field, (FieldDoc)fieldDocMap.get(field.getName()), sourceProductsAnnot);
            }
            if ((parameter = field.getAnnotation(Parameter.class)) == null) continue;
            this.parameters.add(new ParameterDesc(field, (FieldDoc)fieldDocMap.get(field.getName()), parameter));
        }
        this.targetProduct = targetProductDesc;
    }

    public Class<? extends Operator> getType() {
        return this.type;
    }

    public ClassDoc getClassDoc() {
        return this.classDoc;
    }

    @Override
    public String getName() {
        return this.annotation.getAlias();
    }

    @Override
    public String getShortDescription() {
        return this.annotation.getDescription();
    }

    @Override
    public String getLongDescription() {
        return this.classDoc.commentText();
    }

    public String getVersion() {
        return this.annotation.getVersion();
    }

    public TargetProductDesc getTargetProduct() {
        return this.targetProduct;
    }

    public SourceProductDesc[] getSourceProductList() {
        return this.sourceProductList.toArray(new SourceProductDesc[this.sourceProductList.size()]);
    }

    public SourceProductsDesc getSourceProducts() {
        return this.sourceProducts;
    }

    public ParameterDesc[] getParameters() {
        return this.parameters.toArray(new ParameterDesc[this.parameters.size()]);
    }
}

