/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.descriptor;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.converters.ClassConverter;
import com.bc.ceres.core.Assert;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import com.thoughtworks.xstream.io.StreamException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.descriptor.DefaultParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.DefaultSourceProductDescriptor;
import org.esa.snap.core.gpf.descriptor.DefaultSourceProductsDescriptor;
import org.esa.snap.core.gpf.descriptor.DefaultTargetProductDescriptor;
import org.esa.snap.core.gpf.descriptor.DefaultTargetPropertyDescriptor;
import org.esa.snap.core.gpf.descriptor.OperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.ParameterDescriptor;
import org.esa.snap.core.gpf.descriptor.SourceProductDescriptor;
import org.esa.snap.core.gpf.descriptor.SourceProductsDescriptor;
import org.esa.snap.core.gpf.descriptor.TargetProductDescriptor;
import org.esa.snap.core.gpf.descriptor.TargetPropertyDescriptor;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.converters.JavaTypeConverter;

public class DefaultOperatorDescriptor
implements OperatorDescriptor {
    String name;
    Class<? extends Operator> operatorClass;
    String alias;
    String label;
    String version;
    String description;
    String authors;
    String copyright;
    Boolean internal;
    Boolean autoWriteSuppressed;
    DefaultSourceProductDescriptor[] sourceProductDescriptors;
    DefaultSourceProductsDescriptor sourceProductsDescriptor;
    DefaultParameterDescriptor[] parameterDescriptors;
    DefaultTargetProductDescriptor targetProductDescriptor;
    DefaultTargetPropertyDescriptor[] targetPropertyDescriptors;

    DefaultOperatorDescriptor() {
    }

    public DefaultOperatorDescriptor(String name, Class<? extends Operator> operatorClass) {
        this.name = name;
        this.operatorClass = operatorClass;
        this.sourceProductDescriptors = new DefaultSourceProductDescriptor[0];
        this.parameterDescriptors = new DefaultParameterDescriptor[0];
        this.targetPropertyDescriptors = new DefaultTargetPropertyDescriptor[0];
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getAuthors() {
        return this.authors;
    }

    @Override
    public String getCopyright() {
        return this.copyright;
    }

    @Override
    public boolean isInternal() {
        return this.internal != null ? this.internal : false;
    }

    @Override
    public boolean isAutoWriteDisabled() {
        return this.autoWriteSuppressed != null ? this.autoWriteSuppressed : false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Class<? extends Operator> getOperatorClass() {
        return this.operatorClass != null ? this.operatorClass : Operator.class;
    }

    @Override
    public SourceProductDescriptor[] getSourceProductDescriptors() {
        return this.sourceProductDescriptors != null ? this.sourceProductDescriptors : new SourceProductDescriptor[]{};
    }

    @Override
    public SourceProductsDescriptor getSourceProductsDescriptor() {
        return this.sourceProductsDescriptor;
    }

    @Override
    public ParameterDescriptor[] getParameterDescriptors() {
        return this.parameterDescriptors != null ? this.parameterDescriptors : new ParameterDescriptor[]{};
    }

    @Override
    public TargetPropertyDescriptor[] getTargetPropertyDescriptors() {
        return this.targetPropertyDescriptors != null ? this.targetPropertyDescriptors : new TargetPropertyDescriptor[]{};
    }

    @Override
    public TargetProductDescriptor getTargetProductDescriptor() {
        return this.targetProductDescriptor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DefaultOperatorDescriptor fromXml(URL url, ClassLoader classLoader) {
        String resourceName = url.toExternalForm();
        try (InputStreamReader streamReader = new InputStreamReader(url.openStream());){
            DefaultOperatorDescriptor operatorDescriptor;
            DefaultOperatorDescriptor defaultOperatorDescriptor = operatorDescriptor = DefaultOperatorDescriptor.fromXml(streamReader, resourceName, classLoader);
            return defaultOperatorDescriptor;
        }
        catch (IOException e) {
            throw new OperatorException(DefaultOperatorDescriptor.formatReadExceptionText(resourceName, e), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DefaultOperatorDescriptor fromXml(File file, ClassLoader classLoader) throws OperatorException {
        String resourceName = file.getPath();
        try (FileReader reader = new FileReader(file);){
            DefaultOperatorDescriptor defaultOperatorDescriptor = DefaultOperatorDescriptor.fromXml(reader, resourceName, classLoader);
            return defaultOperatorDescriptor;
        }
        catch (IOException e) {
            throw new OperatorException(DefaultOperatorDescriptor.formatReadExceptionText(resourceName, e), e);
        }
    }

    public static DefaultOperatorDescriptor fromXml(Reader reader, String resourceName, ClassLoader classLoader) throws OperatorException {
        Assert.notNull((Object)reader, (String)"reader");
        Assert.notNull((Object)resourceName, (String)"resourceName");
        DefaultOperatorDescriptor descriptor = new DefaultOperatorDescriptor();
        try {
            DefaultOperatorDescriptor.createXStream(classLoader).fromXML(reader, (Object)descriptor);
            if (StringUtils.isNullOrEmpty((String)descriptor.getName())) {
                throw new OperatorException(DefaultOperatorDescriptor.formatInvalidExceptionMessage(resourceName, "missing 'name' element"));
            }
            if (StringUtils.isNullOrEmpty((String)descriptor.getAlias())) {
                throw new OperatorException(DefaultOperatorDescriptor.formatInvalidExceptionMessage(resourceName, "missing 'alias' element"));
            }
        }
        catch (StreamException e) {
            throw new OperatorException(DefaultOperatorDescriptor.formatReadExceptionText(resourceName, (Exception)((Object)e)), e);
        }
        return descriptor;
    }

    public String toXml(ClassLoader classLoader) {
        return DefaultOperatorDescriptor.createXStream(classLoader).toXML((Object)this);
    }

    private static XStream createXStream(ClassLoader classLoader) {
        XStream xStream = new XStream();
        xStream.setClassLoader(classLoader);
        xStream.alias("operator", DefaultOperatorDescriptor.class);
        xStream.alias("sourceProduct", DefaultSourceProductDescriptor.class);
        xStream.aliasField("namedSourceProducts", DefaultOperatorDescriptor.class, "sourceProductDescriptors");
        xStream.alias("sourceProducts", DefaultSourceProductsDescriptor.class);
        xStream.aliasField("sourceProducts", DefaultOperatorDescriptor.class, "sourceProductsDescriptor");
        xStream.alias("parameter", DefaultParameterDescriptor.class);
        xStream.aliasField("parameters", DefaultOperatorDescriptor.class, "parameterDescriptors");
        xStream.registerLocalConverter(DefaultParameterDescriptor.class, "dataType", (SingleValueConverter)new ParameterTypeConverter());
        xStream.alias("targetProduct", DefaultTargetProductDescriptor.class);
        xStream.aliasField("targetProduct", DefaultOperatorDescriptor.class, "targetProductDescriptor");
        xStream.alias("targetProperty", DefaultTargetPropertyDescriptor.class);
        xStream.aliasField("targetProperties", DefaultOperatorDescriptor.class, "targetPropertyDescriptors");
        return xStream;
    }

    private static String formatReadExceptionText(String resourceName, Exception e) {
        return String.format("Failed to read operator descriptor from '%s':\nError: %s", resourceName, e.getMessage());
    }

    private static String formatInvalidExceptionMessage(String resourceName, String message) {
        return String.format("Invalid operator descriptor in '%s': %s", resourceName, message);
    }

    private static class ParameterTypeConverter
    extends AbstractSingleValueConverter {
        private ClassConverter converter = new JavaTypeConverter();

        ParameterTypeConverter() {
        }

        public boolean canConvert(Class aClass) {
            return Class.class.equals((Object)aClass);
        }

        public Object fromString(String s) {
            try {
                return this.converter.parse(s);
            }
            catch (ConversionException e) {
                return null;
            }
        }

        public String toString(Object obj) {
            return this.converter.format((Class)obj);
        }
    }
}

