/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import com.bc.ceres.glevel.support.DefaultMultiLevelSource;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.RenderedImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import org.esa.snap.core.datamodel.AbstractGeoCoding;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Scene;
import org.esa.snap.core.datamodel.SceneFactory;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.gpf.common.resample.AggregatedOpImage;
import org.esa.snap.core.gpf.common.resample.AggregationType;
import org.esa.snap.core.gpf.common.resample.Resample;
import org.esa.snap.core.image.FillConstantOpImage;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.image.ReplaceValueOpImage;
import org.esa.snap.core.image.ResolutionLevel;
import org.esa.snap.core.transform.MathTransform2D;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.jai.JAIUtils;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

@OperatorMetadata(alias="Resample", category="Raster/Geometric", version="2.0", authors="Tonio Fincke", copyright="(c) 2016 by Brockmann Consult", description="Resampling of a multi-size source product to a single-size target product.")
public class ResamplingOp
extends Operator {
    private static final String NAME_EXTENSION = "resampled";
    @SourceProduct(description="The source product which is to be resampled.", label="Name")
    Product sourceProduct;
    @TargetProduct(description="The resampled target product.")
    Product targetProduct;
    @Parameter(alias="referenceBand", label="Reference band", description="The name of the reference band. All other bands will be re-sampled to match its size and resolution. Either this or targetResolutionor targetWidth and targetHeight must be set.", rasterDataNodeType=Band.class)
    String referenceBandName;
    @Parameter(alias="targetWidth", label="Target width", description="The width that all bands of the target product shall have. If this is set, targetHeight must be set, too. Either this and targetHeight or referenceBand or targetResolution must be set.")
    Integer targetWidth;
    @Parameter(alias="targetHeight", label="Target height", description="The height that all bands of the target product shall have. If this is set, targetWidth must be set, too. Either this and targetWidth or referenceBand or targetResolution must be set.")
    Integer targetHeight;
    @Parameter(alias="targetResolution", label="Target resolution", description="The resolution that all bands of the target product shall have. The same value will be applied to scale image widths and heights. Either this or referenceBand or targetwidth and targetHeight must be set.")
    Integer targetResolution;
    @Parameter(alias="upsampling", label="Upsampling method", description="The method used for interpolation (upsampling to a finer resolution).", valueSet={"Nearest", "Bilinear", "Bicubic"}, defaultValue="Nearest")
    private String upsamplingMethod;
    @Parameter(alias="downsampling", label="Downsampling method", description="The method used for aggregation (downsampling to a coarser resolution).", valueSet={"First", "Min", "Max", "Mean", "Median"}, defaultValue="First")
    private String downsamplingMethod;
    @Parameter(alias="flagDownsampling", label="Flag downsampling method", description="The method used for aggregation (downsampling to a coarser resolution) of flags.", valueSet={"First", "FlagAnd", "FlagOr", "FlagMedianAnd", "FlagMedianOr"}, defaultValue="First")
    private String flagDownsamplingMethod;
    @Parameter(label="Resample on pyramid levels (for faster imaging)", defaultValue="true", description="This setting will increase performance when viewing the image, but accurate resamplings are only retrieved when zooming in on a pixel.")
    private boolean resampleOnPyramidLevels;
    private AggregationType aggregationType;
    private AggregationType flagAggregationType;
    private int referenceWidth;
    private int referenceHeight;
    private AffineTransform referenceImageToModelTransform;
    private MultiLevelModel referenceMultiLevelModel;

    @Override
    public void initialize() throws OperatorException {
        if (!ResamplingOp.allNodesHaveIdentitySceneTransform(this.sourceProduct)) {
            throw new OperatorException("Not all nodes have identity model-to-scene transform.");
        }
        this.validateInterpolationParameter();
        this.setReferenceValues();
        this.setResamplingTypes();
        this.targetProduct = new Product(this.sourceProduct.getName() + "_" + NAME_EXTENSION, this.sourceProduct.getProductType(), this.referenceWidth, this.referenceHeight);
        this.resampleBands();
        this.resampleTiePointGrids();
        ProductUtils.copyFlagCodings((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyIndexCodings((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)this.targetProduct);
        this.targetProduct.setStartTime(this.sourceProduct.getStartTime());
        this.targetProduct.setEndTime(this.sourceProduct.getEndTime());
        this.targetProduct.setSceneTimeCoding(this.sourceProduct.getSceneTimeCoding());
        this.transferGeoCoding(this.targetProduct);
        this.copyMasks(this.sourceProduct, this.targetProduct);
        ProductUtils.copyVectorData((Product)this.sourceProduct, (Product)this.targetProduct);
        this.targetProduct.setAutoGrouping(this.sourceProduct.getAutoGrouping());
    }

    private void transferGeoCoding(Product targetProduct) {
        Scene srcScene = SceneFactory.createScene((ProductNode)this.sourceProduct);
        Scene destScene = SceneFactory.createScene((ProductNode)targetProduct);
        if (srcScene != null && destScene != null) {
            GeoCoding sourceGeoCoding = srcScene.getGeoCoding();
            if (sourceGeoCoding == null) {
                targetProduct.setSceneGeoCoding(null);
            } else if (sourceGeoCoding instanceof CrsGeoCoding) {
                CrsGeoCoding srcCrsGeoCoding = (CrsGeoCoding)sourceGeoCoding;
                RasterDataNode anyRasterDataNode = this.getAnyRasterDataNode(targetProduct);
                if (anyRasterDataNode != null) {
                    AffineTransform destImage2MapTransform = anyRasterDataNode.getImageToModelTransform();
                    AffineTransform destImageToMapTransform = new AffineTransform(destImage2MapTransform);
                    try {
                        CrsGeoCoding destCrsGeoCoding = new CrsGeoCoding(srcCrsGeoCoding.getMapCRS(), anyRasterDataNode.getSourceImage().getBounds(), destImageToMapTransform);
                        targetProduct.setSceneGeoCoding((GeoCoding)destCrsGeoCoding);
                    }
                    catch (FactoryException | TransformException throwable) {}
                }
            } else if (sourceGeoCoding instanceof AbstractGeoCoding) {
                AbstractGeoCoding abstractGeoCoding = (AbstractGeoCoding)sourceGeoCoding;
                abstractGeoCoding.transferGeoCoding(srcScene, destScene, null);
            }
        }
    }

    private RasterDataNode getAnyRasterDataNode(Product product) {
        RasterDataNode node = null;
        if (product != null) {
            ProductNodeGroup bandGroup = product.getBandGroup();
            if (bandGroup.getNodeCount() == 0) {
                ProductNodeGroup tiePointGridGroup = product.getTiePointGridGroup();
                if (tiePointGridGroup.getNodeCount() > 0) {
                    node = (RasterDataNode)tiePointGridGroup.get(0);
                }
            } else {
                node = (RasterDataNode)bandGroup.get(0);
            }
        }
        return node;
    }

    private void copyMasks(Product sourceProduct, Product targetProduct) {
        ProductNodeGroup sourceMaskGroup = sourceProduct.getMaskGroup();
        for (int i = 0; i < sourceMaskGroup.getNodeCount(); ++i) {
            Mask mask = (Mask)sourceMaskGroup.get(i);
            Mask.ImageType imageType = mask.getImageType();
            if (imageType.getName().equals("Maths")) {
                String expression = Mask.BandMathsType.getExpression((Mask)mask);
                Mask targetMask = Mask.BandMathsType.create((String)mask.getName(), (String)mask.getDescription(), (int)targetProduct.getSceneRasterWidth(), (int)targetProduct.getSceneRasterHeight(), (String)expression, (Color)mask.getImageColor(), (double)mask.getImageTransparency());
                targetProduct.addMask(targetMask);
                continue;
            }
            if (imageType.getName().equals("Geometry")) {
                VectorDataNode targetVectorDataNode;
                VectorDataNode vectorDataMaskNode = Mask.VectorDataType.getVectorData((Mask)mask);
                String vectorDataNodeName = vectorDataMaskNode.getName();
                if (sourceProduct.getVectorDataGroup().get(vectorDataNodeName) != null || (targetVectorDataNode = this.transferVectorDataNode(targetProduct, vectorDataMaskNode)) == null) continue;
                targetProduct.addMask(mask.getName(), targetVectorDataNode, mask.getDescription(), mask.getImageColor(), mask.getImageTransparency());
                continue;
            }
            if (!imageType.canTransferMask(mask, targetProduct)) continue;
            imageType.transferMask(mask, targetProduct);
        }
    }

    private VectorDataNode transferVectorDataNode(Product targetProduct, VectorDataNode sourceVDN) {
        AffineTransform referenceModelToImageTransform;
        try {
            referenceModelToImageTransform = this.referenceImageToModelTransform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            return null;
        }
        GeometryCoordinateSequenceTransformer transformer = new GeometryCoordinateSequenceTransformer();
        AffineTransform targetImageToModelTransform = Product.findImageToModelTransform((GeoCoding)targetProduct.getSceneGeoCoding());
        referenceModelToImageTransform.concatenate(targetImageToModelTransform);
        AffineTransform2D mathTransform = new AffineTransform2D(referenceModelToImageTransform);
        transformer.setMathTransform((MathTransform)mathTransform);
        FeatureCollection sourceCollection = sourceVDN.getFeatureCollection();
        DefaultFeatureCollection targetCollection = new DefaultFeatureCollection(sourceCollection.getID(), (SimpleFeatureType)sourceCollection.getSchema());
        FeatureIterator featureIterator = sourceCollection.features();
        while (featureIterator.hasNext()) {
            SimpleFeature srcFeature = (SimpleFeature)featureIterator.next();
            Object defaultGeometry = srcFeature.getDefaultGeometry();
            if (defaultGeometry == null || !(defaultGeometry instanceof Geometry)) continue;
            try {
                Geometry transformedGeometry = transformer.transform((Geometry)defaultGeometry);
                SimpleFeature targetFeature = SimpleFeatureBuilder.copy((SimpleFeature)srcFeature);
                targetFeature.setDefaultGeometry((Object)transformedGeometry);
                targetCollection.add(targetFeature);
            }
            catch (TransformException e) {
                return null;
            }
        }
        VectorDataNode targetVDN = new VectorDataNode(sourceVDN.getName(), (SimpleFeatureType)sourceCollection.getSchema());
        targetVDN.getFeatureCollection().addAll((FeatureCollection)targetCollection);
        targetVDN.setDefaultStyleCss(sourceVDN.getDefaultStyleCss());
        targetVDN.setDescription(sourceVDN.getDescription());
        targetVDN.setOwner((ProductNode)targetProduct);
        return targetVDN;
    }

    public static boolean canBeApplied(Product product) {
        return ResamplingOp.allNodesHaveIdentitySceneTransform(product);
    }

    static boolean allNodesHaveIdentitySceneTransform(Product product) {
        ProductNodeGroup bandGroup = product.getBandGroup();
        for (int i = 0; i < bandGroup.getNodeCount(); ++i) {
            if (((Band)bandGroup.get(i)).getModelToSceneTransform() == MathTransform2D.IDENTITY) continue;
            return false;
        }
        ProductNodeGroup tiePointGridGroup = product.getTiePointGridGroup();
        for (int i = 0; i < tiePointGridGroup.getNodeCount(); ++i) {
            if (((TiePointGrid)tiePointGridGroup.get(i)).getModelToSceneTransform() == MathTransform2D.IDENTITY) continue;
            return false;
        }
        return true;
    }

    private void resampleTiePointGrids() {
        ProductNodeGroup tiePointGridGroup = this.sourceProduct.getTiePointGridGroup();
        double scaledReferenceOffsetX = this.referenceImageToModelTransform.getTranslateX() / this.referenceImageToModelTransform.getScaleX();
        double scaledReferenceOffsetY = this.referenceImageToModelTransform.getTranslateY() / this.referenceImageToModelTransform.getScaleY();
        for (int i = 0; i < tiePointGridGroup.getNodeCount(); ++i) {
            AffineTransform transform;
            TiePointGrid grid = (TiePointGrid)tiePointGridGroup.get(i);
            try {
                transform = new AffineTransform(this.referenceImageToModelTransform.createInverse());
            }
            catch (NoninvertibleTransformException e) {
                throw new OperatorException("Cannot resample: " + e.getMessage());
            }
            AffineTransform gridTransform = grid.getImageToModelTransform();
            transform.concatenate(gridTransform);
            if (Math.abs(transform.getScaleX() - 1.0) > 1.0E-8 || Math.abs(transform.getScaleY() - 1.0) > 1.0E-8 || scaledReferenceOffsetX != 0.0 || scaledReferenceOffsetY != 0.0) {
                double subSamplingX = grid.getSubSamplingX() * transform.getScaleX();
                double subSamplingY = grid.getSubSamplingY() * transform.getScaleY();
                double offsetX = grid.getOffsetX() * transform.getScaleX() - scaledReferenceOffsetX;
                double offsetY = grid.getOffsetY() * transform.getScaleY() - scaledReferenceOffsetY;
                TiePointGrid resampledGrid = new TiePointGrid(grid.getName(), grid.getGridWidth(), grid.getGridHeight(), offsetX, offsetY, subSamplingX, subSamplingY, grid.getTiePoints());
                this.targetProduct.addTiePointGrid(resampledGrid);
                ProductUtils.copyRasterDataNodeProperties((RasterDataNode)grid, (RasterDataNode)resampledGrid);
                continue;
            }
            ProductUtils.copyTiePointGrid((String)grid.getName(), (Product)this.sourceProduct, (Product)this.targetProduct);
        }
    }

    private void resampleBands() {
        ProductNodeGroup sourceBands = this.sourceProduct.getBandGroup();
        Object targetMultiLevelModel = this.sourceProduct.getSceneGeoCoding() instanceof CrsGeoCoding ? this.referenceMultiLevelModel : new DefaultMultiLevelModel(new AffineTransform(), this.referenceWidth, this.referenceHeight);
        for (int i = 0; i < sourceBands.getNodeCount(); ++i) {
            VirtualBand targetBand;
            Band sourceBand = (Band)sourceBands.get(i);
            int dataBufferType = ImageManager.getDataBufferType((int)sourceBand.getDataType());
            AffineTransform sourceTransform = sourceBand.getImageToModelTransform();
            boolean isVirtualBand = sourceBand instanceof VirtualBand;
            if (!(sourceBand.getRasterWidth() == this.referenceWidth && sourceBand.getRasterHeight() == this.referenceHeight || isVirtualBand)) {
                DefaultMultiLevelModel intermediateMultiLevelModel;
                AffineTransform intermediateTransform;
                boolean replacedNoData;
                targetBand = new Band(sourceBand.getName(), sourceBand.getDataType(), this.referenceWidth, this.referenceHeight);
                MultiLevelImage targetImage = sourceBand.getSourceImage();
                MultiLevelImage sourceImage = ResamplingOp.createMaskedImage((RasterDataNode)sourceBand, Double.NaN);
                boolean bl = replacedNoData = sourceImage != sourceBand.getSourceImage();
                if (replacedNoData) {
                    dataBufferType = 5;
                }
                if (this.referenceWidth <= sourceBand.getRasterWidth() && this.referenceHeight <= sourceBand.getRasterHeight()) {
                    targetImage = this.createAggregatedImage(sourceImage, dataBufferType, sourceBand.getNoDataValue(), sourceBand.isFlagBand(), this.referenceMultiLevelModel, this.referenceWidth, this.referenceHeight);
                } else if (this.referenceWidth >= sourceBand.getRasterWidth() && this.referenceHeight >= sourceBand.getRasterHeight()) {
                    targetImage = this.createInterpolatedImage(sourceImage, sourceBand.getNoDataValue(), sourceBand.getImageToModelTransform(), sourceBand.isFlagBand() || sourceBand.isIndexBand());
                } else if (this.referenceWidth < sourceBand.getRasterWidth()) {
                    intermediateTransform = new AffineTransform(this.referenceImageToModelTransform.getScaleX(), this.referenceImageToModelTransform.getShearX(), sourceTransform.getShearY(), sourceTransform.getScaleY(), this.referenceImageToModelTransform.getTranslateX(), sourceTransform.getTranslateY());
                    intermediateMultiLevelModel = new DefaultMultiLevelModel(intermediateTransform, this.referenceWidth, sourceBand.getRasterHeight());
                    targetImage = this.createAggregatedImage(targetImage, dataBufferType, sourceBand.getNoDataValue(), sourceBand.isFlagBand(), (MultiLevelModel)intermediateMultiLevelModel, this.referenceWidth, sourceBand.getRasterHeight());
                    targetImage = this.createInterpolatedImage(targetImage, sourceBand.getNoDataValue(), intermediateTransform, sourceBand.isFlagBand() || sourceBand.isIndexBand());
                } else if (this.referenceHeight < sourceBand.getRasterHeight()) {
                    intermediateTransform = new AffineTransform(sourceTransform.getScaleX(), sourceTransform.getShearX(), this.referenceImageToModelTransform.getShearY(), this.referenceImageToModelTransform.getScaleY(), sourceTransform.getTranslateX(), this.referenceImageToModelTransform.getTranslateY());
                    intermediateMultiLevelModel = new DefaultMultiLevelModel(intermediateTransform, sourceBand.getRasterWidth(), this.referenceHeight);
                    targetImage = this.createAggregatedImage(targetImage, dataBufferType, sourceBand.getNoDataValue(), sourceBand.isFlagBand(), (MultiLevelModel)intermediateMultiLevelModel, sourceBand.getRasterWidth(), this.referenceHeight);
                    targetImage = this.createInterpolatedImage(targetImage, sourceBand.getNoDataValue(), intermediateTransform, sourceBand.isFlagBand() || sourceBand.isIndexBand());
                }
                if (replacedNoData) {
                    targetImage = ResamplingOp.replaceNoDataValue((RasterDataNode)targetBand, targetImage, Double.NaN, sourceBand.getNoDataValue());
                }
                targetBand.setSourceImage(this.adjustImageToModelTransform(targetImage, (MultiLevelModel)targetMultiLevelModel));
                this.targetProduct.addBand((Band)targetBand);
            } else if (isVirtualBand) {
                targetBand = ProductUtils.copyVirtualBand((Product)this.targetProduct, (VirtualBand)((VirtualBand)sourceBand), (String)sourceBand.getName());
            } else {
                targetBand = ProductUtils.copyBand((String)sourceBand.getName(), (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)false);
                targetBand.setSourceImage(this.adjustImageToModelTransform(sourceBand.getSourceImage(), (MultiLevelModel)targetMultiLevelModel));
            }
            ProductUtils.copyRasterDataNodeProperties((RasterDataNode)sourceBand, (RasterDataNode)targetBand);
        }
    }

    private static MultiLevelImage createMaskedImage(RasterDataNode node, Number maskValue) {
        MultiLevelImage varImage = node.getSourceImage();
        if (node.getValidPixelExpression() != null) {
            varImage = ResamplingOp.replaceInvalidValuesByNaN(node, varImage, node.getValidMaskImage(), maskValue);
        }
        if (node.isNoDataValueUsed() && node.isNoDataValueSet()) {
            varImage = ResamplingOp.replaceNoDataValue(node, varImage, node.getNoDataValue(), maskValue);
        }
        return varImage;
    }

    private static MultiLevelImage replaceInvalidValuesByNaN(RasterDataNode rasterDataNode, final MultiLevelImage srcImage, final MultiLevelImage maskImage, final Number fillValue) {
        MultiLevelModel multiLevelModel = rasterDataNode.getMultiLevelModel();
        return new DefaultMultiLevelImage((MultiLevelSource)new AbstractMultiLevelSource(multiLevelModel){

            public RenderedImage createImage(int sourceLevel) {
                return new FillConstantOpImage(srcImage.getImage(sourceLevel), maskImage.getImage(sourceLevel), fillValue);
            }
        });
    }

    private static MultiLevelImage replaceNoDataValue(RasterDataNode rasterDataNode, final MultiLevelImage srcImage, final double noDataValue, final Number newValue) {
        MultiLevelModel multiLevelModel = rasterDataNode.getMultiLevelModel();
        final int targetDataType = ImageManager.getDataBufferType((int)rasterDataNode.getDataType());
        return new DefaultMultiLevelImage((MultiLevelSource)new AbstractMultiLevelSource(multiLevelModel){

            public RenderedImage createImage(int sourceLevel) {
                return new ReplaceValueOpImage(srcImage.getImage(sourceLevel), (Number)noDataValue, newValue, targetDataType);
            }
        });
    }

    private RenderedImage adjustImageToModelTransform(final MultiLevelImage image, MultiLevelModel model) {
        MultiLevelModel actualModel = model;
        if (model.getLevelCount() > image.getModel().getLevelCount()) {
            actualModel = new DefaultMultiLevelModel(image.getModel().getLevelCount(), model.getImageToModelTransform(0), image.getWidth(), image.getHeight());
        }
        AbstractMultiLevelSource source = new AbstractMultiLevelSource(actualModel){

            protected RenderedImage createImage(int level) {
                return image.getImage(level);
            }
        };
        return new DefaultMultiLevelImage((MultiLevelSource)source);
    }

    private MultiLevelImage createInterpolatedImage(MultiLevelImage sourceImage, double noDataValue, AffineTransform sourceImageToModelTransform, boolean isFlagOrIndexBand) {
        Interpolation interpolation = isFlagOrIndexBand ? Interpolation.getInstance((int)0) : this.getInterpolation();
        return Resample.createInterpolatedMultiLevelImage(sourceImage, noDataValue, sourceImageToModelTransform, this.referenceWidth, this.referenceHeight, this.referenceMultiLevelModel, interpolation);
    }

    private Interpolation getInterpolation() {
        int interpolation = this.getInterpolationType();
        return Interpolation.getInstance((int)interpolation);
    }

    private int getInterpolationType() {
        int interpolationType = "Nearest".equalsIgnoreCase(this.upsamplingMethod) ? 0 : ("Bilinear".equalsIgnoreCase(this.upsamplingMethod) ? 1 : ("Bicubic".equalsIgnoreCase(this.upsamplingMethod) ? 2 : -1));
        return interpolationType;
    }

    private MultiLevelImage createAggregatedImage(final MultiLevelImage sourceImage, final int dataBufferType, final double noDataValue, boolean isFlagBand, MultiLevelModel referenceModel, int targetWidth, int targetHeight) {
        AbstractMultiLevelSource source;
        AggregationType type;
        if (isFlagBand) {
            if (this.flagAggregationType == null) {
                throw new OperatorException("Invalid flag downsampling method");
            }
            type = this.flagAggregationType;
        } else {
            if (this.aggregationType == null) {
                throw new OperatorException("Invalid downsampling method");
            }
            type = this.aggregationType;
        }
        final Dimension tileSize = JAIUtils.computePreferredTileSize((int)targetWidth, (int)targetHeight, (int)1);
        if (this.resampleOnPyramidLevels) {
            float[] scalings = new float[]{sourceImage.getWidth() / this.referenceWidth, sourceImage.getHeight() / this.referenceHeight};
            source = new AbstractMultiLevelSource(referenceModel){

                protected RenderedImage createImage(int targetLevel) {
                    MultiLevelModel targetModel = this.getModel();
                    double targetScale = targetModel.getScale(targetLevel);
                    MultiLevelModel sourceModel = sourceImage.getModel();
                    int sourceLevel = sourceModel.getLevel(targetScale);
                    RenderedImage sourceLevelImage = sourceImage.getImage(sourceLevel);
                    ResolutionLevel resolutionLevel = ResolutionLevel.create((MultiLevelModel)this.getModel(), (int)targetLevel);
                    ImageLayout imageLayout = ImageManager.createSingleBandedImageLayout((int)dataBufferType, null, (int)ResamplingOp.this.referenceWidth, (int)ResamplingOp.this.referenceHeight, (Dimension)tileSize, (ResolutionLevel)resolutionLevel);
                    try {
                        return new AggregatedOpImage(sourceLevelImage, imageLayout, noDataValue, type, dataBufferType, sourceModel.getImageToModelTransform(sourceLevel), targetModel.getImageToModelTransform(targetLevel));
                    }
                    catch (NoninvertibleTransformException e) {
                        throw new OperatorException("Could not downsample band image");
                    }
                }
            };
        } else {
            try {
                ImageLayout imageLayout = ImageManager.createSingleBandedImageLayout((int)dataBufferType, null, (int)this.referenceWidth, (int)this.referenceHeight, (Dimension)tileSize, (ResolutionLevel)ResolutionLevel.MAXRES);
                AggregatedOpImage image = new AggregatedOpImage((RenderedImage)sourceImage, imageLayout, noDataValue, type, dataBufferType, sourceImage.getModel().getImageToModelTransform(0), referenceModel.getImageToModelTransform(0));
                source = new DefaultMultiLevelSource((RenderedImage)((Object)image), referenceModel);
            }
            catch (NoninvertibleTransformException e) {
                throw new OperatorException("Could not downsample band image");
            }
        }
        return new DefaultMultiLevelImage((MultiLevelSource)source);
    }

    private int findBestSourceLevel(double targetScale, MultiLevelModel sourceModel, float[] scalings) {
        float optimizedScaling = 0.0f;
        int optimizedSourceLevel = 0;
        boolean initialized = false;
        for (int sourceLevel = 0; sourceLevel < sourceModel.getLevelCount(); ++sourceLevel) {
            double sourceScale = sourceModel.getScale(sourceLevel);
            float scaleRatio = (float)(sourceScale / targetScale);
            if (!initialized) {
                optimizedScaling = scalings[0] * scaleRatio;
                optimizedSourceLevel = sourceLevel;
                initialized = true;
                continue;
            }
            if (!(Math.abs(1.0f - scalings[0] * scaleRatio) < Math.abs(1.0f - optimizedScaling))) continue;
            optimizedScaling = scalings[0] * scaleRatio;
            optimizedSourceLevel = sourceLevel;
        }
        return optimizedSourceLevel;
    }

    private void setReferenceValues() {
        this.validateReferenceSettings();
        if (this.referenceBandName != null) {
            Band referenceBand = this.sourceProduct.getBand(this.referenceBandName);
            this.referenceWidth = referenceBand.getRasterWidth();
            this.referenceHeight = referenceBand.getRasterHeight();
            this.referenceImageToModelTransform = referenceBand.getImageToModelTransform();
            this.referenceMultiLevelModel = referenceBand.getMultiLevelModel();
        } else if (this.targetWidth != null && this.targetHeight != null) {
            this.referenceWidth = this.targetWidth;
            this.referenceHeight = this.targetHeight;
            double scaleX = (double)this.sourceProduct.getSceneRasterWidth() / (double)this.referenceWidth;
            double scaleY = (double)this.sourceProduct.getSceneRasterHeight() / (double)this.referenceHeight;
            MathTransform imageToMapTransform = this.sourceProduct.getSceneGeoCoding().getImageToMapTransform();
            if (imageToMapTransform instanceof AffineTransform) {
                AffineTransform mapTransform = (AffineTransform)imageToMapTransform;
                this.referenceImageToModelTransform = new AffineTransform(scaleX * mapTransform.getScaleX(), 0.0, 0.0, scaleY * mapTransform.getScaleY(), mapTransform.getTranslateX(), mapTransform.getTranslateY());
            } else {
                this.referenceImageToModelTransform = new AffineTransform(scaleX, 0.0, 0.0, scaleY, 0.0, 0.0);
            }
            this.referenceMultiLevelModel = new DefaultMultiLevelModel(this.referenceImageToModelTransform, this.referenceWidth, this.referenceHeight);
        } else {
            MathTransform imageToMapTransform = this.sourceProduct.getSceneGeoCoding().getImageToMapTransform();
            if (imageToMapTransform instanceof AffineTransform) {
                AffineTransform mapTransform = (AffineTransform)imageToMapTransform;
                this.referenceWidth = (int)((double)this.sourceProduct.getSceneRasterWidth() * Math.abs(mapTransform.getScaleX()) / (double)this.targetResolution.intValue());
                this.referenceHeight = (int)((double)this.sourceProduct.getSceneRasterHeight() * Math.abs(mapTransform.getScaleY()) / (double)this.targetResolution.intValue());
                this.referenceImageToModelTransform = new AffineTransform((double)this.targetResolution.intValue(), 0.0, 0.0, (double)(-this.targetResolution.intValue()), mapTransform.getTranslateX(), mapTransform.getTranslateY());
                this.referenceMultiLevelModel = new DefaultMultiLevelModel(this.referenceImageToModelTransform, this.referenceWidth, this.referenceHeight);
            } else {
                throw new OperatorException("Use of target resolution parameter is not possible for this source product.");
            }
        }
    }

    private void validateReferenceSettings() {
        if (this.referenceBandName == null && this.targetWidth == null && this.targetHeight == null && this.targetResolution == null) {
            throw new OperatorException("Either referenceBandName or targetResolution or targetWidth together with targetHeight must be set.");
        }
        if (this.referenceBandName != null && (this.targetWidth != null || this.targetHeight != null || this.targetResolution != null)) {
            throw new OperatorException("If referenceBandName is set, targetWidth, targetHeight, and targetResolution must not be set");
        }
        if (this.targetResolution != null && (this.targetWidth != null || this.targetHeight != null)) {
            throw new OperatorException("If targetResolution is set, targetWidth, targetHeight, and referenceBandName must not be set");
        }
        if (this.targetWidth != null && this.targetHeight == null) {
            throw new OperatorException("If targetWidth is set, targetHeight must be set, too.");
        }
        if (this.targetWidth == null && this.targetHeight != null) {
            throw new OperatorException("If targetHeight is set, targetWidth must be set, too.");
        }
        if (this.targetResolution != null && !(this.sourceProduct.getSceneGeoCoding() instanceof CrsGeoCoding)) {
            throw new OperatorException("Use of targetResolution is only possible for products with crs geo-coding.");
        }
    }

    void validateInterpolationParameter() {
        if (this.getInterpolationType() == -1) {
            throw new OperatorException("Invalid upsampling method: " + this.upsamplingMethod);
        }
    }

    private void setResamplingTypes() {
        this.aggregationType = this.getAggregationType(this.downsamplingMethod);
        this.flagAggregationType = this.getAggregationType(this.flagDownsamplingMethod);
    }

    private AggregationType getAggregationType(String aggregationMethod) {
        switch (aggregationMethod) {
            case "Mean": {
                return AggregationType.Mean;
            }
            case "Median": {
                return AggregationType.Median;
            }
            case "Min": {
                return AggregationType.Min;
            }
            case "Max": {
                return AggregationType.Max;
            }
            case "First": {
                return AggregationType.First;
            }
            case "FlagAnd": {
                return AggregationType.FlagAnd;
            }
            case "FlagOr": {
                return AggregationType.FlagOr;
            }
            case "FlagMedianAnd": {
                return AggregationType.FlagMedianAnd;
            }
            case "FlagMedianOr": {
                return AggregationType.FlagMedianOr;
            }
        }
        return null;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(ResamplingOp.class);
        }
    }
}

