/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common.resample;

import org.esa.snap.core.gpf.common.resample.DoubleDataInterpolator;
import org.esa.snap.core.gpf.common.resample.InterpolationType;
import org.esa.snap.core.gpf.common.resample.Interpolator;
import org.esa.snap.core.gpf.common.resample.LongDataInterpolator;

public class InterpolatorFactory {
    public static Interpolator createInterpolator(InterpolationType type, int dataType) {
        if (dataType == 4 || dataType == 5) {
            switch (type) {
                case Nearest: {
                    return new DoubleDataInterpolator.NearestNeighbour();
                }
                case Bilinear: {
                    return new DoubleDataInterpolator.Bilinear();
                }
                case Cubic_Convolution: {
                    return new DoubleDataInterpolator.CubicConvolution();
                }
            }
        } else {
            switch (type) {
                case Nearest: {
                    return new LongDataInterpolator.NearestNeighbour();
                }
                case Bilinear: {
                    return new LongDataInterpolator.Bilinear();
                }
            }
        }
        throw new IllegalArgumentException("Interpolation method not supported");
    }
}

