/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.common;

import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.ConverterRegistry;
import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.AddCollectionDescriptor;
import javax.media.jai.operator.AddDescriptor;
import javax.media.jai.operator.FormatDescriptor;
import javax.media.jai.operator.MosaicDescriptor;
import javax.media.jai.operator.MosaicType;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.SourceProducts;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.image.ResolutionLevel;
import org.esa.snap.core.image.VirtualBandOpImage;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.jexp.impl.Tokenizer;
import org.esa.snap.core.util.jai.JAIUtils;
import org.esa.snap.core.util.math.MathUtils;
import org.geotools.factory.Hints;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@OperatorMetadata(alias="Mosaic", category="Raster/Geometric", version="1.0", authors="Marco Peters, Ralf Quast, Marco Z\u00fchlke", copyright="(c) 2009 by Brockmann Consult", description="Creates a mosaic out of a set of source products.", internal=false)
public class MosaicOp
extends Operator {
    @SourceProducts(count=-1, description="The source products to be used for mosaicking.")
    Product[] sourceProducts;
    @SourceProduct(description="A product to be updated.", optional=true)
    Product updateProduct;
    @TargetProduct
    Product targetProduct;
    @Parameter(itemAlias="variable", description="Specifies the bands in the target product.")
    Variable[] variables;
    @Parameter(itemAlias="condition", description="Specifies valid pixels considered in the target product.")
    Condition[] conditions;
    @Parameter(description="Specifies the way how conditions are combined.", defaultValue="OR", valueSet={"OR", "AND"})
    String combine;
    @Parameter(defaultValue="EPSG:4326", description="The CRS of the target product, represented as WKT or authority code.")
    String crs;
    @Parameter(description="Whether the source product should be orthorectified.", defaultValue="false")
    boolean orthorectify;
    @Parameter(description="The name of the elevation model for the orthorectification.")
    String elevationModelName;
    @Parameter(alias="resampling", label="Resampling Method", description="The method used for resampling.", valueSet={"Nearest", "Bilinear", "Bicubic"}, defaultValue="Nearest")
    String resamplingName;
    @Parameter(description="The western longitude.", interval="[-180,180]", defaultValue="-15.0")
    double westBound;
    @Parameter(description="The northern latitude.", interval="[-90,90]", defaultValue="75.0")
    double northBound;
    @Parameter(description="The eastern longitude.", interval="[-180,180]", defaultValue="30.0")
    double eastBound;
    @Parameter(description="The southern latitude.", interval="[-90,90]", defaultValue="35.0")
    double southBound;
    @Parameter(description="Size of a pixel in X-direction in map units.", defaultValue="0.05")
    double pixelSizeX;
    @Parameter(description="Size of a pixel in Y-direction in map units.", defaultValue="0.05")
    double pixelSizeY;
    private Product[] reprojectedProducts;

    @Override
    public void initialize() throws OperatorException {
        if (this.isUpdateMode()) {
            this.initFields();
            this.targetProduct = this.updateProduct;
            this.updateMetadata(this.targetProduct);
        } else {
            this.targetProduct = this.createTargetProduct();
        }
        this.reprojectedProducts = this.createReprojectedProducts();
        List<List<PlanarImage>> alphaImageList = this.createAlphaImages();
        List<List<RenderedImage>> sourceImageList = this.createSourceImages();
        List<RenderedImage> mosaicImageList = this.createMosaicImages(sourceImageList, alphaImageList);
        List<RenderedImage> variableCountImageList = this.createVariableCountImages(alphaImageList);
        this.setTargetBandImages(this.targetProduct, mosaicImageList, variableCountImageList);
        this.reprojectedProducts = null;
    }

    private void updateMetadata(Product product) {
        MetadataElement graphElement = product.getMetadataRoot().getElement("Processing_Graph");
        for (MetadataElement nodeElement : graphElement.getElements()) {
            if (!this.getSpi().getOperatorAlias().equals(nodeElement.getAttributeString("operator"))) continue;
            MetadataElement sourcesElement = nodeElement.getElement("sources");
            for (int i = 0; i < this.sourceProducts.length; ++i) {
                String oldIndex = String.valueOf(i + 1);
                String newIndex = String.valueOf(sourcesElement.getNumAttributes() + i + 1);
                Product sourceProduct = this.sourceProducts[i];
                String attributeName = this.getSourceProductId(sourceProduct).replaceFirst(oldIndex, newIndex);
                File location = sourceProduct.getFileLocation();
                ProductData attributeValue = location == null ? ProductData.createInstance((String)product.toString()) : ProductData.createInstance((String)location.getPath());
                MetadataAttribute attribute = new MetadataAttribute(attributeName, attributeValue, true);
                sourcesElement.addAttribute(attribute);
            }
        }
    }

    private void initFields() {
        Map<String, Object> params = MosaicOp.getOperatorParameters(this.updateProduct);
        MosaicOp.initObject(params, this);
    }

    private List<RenderedImage> createVariableCountImages(List<List<PlanarImage>> alphaImageList) {
        ArrayList<RenderedImage> variableCountImageList = new ArrayList<RenderedImage>(this.variables.length);
        for (List<PlanarImage> variableAlphaImageList : alphaImageList) {
            RenderedImage countFloatImage = this.createImageSum(variableAlphaImageList);
            variableCountImageList.add((RenderedImage)FormatDescriptor.create((RenderedImage)countFloatImage, (Integer)3, null));
        }
        return variableCountImageList;
    }

    private List<List<PlanarImage>> createAlphaImages() {
        ArrayList<List<PlanarImage>> alphaImageList = new ArrayList<List<PlanarImage>>(this.variables.length);
        for (Variable variable : this.variables) {
            ArrayList<Object> list = new ArrayList<Object>(this.reprojectedProducts.length);
            alphaImageList.add(list);
            for (Product product : this.reprojectedProducts) {
                String validMaskExpression;
                try {
                    validMaskExpression = MosaicOp.createValidMaskExpression(product, variable.getExpression());
                }
                catch (ParseException e) {
                    throw new OperatorException(e);
                }
                StringBuilder combinedExpression = new StringBuilder(validMaskExpression);
                if (this.conditions != null && this.conditions.length > 0) {
                    combinedExpression.append(" && (");
                    for (int i = 0; i < this.conditions.length; ++i) {
                        Condition condition = this.conditions[i];
                        if (i != 0) {
                            combinedExpression.append(" ").append(this.combine).append(" ");
                        }
                        combinedExpression.append(condition.getExpression());
                    }
                    combinedExpression.append(")");
                }
                list.add(this.createExpressionImage(combinedExpression.toString(), product));
            }
            if (!this.isUpdateMode()) continue;
            MultiLevelImage updateImage = this.updateProduct.getBand(this.getCountBandName(variable)).getSourceImage();
            list.add(FormatDescriptor.create((RenderedImage)updateImage, (Integer)4, null));
        }
        return alphaImageList;
    }

    private static String createValidMaskExpression(Product product, String expression) throws ParseException {
        return BandArithmetic.getValidMaskExpression((String)expression, (Product)product, null);
    }

    private List<RenderedImage> createMosaicImages(List<List<RenderedImage>> sourceImageList, List<List<PlanarImage>> alphaImageList) {
        ImageLayout imageLayout = ImageManager.createSingleBandedImageLayout((int)ImageManager.getDataBufferType((int)30), (int)this.targetProduct.getSceneRasterWidth(), (int)this.targetProduct.getSceneRasterHeight(), (Dimension)ImageManager.getPreferredTileSize((Product)this.targetProduct), (ResolutionLevel)ResolutionLevel.MAXRES);
        Hints hints = new Hints(JAI.KEY_IMAGE_LAYOUT, (Object)imageLayout);
        ArrayList<RenderedImage> mosaicImages = new ArrayList<RenderedImage>(sourceImageList.size());
        for (int i = 0; i < sourceImageList.size(); ++i) {
            PlanarImage[] sourceAlphas = alphaImageList.get(i).toArray(new PlanarImage[alphaImageList.size()]);
            List<RenderedImage> sourceImages = sourceImageList.get(i);
            RenderedImage[] renderedImages = sourceImages.toArray(new RenderedImage[sourceImages.size()]);
            mosaicImages.add((RenderedImage)MosaicDescriptor.create((RenderedImage[])renderedImages, (MosaicType)MosaicDescriptor.MOSAIC_TYPE_BLEND, (PlanarImage[])sourceAlphas, null, (double[][])null, null, (RenderingHints)hints));
        }
        return mosaicImages;
    }

    private void setTargetBandImages(Product product, List<RenderedImage> bandImages, List<RenderedImage> variableCountImageList) {
        for (int i = 0; i < this.variables.length; ++i) {
            Variable outputVariable = this.variables[i];
            product.getBand(outputVariable.getName()).setSourceImage(bandImages.get(i));
            String countBandName = this.getCountBandName(outputVariable);
            product.getBand(countBandName).setSourceImage(variableCountImageList.get(i));
        }
        if (this.conditions != null) {
            for (Condition condition : this.conditions) {
                RenderedOp reformattedImage;
                if (!condition.isOutput()) continue;
                RenderedImage sumImage = this.createConditionSumImage(condition);
                RenderedOp condImage = reformattedImage = FormatDescriptor.create((RenderedImage)sumImage, (Integer)3, null);
                if (this.isUpdateMode()) {
                    MultiLevelImage updateImage = this.updateProduct.getBand(condition.getName()).getSourceImage();
                    condImage = AddDescriptor.create((RenderedImage)reformattedImage, (RenderedImage)updateImage, null);
                }
                Band band = product.getBand(condition.getName());
                band.setSourceImage((RenderedImage)condImage);
            }
        }
    }

    private String getCountBandName(Variable outputVariable) {
        return String.format("%s_count", outputVariable.getName());
    }

    private RenderedImage createConditionSumImage(Condition condition) {
        ArrayList<PlanarImage> renderedImageList = new ArrayList<PlanarImage>(this.reprojectedProducts.length);
        for (Product reprojectedProduct : this.reprojectedProducts) {
            renderedImageList.add(this.createConditionImage(condition, reprojectedProduct));
        }
        return this.createImageSum(renderedImageList);
    }

    private PlanarImage createConditionImage(Condition condition, Product reprojectedProduct) {
        String validMaskExpression;
        try {
            validMaskExpression = MosaicOp.createValidMaskExpression(reprojectedProduct, condition.getExpression());
        }
        catch (ParseException e) {
            throw new OperatorException(e);
        }
        String expression = validMaskExpression + " && (" + condition.getExpression() + ")";
        return this.createExpressionImage(expression, reprojectedProduct);
    }

    private RenderedImage createImageSum(List<? extends RenderedImage> renderedImageList) {
        if (renderedImageList.size() >= 2) {
            return AddCollectionDescriptor.create(renderedImageList, null);
        }
        return renderedImageList.get(0);
    }

    private List<List<RenderedImage>> createSourceImages() {
        ArrayList<List<RenderedImage>> sourceImageList = new ArrayList<List<RenderedImage>>(this.variables.length);
        for (Variable variable : this.variables) {
            ArrayList<Object> renderedImageList = new ArrayList<Object>(this.reprojectedProducts.length);
            sourceImageList.add(renderedImageList);
            for (Product product : this.reprojectedProducts) {
                renderedImageList.add(this.createExpressionImage(variable.getExpression(), product));
            }
            if (!this.isUpdateMode()) continue;
            renderedImageList.add(this.updateProduct.getBand(variable.getName()).getSourceImage());
        }
        return sourceImageList;
    }

    private boolean isUpdateMode() {
        return this.updateProduct != null;
    }

    private PlanarImage createExpressionImage(String expression, Product product) {
        MultiLevelImage sourceImage = product.getBandAt(0).getSourceImage();
        ResolutionLevel resolutionLevel = ResolutionLevel.create((MultiLevelModel)sourceImage.getModel(), (int)0);
        float fillValue = 0.0f;
        Dimension tileSize = new Dimension(sourceImage.getTileWidth(), sourceImage.getTileHeight());
        return VirtualBandOpImage.builder((String)expression, (Product)product).dataType(30).fillValue((Number)Float.valueOf(fillValue)).tileSize(tileSize).mask(false).level(resolutionLevel).create();
    }

    private Product[] createReprojectedProducts() {
        ArrayList<Product> reprojProductList = new ArrayList<Product>(this.sourceProducts.length);
        HashMap<String, Object> projParameters = this.createProjectionParameters();
        for (Product sourceProduct : this.sourceProducts) {
            String msg;
            if (sourceProduct.getSceneGeoCoding() == null) {
                msg = "Source product: '" + sourceProduct.getName() + "' contains no geo-coding. Skipped for further processing.";
                this.getLogger().warning(msg);
                continue;
            }
            if (sourceProduct.isMultiSize()) {
                msg = "Source product: '" + sourceProduct.getName() + "' contains rasters of different sizes. Skipped for further processing.";
                this.getLogger().warning(msg);
                continue;
            }
            HashMap<String, Product> projProducts = new HashMap<String, Product>();
            projProducts.put("source", sourceProduct);
            projProducts.put("collocateWith", this.targetProduct);
            reprojProductList.add(GPF.createProduct("Reproject", projParameters, projProducts));
        }
        return reprojProductList.toArray(new Product[reprojProductList.size()]);
    }

    private HashMap<String, Object> createProjectionParameters() {
        HashMap<String, Object> projParameters = new HashMap<String, Object>();
        projParameters.put("resamplingName", this.resamplingName);
        projParameters.put("includeTiePointGrids", true);
        if (this.orthorectify) {
            projParameters.put("orthorectify", true);
            projParameters.put("elevationModelName", this.elevationModelName);
        }
        return projParameters;
    }

    private Product createTargetProduct() {
        try {
            CoordinateReferenceSystem targetCRS;
            try {
                targetCRS = CRS.parseWKT((String)this.crs);
            }
            catch (FactoryException e) {
                targetCRS = CRS.decode((String)this.crs, (boolean)true);
            }
            Rectangle2D.Double bounds = new Rectangle2D.Double();
            bounds.setFrameFromDiagonal(this.westBound, this.northBound, this.eastBound, this.southBound);
            ReferencedEnvelope boundsEnvelope = new ReferencedEnvelope((Rectangle2D)bounds, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            ReferencedEnvelope targetEnvelope = boundsEnvelope.transform(targetCRS, true);
            int width = MathUtils.floorInt((double)(targetEnvelope.getSpan(0) / this.pixelSizeX));
            int height = MathUtils.floorInt((double)(targetEnvelope.getSpan(1) / this.pixelSizeY));
            CrsGeoCoding geoCoding = new CrsGeoCoding(targetCRS, width, height, targetEnvelope.getMinimum(0), targetEnvelope.getMaximum(1), this.pixelSizeX, this.pixelSizeY);
            Product product = new Product("mosaic", "BEAM_MOSAIC", width, height);
            product.setSceneGeoCoding((GeoCoding)geoCoding);
            Dimension tileSize = JAIUtils.computePreferredTileSize((int)width, (int)height, (int)1);
            product.setPreferredTileSize(tileSize);
            this.addTargetBands(product);
            return product;
        }
        catch (Exception e) {
            throw new OperatorException(e);
        }
    }

    private void addTargetBands(Product product) {
        Band band;
        for (Variable outputVariable : this.variables) {
            band = product.addBand(outputVariable.getName(), 30);
            band.setDescription(outputVariable.getExpression());
            String countBandName = this.getCountBandName(outputVariable);
            band.setValidPixelExpression(String.format("%s > 0", Tokenizer.createExternalName((String)countBandName)));
            Band countBand = product.addBand(countBandName, 12);
            countBand.setDescription(String.format("Count of %s", outputVariable.getName()));
        }
        if (this.conditions != null) {
            for (Condition condition : this.conditions) {
                if (!condition.isOutput()) continue;
                band = product.addBand(condition.getName(), 12);
                band.setDescription(condition.getExpression());
            }
        }
    }

    public static Map<String, Object> getOperatorParameters(Product product) throws OperatorException {
        MetadataElement graphElement = product.getMetadataRoot().getElement("Processing_Graph");
        if (graphElement == null) {
            throw new OperatorException("Product has no metadata element named 'Processing_Graph'");
        }
        String operatorAlias = "Mosaic";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        boolean operatorFound = false;
        for (MetadataElement nodeElement : graphElement.getElements()) {
            if (!"Mosaic".equals(nodeElement.getAttributeString("operator"))) continue;
            operatorFound = true;
            MosaicOp.collectParameters(MosaicOp.class, nodeElement.getElement("parameters"), parameters);
        }
        if (!operatorFound) {
            throw new OperatorException("No metadata found for operator 'Mosaic'");
        }
        return parameters;
    }

    private static void collectParameters(Class<?> operatorClass, MetadataElement parentElement, Map<String, Object> parameters) {
        for (Field field : operatorClass.getDeclaredFields()) {
            Parameter annotation = field.getAnnotation(Parameter.class);
            if (annotation == null) continue;
            Class<?> fieldType = field.getType();
            if (fieldType.isArray()) {
                MosaicOp.initArrayParameter(parentElement, field, parameters);
                continue;
            }
            MosaicOp.initParameter(parentElement, field, parameters);
        }
    }

    private static void initParameter(MetadataElement parentElement, Field field, Map<String, Object> parameters) throws OperatorException {
        Parameter annotation = field.getAnnotation(Parameter.class);
        String name = annotation.alias();
        if (name.isEmpty()) {
            name = field.getName();
        }
        try {
            if (parentElement.containsAttribute(name)) {
                Converter<?> converter = MosaicOp.getConverter(field.getType(), annotation);
                String parameterText = parentElement.getAttributeString(name);
                Object value = converter.parse(parameterText);
                parameters.put(name, value);
            } else {
                MetadataElement element = parentElement.getElement(name);
                if (element != null) {
                    Object obj = field.getType().newInstance();
                    HashMap<String, Object> objParams = new HashMap<String, Object>();
                    MosaicOp.collectParameters(obj.getClass(), element, objParams);
                    MosaicOp.initObject(objParams, obj);
                    parameters.put(name, obj);
                }
            }
        }
        catch (Exception e) {
            throw new OperatorException(String.format("Cannot initialise operator parameter '%s'", name), e);
        }
    }

    private static void initArrayParameter(MetadataElement parentElement, Field field, Map<String, Object> parameters) throws OperatorException {
        String name = field.getAnnotation(Parameter.class).alias();
        if (name.isEmpty()) {
            name = field.getName();
        }
        MetadataElement element = parentElement.getElement(name);
        try {
            if (element != null) {
                MetadataElement[] elements = element.getElements();
                Class<?> componentType = field.getType().getComponentType();
                Object array = Array.newInstance(componentType, elements.length);
                for (int i = 0; i < elements.length; ++i) {
                    MetadataElement arrayElement = elements[i];
                    Object componentInstance = componentType.newInstance();
                    HashMap<String, Object> objParams = new HashMap<String, Object>();
                    MosaicOp.collectParameters(componentInstance.getClass(), arrayElement, objParams);
                    MosaicOp.initObject(objParams, componentInstance);
                    Array.set(array, i, componentInstance);
                }
                parameters.put(name, array);
            }
        }
        catch (Exception e) {
            throw new OperatorException(String.format("Cannot initialise operator parameter '%s'", name), e);
        }
    }

    private static void initObject(Map<String, Object> params, Object object) {
        for (Field field : object.getClass().getDeclaredFields()) {
            Parameter annotation = field.getAnnotation(Parameter.class);
            if (annotation == null) continue;
            String name = annotation.alias();
            if (name.isEmpty()) {
                name = field.getName();
            }
            try {
                field.set(object, params.get(name));
            }
            catch (Exception e) {
                String msg = String.format("Cannot initialise operator parameter '%s'", name);
                throw new OperatorException(msg, e);
            }
        }
    }

    private static Converter<?> getConverter(Class<?> type, Parameter parameter) throws OperatorException {
        Class<? extends Converter> converter = parameter.converter();
        if (converter == Converter.class) {
            return ConverterRegistry.getInstance().getConverter(type);
        }
        try {
            return converter.newInstance();
        }
        catch (Exception e) {
            String message = String.format("Cannot find converter for  type '%s'", type);
            throw new OperatorException(message, e);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(MosaicOp.class);
        }
    }

    public static class Condition {
        @Parameter(description="The name of the condition.")
        String name;
        @Parameter(description="The expression of the condition.")
        String expression;
        @Parameter(description="Whether the result of the condition shall be written.")
        boolean output;

        public Condition() {
        }

        public Condition(String name, String expression, boolean output) {
            this.name = name;
            this.expression = expression;
            this.output = output;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getExpression() {
            return this.expression;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }

        public boolean isOutput() {
            return this.output;
        }

        public void setOutput(boolean output) {
            this.output = output;
        }
    }

    public static class Variable {
        @Parameter(description="The name of the variable.")
        String name;
        @Parameter(description="The expression of the variable.")
        String expression;

        public Variable() {
        }

        public Variable(String name, String expression) {
            this.name = name;
            this.expression = expression;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getExpression() {
            return this.expression;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }
    }
}

