/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.ral.nujan.netcdf;

import edu.ucar.ral.nujan.hdf.HdfException;
import edu.ucar.ral.nujan.hdf.HdfGroup;
import edu.ucar.ral.nujan.netcdf.NhDimension;
import edu.ucar.ral.nujan.netcdf.NhException;
import edu.ucar.ral.nujan.netcdf.NhFileWriter;
import edu.ucar.ral.nujan.netcdf.NhVariable;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class NhGroup {
    String groupName;
    NhGroup parentGroup;
    NhFileWriter nhFile;
    HdfGroup hdfGroup;
    ArrayList<NhGroup> subGroupList = new ArrayList();
    ArrayList<NhDimension> dimensionList = new ArrayList();
    ArrayList<NhVariable> variableList = new ArrayList();

    NhGroup(String groupName, NhGroup parentGroup, NhFileWriter nhFile) throws HdfException {
        if (nhFile.bugs >= 1) {
            String parentName = "(null)";
            if (parentGroup != null) {
                parentName = parentGroup.getPath();
            }
            NhGroup.prtf("NhGroup.const: groupName: \"%s\"  parent: \"%s\"  file: \"%s\"", groupName, parentName, nhFile.getPath());
        }
        this.groupName = groupName;
        this.parentGroup = parentGroup;
        this.nhFile = nhFile;
        this.hdfGroup = parentGroup == null ? null : parentGroup.hdfGroup.addGroup(groupName);
    }

    public String toString() {
        String res = String.format("path: \"%s\"  numSubGrp: %d  numDim: %d  numVar: %d", this.getPath(), this.subGroupList.size(), this.dimensionList.size(), this.variableList.size());
        return res;
    }

    public NhGroup getParentGroup() {
        return this.parentGroup;
    }

    public NhFileWriter getFileWriter() {
        return this.nhFile;
    }

    public String getName() {
        return this.groupName;
    }

    public String getPath() {
        String res = "";
        NhGroup grp = this;
        while (grp != null) {
            if (res.length() != 0) {
                res = "/" + res;
            }
            res = grp.groupName + res;
            grp = grp.parentGroup;
        }
        if (res.length() == 0) {
            res = "/";
        }
        return res;
    }

    public NhGroup[] getSubGroups() {
        return this.subGroupList.toArray(new NhGroup[0]);
    }

    public NhDimension[] getDimensions() {
        return this.dimensionList.toArray(new NhDimension[0]);
    }

    public NhVariable[] getVariables() {
        return this.variableList.toArray(new NhVariable[0]);
    }

    public NhGroup findSubGroup(String nm) {
        NhGroup res = null;
        for (NhGroup tgrp : this.subGroupList) {
            if (!tgrp.groupName.equals(nm)) continue;
            res = tgrp;
            break;
        }
        return res;
    }

    public NhVariable findVariable(String nm) {
        NhVariable res = null;
        for (NhVariable tvar : this.variableList) {
            if (!tvar.varName.equals(nm)) continue;
            res = tvar;
            break;
        }
        return res;
    }

    public NhDimension findLocalDimension(String nm) {
        NhDimension res = null;
        for (NhDimension tdim : this.dimensionList) {
            if (!tdim.dimName.equals(nm)) continue;
            res = tdim;
            break;
        }
        return res;
    }

    public NhDimension findAncestorDimension(String nm) {
        NhDimension res = null;
        NhGroup tgrp = this;
        while (tgrp != null && res == null) {
            for (NhDimension tdim : tgrp.dimensionList) {
                if (!tdim.dimName.equals(nm)) continue;
                res = tdim;
                break;
            }
            tgrp = tgrp.parentGroup;
        }
        return res;
    }

    public NhGroup addGroup(String subName) throws NhException {
        if (this.nhFile.bugs >= 1) {
            NhGroup.prtf("NhGroup.addGroup: this: \"%s\"  subName: \"%s\"  file: \"%s\"", this.getPath(), subName, this.nhFile.getPath());
        }
        NhGroup.checkName(subName, "subGroup in group \"" + this.groupName + "\"");
        NhGroup subGrp = null;
        try {
            subGrp = new NhGroup(subName, this, this.nhFile);
        }
        catch (HdfException exc) {
            exc.printStackTrace();
            NhGroup.throwerr("caught: " + exc, new Object[0]);
        }
        this.subGroupList.add(subGrp);
        return subGrp;
    }

    public NhDimension addDimension(String dimName, int dimLen) throws NhException {
        if (this.nhFile.bugs >= 1) {
            NhGroup.prtf("NhGroup.addDimension: this: \"%s\"  dimName: \"%s\"  dimLen: %d", this.getPath(), dimName, dimLen);
        }
        NhGroup.checkName(dimName, "dimension in group \"" + this.groupName + "\"");
        NhDimension nhDim = new NhDimension(dimName, dimLen, this);
        this.dimensionList.add(nhDim);
        return nhDim;
    }

    public NhVariable addVariable(String varName, int nhType, NhDimension[] nhDims, int[] chunkLens, Object fillValue, int compressionLevel) throws NhException {
        if (this.nhFile.bugs >= 1) {
            NhGroup.prtf("NhGroup.addVariable: this: \"" + this.getPath() + "\"" + "  var name: \"" + varName + "\"\n" + "  nhType: " + NhVariable.nhTypeNames[nhType], new Object[0]);
            if (nhDims == null) {
                NhGroup.prtf("  dims: (null)", new Object[0]);
            } else {
                String msg = "  nhDims (len " + nhDims.length + "): ";
                for (int ii = 0; ii < nhDims.length; ++ii) {
                    NhDimension dm = nhDims[ii];
                    if (dm == null) {
                        NhGroup.throwerr("nhDims element " + ii + " is null", new Object[0]);
                    }
                    msg = msg + "  \"" + dm.dimName + "\"(" + dm.dimLen + ")";
                }
                NhGroup.prtf(msg, new Object[0]);
            }
            NhGroup.prtf("  chunkLens: " + NhGroup.formatInts(chunkLens), new Object[0]);
            NhGroup.prtf("  fill: " + fillValue, new Object[0]);
            NhGroup.prtf("  compressionLevel: " + compressionLevel, new Object[0]);
        }
        NhGroup.checkName(varName, "variable in group \"" + this.groupName + "\"");
        if (fillValue != null && nhType == 9) {
            NhGroup.throwerr("TP_STRING_* variables must have fillValue == null", new Object[0]);
        }
        NhVariable nhVar = null;
        nhVar = new NhVariable(varName, nhType, nhDims, chunkLens, fillValue, compressionLevel, this, this.nhFile);
        this.variableList.add(nhVar);
        return nhVar;
    }

    public boolean attributeExists(String attrName) {
        boolean bres = false;
        if (this.hdfGroup.findAttribute(attrName) != null) {
            bres = true;
        }
        return bres;
    }

    public void addAttribute(String attrName, int atType, Object attrValue) throws NhException {
        if (this.nhFile.bugs >= 1) {
            NhGroup.prtf("NhGroup.addAttribute: this: \"" + this.getPath() + "\"" + "  attrName: \"" + attrName + "\"" + "  type: " + NhVariable.nhTypeNames[atType], new Object[0]);
        }
        if (this.nhFile.bugs >= 10) {
            NhGroup.prtf("  attrValue: " + attrValue, new Object[0]);
        }
        NhGroup.checkName(attrName, "attribute in group \"" + this.groupName + "\"");
        attrValue = NhVariable.getAttrValue(attrName, attrValue, "group \"" + this.groupName + "\"", this.nhFile.bugs);
        int dtype = NhVariable.findDtype(attrName, atType);
        if (dtype == 10 && NhVariable.testScalar(attrValue)) {
            dtype = 9;
        }
        int stgFieldLen = 0;
        try {
            this.hdfGroup.addAttribute(attrName, dtype, stgFieldLen, attrValue, false);
        }
        catch (HdfException exc) {
            exc.printStackTrace();
            NhGroup.throwerr("caught: " + exc, new Object[0]);
        }
    }

    public static void checkName(String name, String loc) throws NhException {
        if (name == null || name.length() == 0) {
            NhGroup.throwerr("Name for %s is empty", loc);
        }
        if (!Pattern.matches("^[_a-zA-Z][-_: a-zA-Z0-9]*$", name)) {
            NhGroup.throwerr("Invalid name for %s.  Name: \"%s\"", loc, name);
        }
    }

    static String formatInts(int[] vals) {
        String res = "";
        if (vals == null) {
            res = "(null)";
        } else {
            for (int ii = 0; ii < vals.length; ++ii) {
                if (ii > 0) {
                    res = res + " ";
                }
                res = res + vals[ii];
            }
        }
        return res;
    }

    static void throwerr(String msg, Object ... args) throws NhException {
        throw new NhException(String.format(msg, args));
    }

    static void prtf(String msg, Object ... args) {
        System.out.printf(msg + "\n", args);
    }
}

