/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.ral.nujan.netcdf;

import edu.ucar.ral.nujan.netcdf.NhDimension;
import edu.ucar.ral.nujan.netcdf.NhException;
import edu.ucar.ral.nujan.netcdf.NhFileWriter;
import edu.ucar.ral.nujan.netcdf.NhGroup;
import edu.ucar.ral.nujan.netcdf.NhVariable;

public class NhExamplea {
    static void badparms(String msg) {
        NhExamplea.prtln("Error: " + msg);
        NhExamplea.prtln("Parms:");
        NhExamplea.prtln("  -outFile      <fname>");
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            NhExamplea.testIt(args);
        }
        catch (NhException exc) {
            exc.printStackTrace();
            NhExamplea.prtln("main: caught: " + exc);
            System.exit(1);
        }
    }

    static void testIt(String[] args) throws NhException {
        String outFile = null;
        if (args.length % 2 != 0) {
            NhExamplea.badparms("parms must be key/value pairs");
        }
        for (int iarg = 0; iarg < args.length; iarg += 2) {
            String key = args[iarg];
            String val = args[iarg + 1];
            if (key.equals("-outFile")) {
                outFile = val;
                continue;
            }
            NhExamplea.badparms("unkown parm: " + key);
        }
        if (outFile == null) {
            NhExamplea.badparms("missing parm: -outFile");
        }
        NhFileWriter hfile = new NhFileWriter(outFile, 1);
        NhExamplea.prtln("hfile: " + hfile);
        NhGroup rootGroup = hfile.getRootGroup();
        int rank = 2;
        int[] dimLens = new int[rank];
        dimLens[0] = 10;
        dimLens[1] = 10;
        NhDimension[] nhDims = new NhDimension[rank];
        nhDims[0] = rootGroup.addDimension("ydim", dimLens[0]);
        nhDims[1] = rootGroup.addDimension("xdim", dimLens[1]);
        rootGroup.addAttribute("someName", 9, "some long comment");
        NhGroup northernGroup = rootGroup.addGroup("northernData");
        northernGroup.addAttribute("cityIndices", 4, new int[]{1, 2, 3, 5, 7, 13, 17});
        Double fillValue = new Double(-999999.0);
        int compressLevel = 0;
        int[] chunkLens = null;
        NhVariable humidity = northernGroup.addVariable("humidity", 7, nhDims, chunkLens, fillValue, compressLevel);
        NhExamplea.prtln("humidity: " + humidity);
        humidity.addAttribute("someUnits", 9, "celsius");
        chunkLens = new int[]{7, 7};
        NhVariable temperature = northernGroup.addVariable("temperature", 7, nhDims, chunkLens, fillValue, compressLevel);
        NhExamplea.prtln("temperature: " + temperature);
        hfile.endDefine();
        double[][] humidityData = new double[dimLens[0]][dimLens[1]];
        for (int iy = 0; iy < dimLens[0]; ++iy) {
            for (int ix = 0; ix < dimLens[1]; ++ix) {
                humidityData[iy][ix] = 100 * iy + ix;
            }
        }
        int[] startIxs = null;
        humidity.writeData(startIxs, humidityData, false);
        startIxs = new int[]{0, 0};
        block3: do {
            int chunkLenY = Math.min(chunkLens[0], dimLens[0] - startIxs[0]);
            int chunkLenX = Math.min(chunkLens[1], dimLens[1] - startIxs[1]);
            NhExamplea.prtln("NhExamplea: write chunk: startIxs: " + startIxs[0] + "  " + startIxs[1] + "  chunkLenY: " + chunkLenY + "  chunkLenX: " + chunkLenX);
            double[][] temperatureChunk = new double[chunkLenY][chunkLenX];
            for (int iy = 0; iy < chunkLenY; ++iy) {
                for (int ix = 0; ix < chunkLenX; ++ix) {
                    temperatureChunk[iy][ix] = 100 * startIxs[0] + startIxs[1] + 100 * iy + ix;
                    NhExamplea.prtln("    iy: " + iy + "  ix: " + ix + "  temperature: " + temperatureChunk[iy][ix]);
                }
            }
            temperature.writeData(startIxs, temperatureChunk, false);
            for (int jj = rank - 1; jj >= 0; --jj) {
                int n = jj;
                startIxs[n] = startIxs[n] + chunkLens[jj];
                if (jj <= 0 || startIxs[jj] < dimLens[jj]) continue block3;
                startIxs[jj] = 0;
            }
        } while (startIxs[0] < dimLens[0]);
        hfile.close();
        NhExamplea.prtln("All done");
    }

    static void throwerr(String msg, Object ... args) throws NhException {
        throw new NhException(String.format(msg, args));
    }

    static void prtln(String msg) {
        System.out.println(msg);
    }
}

