/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.ral.nujan.hdf;

import edu.ucar.ral.nujan.hdf.HBuffer;
import edu.ucar.ral.nujan.hdf.HdfException;
import edu.ucar.ral.nujan.hdf.HdfFileWriter;
import edu.ucar.ral.nujan.hdf.HdfGroup;
import edu.ucar.ral.nujan.hdf.HdfUtil;
import edu.ucar.ral.nujan.hdf.MsgBase;

class MsgLinkit
extends MsgBase {
    final int linkitVersion = 1;
    final int linkFlag = 7;
    long linkOrder;
    HdfGroup linkGroup;

    MsgLinkit(long linkOrder, HdfGroup linkGroup, HdfGroup hdfGroup, HdfFileWriter hdfFile) throws HdfException {
        super(6, hdfGroup, hdfFile);
        this.linkOrder = linkOrder;
        this.linkGroup = linkGroup;
    }

    @Override
    public String toString() {
        String res = super.toString();
        res = res + "  linkOrder: " + this.linkOrder;
        res = res + "  linkGroup name: " + this.linkGroup.groupName;
        return res;
    }

    @Override
    void formatMsgCore(int formatPass, HBuffer fmtBuf) throws HdfException {
        fmtBuf.putBufByte("MsgLinkit: linkitVersion", 1);
        fmtBuf.putBufByte("MsgLinkit: linkFlag", 7);
        fmtBuf.putBufLong("MsgLinkit: linkOrder", this.linkOrder);
        byte[] nameEnc = HdfUtil.encodeString(this.linkGroup.groupName, false, this.hdfGroup);
        fmtBuf.putBufLong("MsgLinkit: linkName len", nameEnc.length);
        fmtBuf.putBufBytes("MsgLinkit: linkName", nameEnc);
        fmtBuf.putBufLong("MsgLinkit: linkGroup", this.linkGroup.blkPosition);
        if (formatPass != 0) {
            this.hdfFile.addWork("MsgLinkit", this.linkGroup);
        }
    }
}

