/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.ral.nujan.hdf;

import edu.ucar.ral.nujan.hdf.BtreeNode;
import edu.ucar.ral.nujan.hdf.HBuffer;
import edu.ucar.ral.nujan.hdf.HdfChunk;
import edu.ucar.ral.nujan.hdf.HdfException;
import edu.ucar.ral.nujan.hdf.HdfFileWriter;
import edu.ucar.ral.nujan.hdf.HdfGroup;
import edu.ucar.ral.nujan.hdf.MsgBase;

class MsgLayout
extends MsgBase {
    static final int LY_COMPACT = 0;
    static final int LY_CONTIGUOUS = 1;
    static final int LY_CHUNKED = 2;
    static final String[] classNames = new String[]{"COMPACT", "CONTIGUOUS", "CHUNKED"};
    final int layoutVersion = 3;
    int layoutClass;
    int compressionLevel;
    BtreeNode chunkBtree;

    MsgLayout(int layoutClass, int compressionLevel, HdfGroup hdfGroup, HdfFileWriter hdfFile) throws HdfException {
        super(8, hdfGroup, hdfFile);
        this.layoutClass = layoutClass;
        this.compressionLevel = compressionLevel;
        if (compressionLevel > 0 && layoutClass != 2) {
            MsgLayout.throwerr("if compressed must use chunked", new Object[0]);
        }
        this.chunkBtree = layoutClass == 2 ? new BtreeNode(compressionLevel, hdfGroup, hdfFile) : null;
    }

    @Override
    public String toString() {
        String res = super.toString();
        res = res + "  layoutClass: " + this.layoutClass;
        for (HdfChunk chunk : this.hdfGroup.hdfChunks) {
            res = res + "  chunk: addr: " + chunk.chunkDataAddr + " size: " + chunk.chunkDataSize;
        }
        return res;
    }

    @Override
    void formatMsgCore(int formatPass, HBuffer fmtBuf) throws HdfException {
        fmtBuf.putBufByte("MsgLayout: layoutVersion", 3);
        fmtBuf.putBufByte("MsgLayout: layoutClass", this.layoutClass);
        if (this.layoutClass == 0) {
            MsgLayout.throwerr("compact not yet implemented", new Object[0]);
        } else if (this.layoutClass == 1) {
            fmtBuf.putBufLong("MsgLayout: contig rawDataAddr", this.hdfGroup.hdfChunks[0].chunkDataAddr);
            fmtBuf.putBufLong("MsgLayout: contig rawDataSize", this.hdfGroup.hdfChunks[0].chunkDataSize);
        } else if (this.layoutClass == 2) {
            fmtBuf.putBufByte("MsgLayout: chunk rank+1", this.hdfGroup.varRank + 1);
            fmtBuf.putBufLong("MsgLayout: chunkBtree.pos", this.chunkBtree.blkPosition);
            if (formatPass != 0) {
                this.hdfFile.addWork("MsgLayout", this.chunkBtree);
            }
            for (int ii = 0; ii < this.hdfGroup.varRank; ++ii) {
                fmtBuf.putBufInt("MsgLayout: chunk dim", this.hdfGroup.specChunkDims[ii]);
            }
            fmtBuf.putBufInt("MsgLayout: chunk elementLen", this.hdfGroup.elementLen);
        } else {
            MsgLayout.throwerr("unknown layoutClass: %d", this.layoutClass);
        }
    }
}

