/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.ral.nujan.hdf;

import edu.ucar.ral.nujan.hdf.HBuffer;
import edu.ucar.ral.nujan.hdf.HdfException;
import edu.ucar.ral.nujan.hdf.HdfFileWriter;
import edu.ucar.ral.nujan.hdf.HdfGroup;
import edu.ucar.ral.nujan.hdf.HdfUtil;
import edu.ucar.ral.nujan.hdf.MsgBase;

class MsgFilter
extends MsgBase {
    static final int FILT_DEFLATE = 1;
    static final int FILT_SHUFFLE = 2;
    static final int FILT_FLETCHER32 = 3;
    static final int FILT_SZIP = 4;
    static final int FILT_NBIT = 5;
    static final int FILT_SCALEOFFSET = 6;
    static final String[] filtNames = new String[]{"UNKNOWN", "deflate", "shuffle", "fletcher32", "szip", "nbit", "scaleoffset"};
    final int filterVersion = 1;
    int filterId;
    int compressionLevel;

    MsgFilter(int filterId, int compressionLevel, HdfGroup hdfGroup, HdfFileWriter hdfFile) throws HdfException {
        super(11, hdfGroup, hdfFile);
        this.filterId = filterId;
        this.compressionLevel = compressionLevel;
        if (filterId != 1) {
            MsgFilter.throwerr("unsupported filterId", new Object[0]);
        }
        if (compressionLevel < 0 || compressionLevel > 9) {
            MsgFilter.throwerr("invalid compressionLevel", new Object[0]);
        }
    }

    @Override
    public String toString() {
        String res = super.toString();
        res = res + "  filterId: " + this.filterId;
        res = res + "  compressionLevel: " + this.compressionLevel;
        return res;
    }

    @Override
    void formatMsgCore(int formatPass, HBuffer fmtBuf) throws HdfException {
        fmtBuf.putBufByte("MsgFilter: filterVersion", 1);
        fmtBuf.putBufByte("MsgFilter: numFilter", 1);
        fmtBuf.putBufShort("MsgFilter: reserved", 0);
        fmtBuf.putBufInt("MsgFilter: reserved", 0);
        String name = filtNames[this.filterId];
        byte[] bytes = HdfUtil.encodeString(name, true, this.hdfGroup);
        int encLen = bytes.length;
        fmtBuf.putBufShort("MsgFilter: filterId", this.filterId);
        fmtBuf.putBufShort("MsgFilter: name len", encLen);
        fmtBuf.putBufShort("MsgFilter: flags", 0);
        fmtBuf.putBufShort("MsgFilter: num client vals", 1);
        fmtBuf.putBufBytes("MsgFilter: name", bytes);
        fmtBuf.putBufInt("MsgFilter: compressionLevel", this.compressionLevel);
        fmtBuf.putBufInt("MsgFilter: reserved", 0);
    }
}

