/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.ral.nujan.hdf;

import edu.ucar.ral.nujan.hdf.HBuffer;
import edu.ucar.ral.nujan.hdf.HdfException;
import edu.ucar.ral.nujan.hdf.HdfFileWriter;
import edu.ucar.ral.nujan.hdf.HdfGroup;
import edu.ucar.ral.nujan.hdf.HdfUtil;
import edu.ucar.ral.nujan.hdf.MsgBase;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class MsgFillValue
extends MsgBase {
    int dtype;
    boolean isFillExtant;
    Object fillValue;
    int elementLen;
    final int fillVersion = 2;
    final int fillAllocTime = 2;
    final int fillWriteTime = 2;
    int fillDefined;
    byte[] fillBytes;

    MsgFillValue(int dtype, boolean isFillExtant, Object fillValue, HdfGroup hdfGroup, HdfFileWriter hdfFile) throws HdfException {
        super(5, hdfGroup, hdfFile);
        this.dtype = dtype;
        this.isFillExtant = isFillExtant;
        this.fillValue = fillValue;
        this.elementLen = 0;
        if (!isFillExtant) {
            if (fillValue != null) {
                MsgFillValue.throwerr("not extant but fillValue != null", new Object[0]);
            }
            this.fillDefined = 0;
            this.fillBytes = null;
        } else if (fillValue == null) {
            this.fillDefined = 1;
            this.fillBytes = null;
        } else {
            if (dtype == 1) {
                this.elementLen = 1;
            } else if (dtype == 2) {
                this.elementLen = 1;
            } else if (dtype == 3) {
                this.elementLen = 2;
            } else if (dtype == 4) {
                this.elementLen = 4;
            } else if (dtype == 5) {
                this.elementLen = 8;
            } else if (dtype == 6) {
                this.elementLen = 4;
            } else if (dtype == 7) {
                this.elementLen = 8;
            } else if (dtype == 9) {
                byte[] bytes = HdfUtil.encodeString((String)fillValue, true, hdfGroup);
                this.elementLen = bytes.length;
            } else if (dtype == 10) {
                this.elementLen = 16;
            } else {
                MsgFillValue.throwerr("illegal dtype for fill value: " + dtype, new Object[0]);
            }
            this.fillDefined = 1;
            this.fillBytes = new byte[this.elementLen];
            ByteBuffer tbuf = ByteBuffer.wrap(this.fillBytes);
            tbuf.order(ByteOrder.LITTLE_ENDIAN);
            if (dtype == 1 || dtype == 2) {
                if (!(fillValue instanceof Byte)) {
                    MsgFillValue.throwerr("fill type mismatch.  Expected: Byte.  Found: " + fillValue.getClass() + "  for group: " + hdfGroup.getPath(), new Object[0]);
                }
                tbuf.put((Byte)fillValue);
            } else if (dtype == 3) {
                if (!(fillValue instanceof Short)) {
                    MsgFillValue.throwerr("fill type mismatch.  Expected: Short.  Found: " + fillValue.getClass() + "  for group: " + hdfGroup.getPath(), new Object[0]);
                }
                tbuf.putShort((Short)fillValue);
            } else if (dtype == 4) {
                if (!(fillValue instanceof Integer)) {
                    MsgFillValue.throwerr("fill type mismatch.  Expected: Integer.  Found: " + fillValue.getClass() + "  for group: " + hdfGroup.getPath(), new Object[0]);
                }
                tbuf.putInt((Integer)fillValue);
            } else if (dtype == 5) {
                if (!(fillValue instanceof Long)) {
                    MsgFillValue.throwerr("fill type mismatch.  Expected: Long.  Found: " + fillValue.getClass() + "  for group: " + hdfGroup.getPath(), new Object[0]);
                }
                tbuf.putLong((Long)fillValue);
            } else if (dtype == 6) {
                if (!(fillValue instanceof Float)) {
                    MsgFillValue.throwerr("fill type mismatch.  Expected: Float.  Found: " + fillValue.getClass() + "  for group: " + hdfGroup.getPath(), new Object[0]);
                }
                tbuf.putFloat(((Float)fillValue).floatValue());
            } else if (dtype == 7) {
                if (!(fillValue instanceof Double)) {
                    MsgFillValue.throwerr("fill type mismatch.  Expected: Double.  Found: " + fillValue.getClass() + "  for group: " + hdfGroup.getPath(), new Object[0]);
                }
                tbuf.putDouble((Double)fillValue);
            } else if (dtype == 9) {
                if (!(fillValue instanceof String)) {
                    MsgFillValue.throwerr("fill type mismatch.  Expected: String.  Found: " + fillValue.getClass() + "  for group: " + hdfGroup.getPath(), new Object[0]);
                }
                byte[] bytes = HdfUtil.encodeString((String)fillValue, true, hdfGroup);
                tbuf.put(bytes);
            } else if (dtype == 10) {
                if (!(fillValue instanceof String)) {
                    MsgFillValue.throwerr("fill type mismatch.  Expected: String.  Found: " + fillValue.getClass() + "  for group: " + hdfGroup.getPath(), new Object[0]);
                }
            } else {
                MsgFillValue.throwerr("unknown dtype for fillValue.  dtype: " + dtype + "  for group: " + hdfGroup.getPath(), new Object[0]);
            }
        }
    }

    @Override
    public String toString() {
        String res = super.toString();
        res = this.fillValue == null ? res + "  fillValue: (null)" : res + "  fillValue: " + this.fillValue + " (" + this.fillValue.getClass() + ")";
        return res;
    }

    @Override
    void formatMsgCore(int formatPass, HBuffer fmtBuf) throws HdfException {
        fmtBuf.putBufByte("MsgFillValue: fillVersion", 2);
        fmtBuf.putBufByte("MsgFillValue: fillAllocTime", 2);
        fmtBuf.putBufByte("MsgFillValue: fillWriteTime", 2);
        fmtBuf.putBufByte("MsgFillValue: fillDefined", this.fillDefined);
        if (this.fillDefined == 1) {
            fmtBuf.putBufInt("MsgFillValue: elementLen", this.elementLen);
            if (this.dtype == 10) {
                byte[] bytes = HdfUtil.encodeString((String)this.fillValue, false, this.hdfGroup);
                int heapIx = this.hdfFile.mainGlobalHeap.putHeapItem("fillValue", bytes);
                fmtBuf.putBufInt("MsgFillValue: vstring len", bytes.length);
                fmtBuf.putBufLong("MsgFillValue: vstring gcol", this.hdfFile.mainGlobalHeap.blkPosition);
                fmtBuf.putBufInt("MsgFillValue: vstring heapIx", heapIx);
            } else {
                for (int ii = 0; ii < this.elementLen; ++ii) {
                    fmtBuf.putBufByte("MsgFillValue: fillBytes", 0xFF & this.fillBytes[ii]);
                }
            }
        }
    }
}

