/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.ral.nujan.hdf;

import edu.ucar.ral.nujan.hdf.HBuffer;
import edu.ucar.ral.nujan.hdf.HdfException;
import edu.ucar.ral.nujan.hdf.HdfFileWriter;
import edu.ucar.ral.nujan.hdf.HdfGroup;
import edu.ucar.ral.nujan.hdf.HdfUtil;
import edu.ucar.ral.nujan.hdf.MsgBase;

class MsgDataType
extends MsgBase {
    int dtype;
    int[] dsubTypes;
    String[] subNames;
    static final int DATATYPE_HDR_LEN = 8;
    static final int TCLS_FIXED = 0;
    static final int TCLS_FLOAT = 1;
    static final int TCLS_TIME = 2;
    static final int TCLS_STRING = 3;
    static final int TCLS_BITFIELD = 4;
    static final int TCLS_OPAQUE = 5;
    static final int TCLS_COMPOUND = 6;
    static final int TCLS_REFERENCE = 7;
    static final int TCLS_ENUMERATED = 8;
    static final int TCLS_VLEN = 9;
    static final int TCLS_ARRAY = 10;
    static final String[] typeClassNames = new String[]{"FIXED", "FLOAT", "TIME", "STRING", "BITFIELD", "OPAQUE", "COMPOUND", "REFERENCE", "ENUMERATED", "VLEN", "ARRAY"};
    int typeVersion;
    int typeClass;
    int typeFlag;
    int elementLen;
    int fixptBitOffset;
    int fixptPrecision;
    int floatBitOffset;
    int floatPrecision;
    int floatExponPos;
    int floatExponLen;
    int floatMantissaPos;
    int floatMantissaLen;
    int floatExponBias;
    MsgDataType[] subMsgs;
    int stgFieldLen;

    MsgDataType(int dtype, int[] dsubTypes, String[] subNames, int stgFieldLen, HdfGroup hdfGroup, HdfFileWriter hdfFile) throws HdfException {
        super(3, hdfGroup, hdfFile);
        this.dtype = dtype;
        this.dsubTypes = dsubTypes;
        this.subNames = subNames;
        this.typeVersion = 1;
        if (hdfFile.bugs >= 5) {
            MsgDataType.prtf("MsgDataType: " + this, new Object[0]);
        }
        if (dtype == 12) {
            if (dsubTypes == null || dsubTypes.length == 0) {
                MsgDataType.throwerr("DTYPE_VLEN: missing dsubTypes", new Object[0]);
            }
            if (subNames != null) {
                MsgDataType.throwerr("DTYPE_VLEN: subNames not null", new Object[0]);
            }
        } else if (dtype == 13) {
            if (dsubTypes == null || dsubTypes.length == 0) {
                MsgDataType.throwerr("DTYPE_COMPOUND: missing dsubTypes", new Object[0]);
            }
            if (subNames == null || subNames.length == 0) {
                MsgDataType.throwerr("DTYPE_COMPOUND: missing subNames", new Object[0]);
            }
            if (dsubTypes.length != subNames.length) {
                MsgDataType.throwerr("DTYPE_COMPOUND: subTypes len != subNames len", new Object[0]);
            }
        } else if (dsubTypes != null) {
            MsgDataType.throwerr("dsubTypes not null", new Object[0]);
        }
        if (dtype == 9 || dtype == 12 && dsubTypes[0] == 9) {
            if (stgFieldLen <= 0) {
                MsgDataType.throwerr("Invalid stgFieldLen for DTYPE_STRING_FIX: must be > 0", new Object[0]);
            }
        } else if (stgFieldLen != 0) {
            MsgDataType.throwerr("Invalid stgFieldLen: must be 0", new Object[0]);
        }
        if (dtype == 1) {
            this.elementLen = 1;
        } else if (dtype == 2) {
            this.elementLen = 1;
        } else if (dtype == 3) {
            this.elementLen = 2;
        } else if (dtype == 4) {
            this.elementLen = 4;
        } else if (dtype == 5) {
            this.elementLen = 8;
        } else if (dtype == 6) {
            this.elementLen = 4;
        } else if (dtype == 7) {
            this.elementLen = 8;
        } else if (dtype == 9) {
            this.elementLen = stgFieldLen;
        } else if (dtype == 11) {
            this.elementLen = 8;
        } else if (dtype == 12) {
            this.elementLen = 16;
        } else if (dtype == 10) {
            this.elementLen = 16;
        } else if (dtype == 13) {
            this.elementLen = 12;
        } else {
            MsgDataType.throwerr("unknown dtype: " + dtype, new Object[0]);
        }
        if (dtype == 1 || dtype == 2 || dtype == 3 || dtype == 4 || dtype == 5) {
            this.typeClass = 0;
            this.typeFlag = 0;
            if (dtype != 2) {
                this.typeFlag |= 8;
            }
            this.fixptBitOffset = 0;
            if (dtype == 1) {
                this.fixptPrecision = 8;
            } else if (dtype == 2) {
                this.fixptPrecision = 8;
            } else if (dtype == 3) {
                this.fixptPrecision = 16;
            } else if (dtype == 4) {
                this.fixptPrecision = 32;
            } else if (dtype == 5) {
                this.fixptPrecision = 64;
            } else {
                MsgDataType.throwerr("unknown type", new Object[0]);
            }
        } else if (dtype == 6) {
            this.typeClass = 1;
            this.typeFlag = 7968;
            this.floatBitOffset = 0;
            this.floatPrecision = 32;
            this.floatExponPos = 23;
            this.floatExponLen = 8;
            this.floatExponBias = 127;
            this.floatMantissaPos = 0;
            this.floatMantissaLen = 23;
        } else if (dtype == 7) {
            this.typeClass = 1;
            this.typeFlag = 16160;
            this.floatBitOffset = 0;
            this.floatPrecision = 64;
            this.floatExponPos = 52;
            this.floatExponLen = 11;
            this.floatExponBias = 1023;
            this.floatMantissaPos = 0;
            this.floatMantissaLen = 52;
        } else if (dtype == 9) {
            this.typeClass = 3;
            this.typeFlag = 0;
        } else if (dtype == 11) {
            this.typeClass = 7;
            this.typeFlag = 0;
        } else if (dtype == 10) {
            this.typeClass = 9;
            this.typeFlag = 1;
            this.subMsgs = new MsgDataType[]{new MsgDataType(2, null, null, 0, hdfGroup, hdfFile)};
        } else if (dtype == 12) {
            if (dsubTypes == null) {
                MsgDataType.throwerr("dsubTypes == null", new Object[0]);
            }
            if (dsubTypes.length != 1) {
                MsgDataType.throwerr("invalid len for dsubTypes: " + dsubTypes.length, new Object[0]);
            }
            this.typeClass = 9;
            this.typeFlag = 0;
            int dsubType = dsubTypes[0];
            this.checkDsubType(dsubType);
            this.subMsgs = new MsgDataType[1];
            this.subMsgs[0] = new MsgDataType(dsubType, null, null, stgFieldLen, hdfGroup, hdfFile);
        } else if (dtype == 13) {
            if (dsubTypes == null) {
                MsgDataType.throwerr("dsubTypes == null", new Object[0]);
            }
            if (dsubTypes.length < 1) {
                MsgDataType.throwerr("invalid len for dsubTypes: " + dsubTypes.length, new Object[0]);
            }
            this.typeClass = 6;
            this.typeFlag = dsubTypes.length;
            this.subMsgs = new MsgDataType[dsubTypes.length];
            for (int ii = 0; ii < dsubTypes.length; ++ii) {
                int dsubType = dsubTypes[ii];
                this.checkDsubType(dsubType);
                this.subMsgs[ii] = new MsgDataType(dsubType, null, null, stgFieldLen, hdfGroup, hdfFile);
            }
        } else {
            MsgDataType.throwerr("unknown dtype: " + dtype, new Object[0]);
        }
    }

    void checkDsubType(int dsubType) throws HdfException {
        if (dsubType != 1 && dsubType != 2 && dsubType != 3 && dsubType != 4 && dsubType != 5 && dsubType != 6 && dsubType != 7 && dsubType != 9 && dsubType != 11) {
            MsgDataType.throwerr("invalid dsubType: " + HdfGroup.dtypeNames[dsubType], new Object[0]);
        }
    }

    @Override
    public String toString() {
        String res = "dtype: " + HdfGroup.dtypeNames[this.dtype];
        if (this.dsubTypes != null) {
            res = res + "  dsubTypes: (";
            for (int isub : this.dsubTypes) {
                res = res + " " + HdfGroup.dtypeNames[isub];
            }
            res = res + ")";
        }
        if (this.subNames != null) {
            res = res + "  subNames: (";
            for (String nm : this.subNames) {
                res = res + " \"" + nm + "\"";
            }
            res = res + ")";
        }
        if (this.hdfFile.bugs >= 10) {
            res = res + "  " + super.toString();
            res = res + "  typeVersion: " + this.typeVersion;
            res = res + "  typeClass: " + typeClassNames[this.typeClass];
            res = res + "  elementLen: " + this.elementLen;
        }
        return res;
    }

    @Override
    void formatMsgCore(int formatPass, HBuffer fmtBuf) throws HdfException {
        if (this.typeVersion != 1) {
            MsgDataType.throwerr("msgType 3 wrong version: %d", this.typeVersion);
        }
        int versionClass = this.typeVersion << 4 | this.typeClass;
        fmtBuf.putBufByte("MsgDataType: typeVersionClass", versionClass);
        int flaga = 0xFF & this.typeFlag;
        int flagb = 0xFF & this.typeFlag >>> 8;
        int flagc = 0xFF & this.typeFlag >>> 16;
        fmtBuf.putBufByte("MsgDataType: typeFlaga", flaga);
        fmtBuf.putBufByte("MsgDataType: typeFlagb", flagb);
        fmtBuf.putBufByte("MsgDataType: typeFlagc", flagc);
        fmtBuf.putBufInt("MsgDataType: elementLen", this.elementLen);
        if (this.typeClass == 0) {
            fmtBuf.putBufShort("MsgDataType: fixptBitOffset", this.fixptBitOffset);
            fmtBuf.putBufShort("MsgDataType: fixptPrecision", this.fixptPrecision);
        } else if (this.typeClass == 1) {
            fmtBuf.putBufShort("MsgDataType: floatBitOffset", this.floatBitOffset);
            fmtBuf.putBufShort("MsgDataType: floatPrecision", this.floatPrecision);
            fmtBuf.putBufByte("MsgDataType: floatExponPos", this.floatExponPos);
            fmtBuf.putBufByte("MsgDataType: floatExponLen", this.floatExponLen);
            fmtBuf.putBufByte("MsgDataType: floatMantissaPos", this.floatMantissaPos);
            fmtBuf.putBufByte("MsgDataType: floatMantissaLen", this.floatMantissaLen);
            fmtBuf.putBufInt("MsgDataType: floatExponBias", this.floatExponBias);
        } else if (this.typeClass != 3 && this.typeClass != 7) {
            if (this.typeClass == 9) {
                if (this.subMsgs == null || this.subMsgs.length != 1) {
                    MsgDataType.throwerr("invalid subType for DTYPE_VLEN or DTYPE_STRING_VAR", new Object[0]);
                }
                MsgDataType subtp = this.subMsgs[0];
                if (this.hdfFile.bugs >= 5) {
                    this.prtIndent("format vlen subtp: msgType: %d  %s  size: %d  flag: 0x%x", subtp.hdrMsgType, hdrMsgTypeNames[subtp.hdrMsgType], subtp.hdrMsgSize, subtp.hdrMsgFlag);
                }
                subtp.formatNakedMsg(formatPass, fmtBuf);
            } else if (this.typeClass == 6) {
                if (this.subMsgs == null || this.subMsgs.length < 1) {
                    MsgDataType.throwerr("invalid subType for DTYPE_COMPOUND", new Object[0]);
                }
                int memberOffset = 0;
                for (int isub = 0; isub < this.subMsgs.length; ++isub) {
                    MsgDataType subtp = this.subMsgs[isub];
                    String subName = this.subNames[isub];
                    if (this.hdfFile.bugs >= 5) {
                        this.prtIndent("format compound subtp: msgType: %d  %s  size: %d  flag: 0x%x  subName: \"%s\"", subtp.hdrMsgType, hdrMsgTypeNames[subtp.hdrMsgType], subtp.hdrMsgSize, subtp.hdrMsgFlag, subName);
                    }
                    byte[] bytes = HdfUtil.encodeString(subName, true, this.hdfGroup);
                    int subFieldLen = bytes.length;
                    fmtBuf.putBufBytes("cmpnd member name", bytes);
                    if (subFieldLen % 8 != 0) {
                        int padLen = 8 - subFieldLen % 8;
                        for (int ii = 0; ii < padLen; ++ii) {
                            fmtBuf.putBufByte("cmpnd name pad", 0);
                        }
                    }
                    fmtBuf.putBufInt("cmpnd memberOffset", memberOffset);
                    fmtBuf.putBufByte("cmpnd rank", 0);
                    fmtBuf.putBufByte("reserved", 0);
                    fmtBuf.putBufShort("reserved", 0);
                    fmtBuf.putBufInt("dim perm", 0);
                    fmtBuf.putBufInt("reserved", 0);
                    fmtBuf.putBufInt("dim 1", 0);
                    fmtBuf.putBufInt("dim 2", 0);
                    fmtBuf.putBufInt("dim 3", 0);
                    fmtBuf.putBufInt("dim 4", 0);
                    subtp.formatNakedMsg(formatPass, fmtBuf);
                    if (subtp.dtype == 4) {
                        memberOffset += 4;
                        continue;
                    }
                    if (subtp.dtype == 11) {
                        memberOffset += 8;
                        continue;
                    }
                    MsgDataType.throwerr("unknown compound subtype: " + subtp.dtype, new Object[0]);
                }
            } else {
                MsgDataType.throwerr("unknown typeClass: %d", this.typeClass);
            }
        }
    }
}

