/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.ral.nujan.hdf;

import edu.ucar.ral.nujan.hdf.BaseBlk;
import edu.ucar.ral.nujan.hdf.HBuffer;
import edu.ucar.ral.nujan.hdf.HdfException;
import edu.ucar.ral.nujan.hdf.HdfFileWriter;
import edu.ucar.ral.nujan.hdf.HdfGroup;
import edu.ucar.ral.nujan.hdf.HdfUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class GlobalHeap
extends BaseBlk {
    static final int GLOB_HEAP_HDR_LEN = 16;
    final int signa = 71;
    final int signb = 67;
    final int signc = 79;
    final int signd = 76;
    final int heapVersion = 1;
    int numItem;
    ByteBuffer dataBuf = ByteBuffer.allocate(4096);
    int colSizeOffset;

    GlobalHeap(HdfFileWriter hdfFile) {
        super("GlobalHeap", hdfFile);
        this.dataBuf.order(ByteOrder.LITTLE_ENDIAN);
        this.clear();
    }

    void clear() {
        this.numItem = 0;
        this.dataBuf.clear();
        this.dataBuf.put((byte)71);
        this.dataBuf.put((byte)67);
        this.dataBuf.put((byte)79);
        this.dataBuf.put((byte)76);
        this.dataBuf.put((byte)1);
        this.dataBuf.put((byte)0);
        this.dataBuf.putShort((short)0);
        this.colSizeOffset = this.dataBuf.position();
        this.dataBuf.putLong(this.dataBuf.capacity());
        if (this.hdfFile.bugs >= 10) {
            this.prtIndent("GlobalHeap.clear: capacity: %d", this.dataBuf.capacity());
        }
    }

    @Override
    public String toString() {
        String res = super.toString();
        res = res + "  numItem: " + this.numItem;
        return res;
    }

    int putHeapItem(String msg, byte[] item) {
        int needLen;
        ++this.numItem;
        if (this.hdfFile.bugs >= 5) {
            this.prtIndent("GlobalHeap.putHeapItem: %s  item len: %d", msg, item.length);
        }
        if ((needLen = this.dataBuf.position() + 100 + item.length) > this.dataBuf.capacity()) {
            if (this.hdfFile.bugs >= 5) {
                this.prtIndent("GlobalHeap.putHeapItem: expand gcol. needLen: " + needLen + "  capacity: " + this.dataBuf.capacity() + "  numItem: " + this.numItem, new Object[0]);
            }
            needLen = (1 + needLen / 4096) * 4096;
            ByteBuffer newBuf = ByteBuffer.allocate(needLen);
            newBuf.order(ByteOrder.LITTLE_ENDIAN);
            byte[] oldVals = new byte[this.dataBuf.position()];
            this.dataBuf.flip();
            this.dataBuf.get(oldVals);
            newBuf.put(oldVals);
            this.dataBuf = newBuf;
            this.dataBuf.putLong(this.colSizeOffset, this.dataBuf.capacity());
        }
        this.dataBuf.putShort((short)this.numItem);
        this.dataBuf.putShort((short)0);
        this.dataBuf.putInt(0);
        this.dataBuf.putLong(item.length);
        this.dataBuf.put(item);
        long alignPos = HdfUtil.alignLong(8L, this.dataBuf.position());
        while ((long)this.dataBuf.position() < alignPos) {
            this.dataBuf.put((byte)0);
        }
        return this.numItem;
    }

    int[] putHeapVlenObject(HdfGroup hdfGroup, int dtype, int dsubType, int stgFieldLen, int[] varDims, Object objValue) throws HdfException {
        if (dtype != 12) {
            GlobalHeap.throwerr("wrong dtype", new Object[0]);
        }
        if (varDims.length != 1) {
            GlobalHeap.throwerr("invalid rank for vlen", new Object[0]);
        }
        int nrow = varDims[0];
        int[] heapIxs = new int[nrow];
        for (int irow = 0; irow < nrow; ++irow) {
            int icol;
            Object objRow = ((Object[])objValue)[irow];
            byte[] heapItem = null;
            if (dsubType == 1 || dsubType == 2) {
                int eleLen = 1;
                byte[] arow = (byte[])objRow;
                int ncol = arow.length;
                heapItem = new byte[eleLen * ncol];
                ByteBuffer tbuf = ByteBuffer.wrap(heapItem);
                tbuf.order(ByteOrder.LITTLE_ENDIAN);
                for (icol = 0; icol < ncol; ++icol) {
                    tbuf.put(arow[icol]);
                }
            } else if (dsubType == 3) {
                int eleLen = 2;
                short[] arow = (short[])objRow;
                int ncol = arow.length;
                heapItem = new byte[eleLen * ncol];
                ByteBuffer tbuf = ByteBuffer.wrap(heapItem);
                tbuf.order(ByteOrder.LITTLE_ENDIAN);
                for (icol = 0; icol < ncol; ++icol) {
                    tbuf.putShort(arow[icol]);
                }
            } else if (dsubType == 4) {
                int eleLen = 4;
                int[] arow = (int[])objRow;
                int ncol = arow.length;
                heapItem = new byte[eleLen * ncol];
                ByteBuffer tbuf = ByteBuffer.wrap(heapItem);
                tbuf.order(ByteOrder.LITTLE_ENDIAN);
                for (icol = 0; icol < ncol; ++icol) {
                    tbuf.putInt(arow[icol]);
                }
            } else if (dsubType == 5) {
                int eleLen = 8;
                long[] arow = (long[])objRow;
                int ncol = arow.length;
                heapItem = new byte[eleLen * ncol];
                ByteBuffer tbuf = ByteBuffer.wrap(heapItem);
                tbuf.order(ByteOrder.LITTLE_ENDIAN);
                for (icol = 0; icol < ncol; ++icol) {
                    tbuf.putLong(arow[icol]);
                }
            } else if (dsubType == 6) {
                int eleLen = 4;
                float[] arow = (float[])objRow;
                int ncol = arow.length;
                heapItem = new byte[eleLen * ncol];
                ByteBuffer tbuf = ByteBuffer.wrap(heapItem);
                tbuf.order(ByteOrder.LITTLE_ENDIAN);
                for (icol = 0; icol < ncol; ++icol) {
                    tbuf.putFloat(arow[icol]);
                }
            } else if (dsubType == 7) {
                int eleLen = 8;
                double[] arow = (double[])objRow;
                int ncol = arow.length;
                heapItem = new byte[eleLen * ncol];
                ByteBuffer tbuf = ByteBuffer.wrap(heapItem);
                tbuf.order(ByteOrder.LITTLE_ENDIAN);
                for (icol = 0; icol < ncol; ++icol) {
                    tbuf.putDouble(arow[icol]);
                }
            } else if (dsubType == 9) {
                String[] arow = (String[])objRow;
                int ncol = arow.length;
                heapItem = new byte[stgFieldLen * ncol];
                ByteBuffer tbuf = ByteBuffer.wrap(heapItem);
                tbuf.order(ByteOrder.LITTLE_ENDIAN);
                for (int icol2 = 0; icol2 < ncol; ++icol2) {
                    byte[] bytes = HdfUtil.encodeString(arow[icol2], true, hdfGroup);
                    tbuf.put(HdfUtil.truncPadNull(bytes, stgFieldLen));
                }
            } else if (dsubType == 11) {
                int eleLen = 8;
                HdfGroup[] arow = (HdfGroup[])objRow;
                int ncol = arow.length;
                heapItem = new byte[eleLen * ncol];
                ByteBuffer tbuf = ByteBuffer.wrap(heapItem);
                tbuf.order(ByteOrder.LITTLE_ENDIAN);
                for (icol = 0; icol < ncol; ++icol) {
                    tbuf.putLong(arow[icol].blkPosition);
                }
            } else {
                GlobalHeap.throwerr("unknown objValue type.  objValue: " + objValue + "  class: " + objValue.getClass(), new Object[0]);
            }
            heapIxs[irow] = this.putHeapItem("vlen item", heapItem);
        }
        return heapIxs;
    }

    @Override
    void formatBuf(int formatPass, HBuffer fmtBuf) throws HdfException {
        this.setFormatEntry(formatPass, true, fmtBuf);
        if (this.hdfFile.bugs >= 5) {
            this.prtIndent("GlobalHeap.formatBuf:  capacity: " + this.dataBuf.capacity() + "  numItem: " + this.numItem, new Object[0]);
        }
        long freeLen = this.dataBuf.capacity() - this.dataBuf.position();
        this.dataBuf.putShort((short)0);
        this.dataBuf.putShort((short)0);
        this.dataBuf.putInt(0);
        this.dataBuf.putLong(freeLen);
        this.dataBuf.put(new byte[(int)freeLen - 16]);
        if (this.hdfFile.bugs >= 5) {
            GlobalHeap.prtf("GlobalHeap.formatBuf: formatPass: %d  numItem: %d", formatPass, this.numItem);
        }
        fmtBuf.putBufBytes("GlobalHeap: dataBuf", this.dataBuf.array());
        this.noteFormatExit(fmtBuf);
    }
}

