/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.ral.nujan.hdf;

import edu.ucar.ral.nujan.hdf.HBuffer;
import edu.ucar.ral.nujan.hdf.HdfException;
import edu.ucar.ral.nujan.hdf.HdfFileWriter;

abstract class BaseBlk {
    long blkPosition;
    String blkName;
    HdfFileWriter hdfFile;

    BaseBlk(String blkName, HdfFileWriter hdfFile) {
        this.blkName = blkName;
        this.hdfFile = hdfFile;
    }

    public String toString() {
        String res = String.format("  blkName: %s  pos: 0x%x", this.blkName, this.blkPosition);
        return res;
    }

    abstract void formatBuf(int var1, HBuffer var2) throws HdfException;

    void setFormatEntry(int formatPass, boolean useAlign, HBuffer fmtBuf) throws HdfException {
        ++this.hdfFile.indent;
        fmtBuf.alignPos("setFormatEntry for " + this.blkName, 8L);
        this.blkPosition = fmtBuf.getPos();
        if (this.hdfFile.bugs >= 5) {
            BaseBlk.prtf(this.hdfFile.formatName("setFormatEntry: " + this.blkName, fmtBuf.getPos()), new Object[0]);
        }
    }

    void noteFormatExit(HBuffer fmtBuf) throws HdfException {
        if (this.hdfFile.bugs >= 5) {
            BaseBlk.prtf(this.hdfFile.formatName("noteFormatExit: " + this.blkName, fmtBuf.getPos()), new Object[0]);
        }
        --this.hdfFile.indent;
    }

    static void throwerr(String msg, Object ... args) throws HdfException {
        throw new HdfException(String.format(msg, args));
    }

    void prtIndent(String msg, Object ... args) {
        BaseBlk.prtf(this.hdfFile.mkIndent() + msg, args);
    }

    static void prtf(String msg, Object ... args) {
        System.out.printf(msg + "\n", args);
    }
}

