/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.pixex.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.core.datamodel.Product;

public class TargetWriterFactoryAndMap {
    private static final String MEASUREMENTS_FILE_NAME_PATTERN = "%s_%s_measurements.txt";
    private final Map<String, PrintWriter> writerMap = new HashMap<String, PrintWriter>();
    private final String filenamePrefix;
    private final File outputDir;

    public TargetWriterFactoryAndMap(String filenamePrefix, File outputDir) {
        this.filenamePrefix = filenamePrefix;
        this.outputDir = outputDir;
    }

    public boolean containsWriterFor(Product product) {
        return this.writerMap.containsKey(product.getProductType());
    }

    public PrintWriter getWriterFor(Product product) {
        return this.writerMap.get(product.getProductType());
    }

    public PrintWriter createWriterFor(Product product) throws IOException {
        String productType = product.getProductType();
        String fileName = String.format(MEASUREMENTS_FILE_NAME_PATTERN, this.filenamePrefix, productType);
        File coordinateFile = new File(this.outputDir, fileName);
        PrintWriter writer = new PrintWriter(new FileOutputStream(coordinateFile));
        this.writerMap.put(productType, writer);
        return writer;
    }

    public void close() {
        Collection<PrintWriter> writerCollection = this.writerMap.values();
        for (PrintWriter printWriter : writerCollection) {
            printWriter.close();
        }
    }
}

