/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.pixex.output;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.measurement.Measurement;
import org.esa.snap.measurement.writer.FormatStrategy;
import org.esa.snap.pixex.output.RasterNamesFactory;

public abstract class AbstractFormatStrategy
implements FormatStrategy {
    private static final String[] STANDARD_COLUMN_NAMES = new String[]{"ProdID", "CoordID", "Name", "Latitude", "Longitude", "PixelX", "PixelY", "Date(yyyy-MM-dd)", "Time(HH_mm_ss)"};
    private static final DateFormat DATE_FORMAT = ProductData.UTC.createDateFormat((String)"yyyy-MM-dd\tHH:mm:ss");
    protected RasterNamesFactory rasterNamesFactory;
    protected String expression;
    protected int windowSize;
    protected boolean exportExpressionResult;
    protected final boolean includeExpressionInTable;

    protected AbstractFormatStrategy(RasterNamesFactory rasterNamesFactory, String expression, int windowSize, boolean exportExpressionResult) {
        this.rasterNamesFactory = rasterNamesFactory;
        this.expression = expression;
        this.windowSize = windowSize;
        this.exportExpressionResult = exportExpressionResult;
        this.includeExpressionInTable = expression != null && exportExpressionResult;
    }

    protected void writeStandardHeader(PrintWriter writer) {
        writer.printf("# SNAP pixel extraction export table%n", new Object[0]);
        writer.printf("#%n", new Object[0]);
        writer.printf(Locale.ENGLISH, "# Window size: %d%n", this.windowSize);
        if (this.expression != null) {
            writer.printf("# Expression: %s%n", this.expression);
        }
        DateFormat dateFormat = ProductData.UTC.createDateFormat((String)"yyyy-MM-dd HH:mm:ss");
        writer.printf(Locale.ENGLISH, "# Created on:\t%s%n%n", dateFormat.format(new Date()));
    }

    protected void writeWavelengthLine(PrintWriter writer, Product product) {
        String[] rasterNames = this.rasterNamesFactory.getRasterNames(product);
        if (product != null) {
            ArrayList<Float> wavelengthList = new ArrayList<Float>();
            for (String rasterName : rasterNames) {
                RasterDataNode rasterDataNode = product.getRasterDataNode(rasterName);
                if (rasterDataNode instanceof Band) {
                    Band band = (Band)rasterDataNode;
                    wavelengthList.add(Float.valueOf(band.getSpectralWavelength()));
                    continue;
                }
                wavelengthList.add(Float.valueOf(0.0f));
            }
            if (!wavelengthList.isEmpty()) {
                Float[] wavelengthArray = wavelengthList.toArray(new Float[wavelengthList.size()]);
                String patternStart = "# Wavelength:";
                int attributeCount = this.getAttributeCount();
                String patternPadding = "";
                for (int i = 0; i < attributeCount; ++i) {
                    patternPadding = patternPadding + "\t ";
                }
                if (this.includeExpressionInTable) {
                    patternPadding = patternPadding + "\t ";
                }
                patternPadding = patternPadding.substring(0, patternPadding.length() - 1);
                writer.printf(Locale.ENGLISH, patternStart + patternPadding + "%s%n", StringUtils.arrayToString((Object)wavelengthArray, (String)"\t"));
            }
        }
    }

    protected void writeStandardColumnNames(PrintWriter writer) {
        if (this.includeExpressionInTable) {
            writer.print("Expression result\t");
        }
        for (int i = 0; i < STANDARD_COLUMN_NAMES.length; ++i) {
            writer.print(STANDARD_COLUMN_NAMES[i]);
            if (i >= STANDARD_COLUMN_NAMES.length - 1) continue;
            writer.print("\t");
        }
    }

    protected void writeRasterNames(PrintWriter writer, Product product) {
        String[] rasterNames;
        for (String name : rasterNames = this.rasterNamesFactory.getRasterNames(product)) {
            writer.printf(Locale.ENGLISH, "\t%s", name);
        }
    }

    protected int getAttributeCount() {
        return STANDARD_COLUMN_NAMES.length;
    }

    protected void writeLine(PrintWriter writer, Measurement measurement, boolean withExpression) {
        ProductData.UTC time;
        if (withExpression) {
            writer.printf(Locale.ENGLISH, "%s\t", String.valueOf(measurement.isValid()));
        }
        String timeString = (time = measurement.getTime()) != null ? DATE_FORMAT.format(time.getAsDate()) : " \t ";
        writer.printf(Locale.ENGLISH, "%d\t%d\t%s\t%.6f\t%.6f\t%.3f\t%.3f\t%s\t", measurement.getProductId(), measurement.getCoordinateID(), measurement.getCoordinateName(), measurement.getLat(), measurement.getLon(), measurement.getPixelX(), measurement.getPixelY(), timeString);
        Object[] values = measurement.getValues();
        this.writeValues(writer, values);
    }

    private void writeValues(PrintWriter writer, Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            this.writeValue(writer, value);
            if (i == values.length - 1) continue;
            writer.print("\t");
        }
    }

    protected void writeValue(PrintWriter writer, Object value) {
        if (value instanceof Number) {
            if (Double.isNaN(((Number)value).doubleValue())) {
                writer.printf(Locale.ENGLISH, "%s", "");
            } else {
                writer.printf(Locale.ENGLISH, "%s", value);
            }
        } else if (value == null) {
            writer.printf(Locale.ENGLISH, "", new Object[0]);
        } else {
            writer.printf(Locale.ENGLISH, value.toString(), new Object[0]);
        }
    }

    @Override
    public void finish() {
    }
}

