/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.pixex;

import com.bc.ceres.binding.converters.DateFormatConverter;
import java.util.Date;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.annotations.Parameter;

public class Coordinate {
    @Parameter(pattern="[a-zA-Z_0-9]*")
    private String name;
    @Parameter(alias="latitude")
    private Double lat;
    @Parameter(alias="longitude")
    private Double lon;
    @Parameter(alias="dateTime", description="The date time of the coordinate in ISO 8601 format.\n The format pattern is 'yyyy-MM-dd'T'HH:mm:ssZ'", converter=ISO8601Converter.class)
    private Date dateTime;
    @Parameter(description="Original values associated with this coordinate.", itemAlias="originalValue")
    private OriginalValue[] originalValues;
    private int id;

    public Coordinate() {
    }

    public Coordinate(String name, Double lat, Double lon, Date dateTime) {
        this(name, lat, lon, dateTime, new OriginalValue[0]);
    }

    public Coordinate(String name, Double lat, Double lon, Date dateTime, OriginalValue[] originalValues) {
        this.name = name;
        this.lat = lat;
        this.lon = lon;
        this.dateTime = dateTime;
        this.originalValues = originalValues;
    }

    public String getName() {
        return this.name;
    }

    public Double getLat() {
        return this.lat;
    }

    public Double getLon() {
        return this.lon;
    }

    public Date getDateTime() {
        if (this.dateTime != null) {
            return (Date)this.dateTime.clone();
        }
        return null;
    }

    public OriginalValue[] getOriginalValues() {
        return this.originalValues;
    }

    public int getID() {
        return this.id;
    }

    public void setID(int ID) {
        this.id = ID;
    }

    public static class OriginalValue {
        @Parameter(description="The name of the variable the original value is associated with.")
        String variableName;
        @Parameter(description="The original value.")
        String value;

        public OriginalValue() {
        }

        public OriginalValue(String variableName, String value) {
            this.variableName = variableName;
            this.value = value;
        }

        public String getVariableName() {
            return this.variableName;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class ISO8601Converter
    extends DateFormatConverter {
        public ISO8601Converter() {
            super(ProductData.UTC.createDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss"));
        }
    }
}

