/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.measurement.writer;

import java.awt.image.Raster;
import java.io.IOException;
import java.io.PrintWriter;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.measurement.Measurement;
import org.esa.snap.measurement.writer.FormatStrategy;
import org.esa.snap.measurement.writer.MeasurementFactory;
import org.esa.snap.pixex.output.TargetWriterFactoryAndMap;

public class MeasurementWriter {
    private final MeasurementFactory measurementFactory;
    private final TargetWriterFactoryAndMap targetFactory;
    private final FormatStrategy formatStrategy;
    private boolean closed;

    public MeasurementWriter(MeasurementFactory measurementFactory, TargetWriterFactoryAndMap targetFactory, FormatStrategy formatStrategy) {
        this.measurementFactory = measurementFactory;
        this.targetFactory = targetFactory;
        this.formatStrategy = formatStrategy;
        this.closed = false;
    }

    public void writeMeasurements(int pixelX, int pixelY, int coordinateID, String coordinateName, Product product, Raster validData) throws IOException {
        PrintWriter writer;
        if (this.closed) {
            throw new IllegalStateException("Writer is closed.");
        }
        Measurement[] measurements = this.measurementFactory.createMeasurements(pixelX, pixelY, coordinateID, coordinateName, product, validData);
        if (this.targetFactory.containsWriterFor(product)) {
            writer = this.targetFactory.getWriterFor(product);
        } else {
            writer = this.targetFactory.createWriterFor(product);
            this.formatStrategy.writeHeader(writer, product);
        }
        this.formatStrategy.writeMeasurements(product, writer, measurements);
        if (writer.checkError()) {
            throw new IOException("Error occurred while writing measurement.");
        }
    }

    public void close() {
        this.measurementFactory.close();
        this.targetFactory.close();
        this.measurementFactory.close();
        this.closed = true;
    }
}

