/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.measurement;

import java.util.Arrays;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.ObjectUtils;

public class Measurement {
    private final ProductData.UTC time;
    private final GeoPos geoPos;
    private final Object[] values;
    private final int coordinateID;
    private final long productId;
    private final double pixelX;
    private final double pixelY;
    private final String coordinateName;
    private final boolean isValid;
    private final String[] originalAttributeNames;

    public Measurement(int coordinateID, String name, long productId, double pixelX, double pixelY, ProductData.UTC time, GeoPos geoPos, Object[] values, boolean isValid) {
        this(coordinateID, name, productId, pixelX, pixelY, time, geoPos, values, null, isValid);
    }

    public Measurement(int coordinateID, String name, long productId, double pixelX, double pixelY, ProductData.UTC time, GeoPos geoPos, Object[] values, String[] originalAttributeNames, boolean isValid) {
        this.coordinateID = coordinateID;
        this.productId = productId;
        this.pixelX = pixelX;
        this.pixelY = pixelY;
        this.coordinateName = name;
        this.time = time;
        this.geoPos = geoPos;
        this.isValid = isValid;
        this.values = new Object[values.length];
        System.arraycopy(values, 0, this.values, 0, values.length);
        this.originalAttributeNames = originalAttributeNames;
    }

    public ProductData.UTC getTime() {
        return this.time;
    }

    public Object[] getValues() {
        return this.values;
    }

    public double getLat() {
        return this.geoPos.lat;
    }

    public double getLon() {
        return this.geoPos.lon;
    }

    public int getCoordinateID() {
        return this.coordinateID;
    }

    public String getCoordinateName() {
        return this.coordinateName;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public double getPixelX() {
        return this.pixelX;
    }

    public double getPixelY() {
        return this.pixelY;
    }

    public long getProductId() {
        return this.productId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Measurement that = (Measurement)o;
        if (this.coordinateID != that.coordinateID) {
            return false;
        }
        if (this.isValid != that.isValid) {
            return false;
        }
        if (Double.compare(that.pixelX, this.pixelX) != 0) {
            return false;
        }
        if (Double.compare(that.pixelY, this.pixelY) != 0) {
            return false;
        }
        if (this.productId != that.productId) {
            return false;
        }
        if (!this.coordinateName.equals(that.coordinateName)) {
            return false;
        }
        if (!this.geoPos.equals((Object)that.geoPos)) {
            return false;
        }
        if (!ObjectUtils.equalObjects((Object)this.time, (Object)that.time)) {
            return false;
        }
        return Arrays.equals(this.values, that.values);
    }

    public int hashCode() {
        int result = this.time != null ? this.time.hashCode() : 139651030;
        result = 31 * result + this.geoPos.hashCode();
        result = 31 * result + Arrays.hashCode(this.values);
        result = 31 * result + this.coordinateID;
        result = 31 * result + (int)this.productId;
        result = 31 * result + (this.pixelX == 0.0 ? 0 : (int)Double.doubleToLongBits(this.pixelX));
        result = 31 * result + (this.pixelY == 0.0 ? 0 : (int)Double.doubleToLongBits(this.pixelY));
        result = 31 * result + this.coordinateName.hashCode();
        result = 31 * result + (this.isValid ? 1 : 0);
        return result;
    }

    public String toString() {
        return "Measurement{time=" + this.time + ", geoPos=" + this.geoPos + ", values=" + (this.values == null ? null : Arrays.asList(this.values)) + ", coordinateID=" + this.coordinateID + ", productId=" + this.productId + ", pixelX=" + this.pixelX + ", pixelY=" + this.pixelY + ", coordinateName='" + this.coordinateName + '\'' + ", isValid=" + this.isValid + '}';
    }

    public String[] getOriginalAttributeNames() {
        return this.originalAttributeNames;
    }
}

