/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.classification.gpf.maximumlikelihood;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.Map;
import org.esa.snap.classification.gpf.BaseClassifier;
import org.esa.snap.classification.gpf.SupervisedClassifier;
import org.esa.snap.classification.gpf.maximumlikelihood.MaximumLikelihoodClassifier;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProducts;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;

@OperatorMetadata(alias="Maximum-Likelihood-Classifier", category="Raster/Classification/Supervised Classification", authors="Cecilia Wong, Luis Veci", copyright="Copyright (C) 2016 by Array Systems Computing Inc.", description="Maximum Likelihood classifier")
public class MaximumLikelihoodClassifierOp
extends Operator {
    public static final String CLASSIFIER_TYPE = "MaximumLikelihood";
    private static final String PRODUCT_SUFFIX = "_MLClass";
    @SourceProducts
    private Product[] sourceProducts;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The number of training samples", interval="(1,*]", defaultValue="5000", label="Number of training samples")
    private int numTrainSamples = 5000;
    @Parameter(description="The saved classifier name", label="Classifier name")
    private String savedClassifierName = null;
    @Parameter(defaultValue="true", description="Quantization for raster traiing")
    private Boolean doClassValQuantization = true;
    @Parameter(defaultValue="0.0", description="Quantization min class value for raster traiing")
    private Double minClassValue = 0.0;
    @Parameter(defaultValue="5.0", description="Quantization step size for raster traiing")
    private Double classValStepSize = 5.0;
    @Parameter(defaultValue="101", description="Quantization class levels for raster traiing")
    private int classLevels = 101;
    @Parameter(defaultValue="true", description="Train on raster or vector data")
    private Boolean trainOnRaster;
    @Parameter(description="Raster bands to train on", label="Raster Classes")
    private String[] trainingBands;
    @Parameter(description="Vectors to train on", label="Vector Classes")
    private String[] trainingVectors;
    @Parameter(description="Names of bands to be used as features", label="Features")
    private String[] featureBands;
    @Parameter(description="'VectorNodeName' or specific Attribute name", label="Label source")
    private String labelSource;
    @Parameter(description="Evaluate classifier and features", label="Evaluate Classifier")
    private Boolean evaluateClassifier;
    @Parameter(description="Evaluate the power set of features", label="Evaluate Feature Power Set", defaultValue="false")
    private Boolean evaluateFeaturePowerSet;
    private SupervisedClassifier classifier;

    public void initialize() throws OperatorException {
        try {
            this.classifier = new MaximumLikelihoodClassifier(new BaseClassifier.ClassifierParams(CLASSIFIER_TYPE, PRODUCT_SUFFIX, this.sourceProducts, this.numTrainSamples, this.minClassValue, this.classValStepSize, this.classLevels, this.savedClassifierName, this.doClassValQuantization, this.trainOnRaster, this.trainingBands, this.trainingVectors, this.featureBands, this.labelSource, this.evaluateClassifier, this.evaluateFeaturePowerSet));
            this.classifier.initialize();
            this.targetProduct = this.classifier.createTargetProduct();
        }
        catch (Exception e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    public void computeTileStack(Map<Band, Tile> targetTileMap, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            this.classifier.computeTileStack(this, targetTileMap, targetRectangle, pm);
        }
        catch (Exception e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(MaximumLikelihoodClassifierOp.class);
        }
    }
}

