/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envisat;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.snap.core.util.Debug;
import org.esa.snap.dataio.envisat.Field;
import org.esa.snap.dataio.envisat.RecordInfo;

public class Record {
    private final RecordInfo _info;
    private final Field[] _fields;

    private Record(RecordInfo info) {
        Debug.assertTrue((info != null ? 1 : 0) != 0);
        this._info = info;
        this._fields = new Field[info.getNumFieldInfos()];
        for (int i = 0; i < this._fields.length; ++i) {
            this._fields[i] = info.getFieldInfoAt(i).createField();
        }
    }

    public static Record create(RecordInfo info) {
        return new Record(info);
    }

    public final RecordInfo getInfo() {
        return this._info;
    }

    public final String getName() {
        return this.getInfo().getName();
    }

    public final int getSizeInBytes() {
        return this.getInfo().getSizeInBytes();
    }

    public final int getNumFields() {
        return this._fields.length;
    }

    public final Field getFieldAt(int index) throws ArrayIndexOutOfBoundsException {
        return this._fields[index];
    }

    public final Field getField(String fieldName) {
        int index = this.getFieldIndex(fieldName);
        return index >= 0 ? this.getFieldAt(index) : null;
    }

    public final int getFieldIndex(String fieldName) {
        return this.getInfo().getFieldInfoIndex(fieldName);
    }

    public void readFrom(ImageInputStream dataInputStream) throws IOException {
        for (Field _field : this._fields) {
            _field.readFrom(dataInputStream);
        }
    }

    public String toString() {
        int n = this.getNumFields();
        StringBuffer sb = new StringBuffer(32 + 32 * n);
        sb.append("Record('");
        sb.append(this.getName());
        sb.append("')[\n");
        for (int i = 0; i < n; ++i) {
            sb.append("  ");
            sb.append(this.getFieldAt(i).toString());
            if (i < n - 1) {
                sb.append(',');
            }
            sb.append('\n');
        }
        sb.append(']');
        return sb.toString();
    }
}

