/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envisat;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.Guardian;
import org.esa.snap.dataio.envisat.FieldInfo;

public class Field {
    private final FieldInfo _info;
    private final ProductData _data;

    protected Field(FieldInfo info) {
        Guardian.assertNotNull((String)"info", (Object)info);
        this._info = info;
        this._data = ProductData.createInstance((int)info.getDataType(), (int)info.getNumDataElems());
        if (this._data == null) {
            throw new IllegalArgumentException("field info has an unknown data type");
        }
    }

    public final FieldInfo getInfo() {
        return this._info;
    }

    public final ProductData getData() {
        return this._data;
    }

    public final String getName() {
        return this.getInfo().getName();
    }

    public final int getDataType() {
        return this.getInfo().getDataType();
    }

    public final int getNumElems() {
        return this.getInfo().getNumDataElems();
    }

    public final boolean isIntType() {
        return this._data.isInt();
    }

    public int getElemInt(int index) {
        return this.getData().getElemIntAt(index);
    }

    public long getElemLong(int index) {
        return this.getData().getElemUIntAt(index);
    }

    public float getElemFloat(int index) {
        return this.getData().getElemFloatAt(index);
    }

    public double getElemDouble(int index) {
        return this.getData().getElemDoubleAt(index);
    }

    public Object getElems() {
        return this.getData().getElems();
    }

    public void setValue(Object data) {
        this.getData().setElems(data);
    }

    public void readFrom(ImageInputStream dataInputStream) throws IOException {
        this.getData().readFrom(dataInputStream);
    }

    public String getAsString() {
        return this.getData().getElemString();
    }

    public void setValueAsText(String text) {
        throw new IllegalStateException("Field.setAsText() yet not implemented");
    }

    public String toString() {
        int n = this.getInfo().getNumDataElems();
        StringBuffer sb = new StringBuffer(4 + 4 * n);
        sb.append("Field('");
        sb.append(this.getName());
        sb.append("')[");
        if (this.getElems() instanceof ProductData.ASCII) {
            sb.append('\"');
            sb.append(this.getAsString());
            sb.append('\"');
        } else {
            sb.append(this.getAsString());
        }
        sb.append("]");
        return sb.toString();
    }
}

