/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envisat;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.esa.snap.core.dataio.IllegalFileFormatException;
import org.esa.snap.core.dataio.ProductIOException;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.dataio.envisat.AsarXCAProductFile;
import org.esa.snap.dataio.envisat.DorisOrbitProductFile;
import org.esa.snap.dataio.envisat.EnvisatProductReaderPlugIn;
import org.esa.snap.dataio.envisat.Field;
import org.esa.snap.dataio.envisat.ProductFile;
import org.esa.snap.dataio.envisat.Record;

public class EnvisatAuxReader {
    protected ProductFile _productFile;

    public void readProduct(Object input) throws IOException {
        File file;
        if (input instanceof String) {
            file = EnvisatAuxReader.getFile((String)input);
        } else if (input instanceof File) {
            file = (File)input;
            file = EnvisatAuxReader.getFile(file.getAbsolutePath());
        } else {
            throw new IllegalArgumentException("input");
        }
        ImageInputStream iis = EnvisatAuxReader.getImageInputStream(file);
        String productType = ProductFile.readProductType(iis);
        if (productType == null) {
            throw new IllegalFileFormatException("Not an ENVISAT product or ENVISAT product type not supported: " + file.toString());
        }
        String productTypeUC = productType.toUpperCase().substring(0, 9);
        if (productTypeUC.startsWith("AS")) {
            this._productFile = new AsarXCAProductFile(file, iis);
        } else if (productTypeUC.startsWith("DOR")) {
            this._productFile = new DorisOrbitProductFile(file, iis);
        } else {
            throw new IllegalFileFormatException("Not an ENVISAT product or ENVISAT product type not supported.");
        }
    }

    public Date getSensingStart() {
        return this._productFile.getSensingStart();
    }

    public Date getSensingStop() {
        return this._productFile.getSensingStop();
    }

    public ProductData getAuxData(String name) throws ProductIOException {
        if (this._productFile == null) {
            throw new ProductIOException("Auxiliary data file has not been read yet");
        }
        Record gads = this._productFile.getGADS();
        if (gads == null) {
            throw new IllegalFileFormatException("GADS not found in Auxiliary data file");
        }
        Field field = gads.getField(name);
        if (field == null) {
            return null;
        }
        return field.getData();
    }

    public void close() throws IOException {
        if (this._productFile != null) {
            this._productFile.close();
            this._productFile = null;
        }
    }

    public static File getFile(String filePath) throws FileNotFoundException {
        String[] exts;
        File file = null;
        for (String ext : exts = new String[]{"", ".gz", ".zip"}) {
            URI fileUri = EnvisatAuxReader.getFileURI(filePath + ext);
            if (fileUri != null && (file = new File(fileUri)).exists() || (file = new File(filePath + ext)).exists()) break;
        }
        if (file == null) {
            throw new FileNotFoundException("ENVISAT product not found: " + filePath);
        }
        return file;
    }

    private static ImageInputStream getImageInputStream(File file) throws IOException {
        String name = file.getName().toLowerCase();
        if (name.endsWith(".zip") || name.endsWith(".gz")) {
            return new FileCacheImageInputStream(EnvisatProductReaderPlugIn.getInflaterInputStream(file), null);
        }
        return new FileImageInputStream(file);
    }

    private static URI getFileURI(String filePath) {
        URI fileUri = null;
        URL fileUrl = EnvisatAuxReader.class.getClassLoader().getResource(filePath);
        if (fileUrl != null) {
            try {
                fileUri = fileUrl.toURI();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return fileUri;
    }
}

