/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envisat;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.imageio.stream.ImageInputStream;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.dataio.envisat.DSD;
import org.esa.snap.dataio.envisat.EnvisatProductReader;
import org.esa.snap.dataio.envisat.ProductFile;
import org.esa.snap.dataio.envisat.Record;

public class DorisOrbitProductFile
extends ProductFile {
    private static final String ORBIT_RECORD_NAME = "DORIS_Orbit";

    protected DorisOrbitProductFile(File file, ImageInputStream dataInputStream) throws IOException {
        super(file, dataInputStream);
    }

    @Override
    public String getGADSName() {
        return null;
    }

    @Override
    protected void postProcessMPH(Map parameters) throws IOException {
    }

    @Override
    protected void postProcessSPH(Map parameters) throws IOException {
        DSD dsd = this.getDSDAt(0);
        if (dsd != null) {
            int num = dsd.getNumRecords();
            parameters.put("NUM_DSR", num);
        }
    }

    public Record readOrbitData() throws IOException {
        return this.getRecordReader(ORBIT_RECORD_NAME).readRecord();
    }

    @Override
    public String getProductType() {
        return this.getProductId().substring(0, 10).toUpperCase();
    }

    @Override
    public boolean isValidDatasetName(String name) throws IOException {
        String[] datasetNames = this.getValidDatasetNames();
        return name.equalsIgnoreCase(this.getGADSName()) || StringUtils.containsIgnoreCase((String[])datasetNames, (String)name);
    }

    @Override
    public void setInvalidPixelExpression(Band band) {
        band.setNoDataValueUsed(false);
        band.setNoDataValue(0.0);
    }

    @Override
    public float[] getSpectralBandWavelengths() {
        return null;
    }

    @Override
    public float[] getSpectralBandBandwidths() {
        return null;
    }

    @Override
    public float[] getSpectralBandSolarFluxes() {
        return null;
    }

    @Override
    public Mask[] createDefaultMasks(String dsName) {
        return new Mask[0];
    }

    @Override
    public ProductData.UTC getSceneRasterStartTime() {
        return null;
    }

    @Override
    public ProductData.UTC getSceneRasterStopTime() {
        return null;
    }

    @Override
    public int getSceneRasterWidth() {
        return 0;
    }

    @Override
    public int getSceneRasterHeight() {
        return 0;
    }

    @Override
    public float getTiePointGridOffsetX(int gridWidth) {
        return 0.0f;
    }

    @Override
    public float getTiePointGridOffsetY(int gridWidth) {
        return 0.0f;
    }

    @Override
    public float getTiePointSubSamplingX(int gridWidth) {
        return 0.0f;
    }

    @Override
    public float getTiePointSubSamplingY(int gridWidth) {
        return 0.0f;
    }

    @Override
    public boolean storesPixelsInChronologicalOrder() {
        return false;
    }

    @Override
    protected void addCustomMetadata(Product product) throws IOException {
        MetadataElement root = product.getMetadataRoot();
        Record orbitRecord = this.readOrbitData();
        MetadataElement elem = EnvisatProductReader.createMetadataGroup("Orbit Vectors", orbitRecord);
        root.addElement(elem);
    }
}

